/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.items.storage;

import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.StorageDiskSyncData;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.item.ProcessorItem;
import com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem;
import com.refinedmods.refinedstorage.render.Styles;
import edivad.extrastorage.blocks.AdvancedFluidStorageBlock;
import edivad.extrastorage.items.storage.fluid.ExpandedStorageDiskFluid;
import edivad.extrastorage.items.storage.fluid.FluidStorageType;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public class AdvancedFluidStorageBlockItem
extends BaseBlockItem {
    private final FluidStorageType type;

    public AdvancedFluidStorageBlockItem(AdvancedFluidStorageBlock block, Item.Properties builder) {
        super((BaseBlock)block, builder);
        this.type = block.getType();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (this.isValid(stack)) {
            UUID id = this.getId(stack);
            API.instance().getStorageDiskSync().sendRequest(id);
            StorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.storage.stored", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}).m_6270_(Styles.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.storage.stored_capacity", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}).m_6270_(Styles.GRAY));
                }
            }
            if (flag.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)id.toString()).m_6270_(Styles.GRAY));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack storageStack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6047_()) {
            UUID diskId = null;
            IStorageDisk disk = null;
            if (this.isValid(storageStack)) {
                diskId = this.getId(storageStack);
                disk = API.instance().getStorageDiskManager((ServerLevel)level).get(diskId);
            }
            if (disk == null || disk.getStored() == 0) {
                ItemStack fluidStoragePart = new ItemStack((ItemLike)ExpandedStorageDiskFluid.getPartById(this.type));
                if (!player.m_150109_().m_36054_(fluidStoragePart.m_41777_())) {
                    Containers.m_18992_((Level)level, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)fluidStoragePart);
                }
                ItemStack processor = new ItemStack((ItemLike)((RegistryObject)RSItems.PROCESSORS.get(ProcessorItem.Type.BASIC)).get());
                if (!player.m_150109_().m_36054_(processor.m_41777_())) {
                    Containers.m_18992_((Level)level, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)processor);
                }
                ItemStack bucket = new ItemStack((ItemLike)Items.f_42446_);
                if (!player.m_150109_().m_36054_(bucket.m_41777_())) {
                    Containers.m_18992_((Level)level, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)bucket);
                }
                if (disk != null) {
                    API.instance().getStorageDiskManager((ServerLevel)level).remove(diskId);
                    API.instance().getStorageDiskManager((ServerLevel)level).markForSaving();
                }
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)new ItemStack((ItemLike)RSBlocks.MACHINE_CASING.get()));
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)storageStack);
    }

    public int getEntityLifespan(ItemStack itemStack, Level level) {
        return Integer.MAX_VALUE;
    }

    private UUID getId(ItemStack disk) {
        return disk.m_41783_().m_128342_("Id");
    }

    private boolean isValid(ItemStack disk) {
        return disk.m_41782_() && disk.m_41783_().m_128403_("Id");
    }
}

