/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.AppEngInternalInventory;
import com.glodblock.github.extendedae.api.IPage;
import com.glodblock.github.extendedae.client.ExSemantics;
import com.glodblock.github.extendedae.client.gui.widget.SingleFakeSlot;
import com.glodblock.github.extendedae.common.inventory.PatternModifierInventory;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ContainerPatternModifier
extends AEBaseMenu
implements IPage,
IActionHolder {
    private final Map<String, Consumer<Paras>> actions = this.createHolder();
    public static final MenuType<ContainerPatternModifier> TYPE = MenuTypeBuilder.create(ContainerPatternModifier::new, PatternModifierInventory.class).build("pattern_modifier");
    public final AppEngSlot targetSlot;
    public final AppEngSlot cloneSlot;
    public final AppEngSlot replaceTarget;
    public final AppEngSlot replaceWith;
    @GuiSync(value=1)
    public int page;

    public ContainerPatternModifier(int id, Inventory playerInventory, PatternModifierInventory host) {
        super(TYPE, id, playerInventory, (Object)host);
        this.createPlayerInventorySlots(playerInventory);
        AppEngInternalInventory patternInv = host.getInventoryByName("patternInv");
        for (int x = 0; x < patternInv.size(); ++x) {
            this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, (InternalInventory)patternInv, x), SlotSemantics.ENCODED_PATTERN);
        }
        AppEngInternalInventory targetInv = host.getInventoryByName("targetInv");
        AppEngInternalInventory blankPatternInv = host.getInventoryByName("blankPatternInv");
        AppEngInternalInventory clonePatternInv = host.getInventoryByName("clonePatternInv");
        AppEngInternalInventory replaceInv = host.getInventoryByName("replaceInv");
        this.targetSlot = (AppEngSlot)this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, (InternalInventory)targetInv, 0), ExSemantics.EX_1);
        this.cloneSlot = (AppEngSlot)this.addSlot((Slot)new OutputSlot((InternalInventory)clonePatternInv, 0, null), ExSemantics.EX_2);
        this.replaceTarget = (AppEngSlot)this.addSlot((Slot)new SingleFakeSlot((InternalInventory)replaceInv, 0), ExSemantics.EX_4);
        this.replaceWith = (AppEngSlot)this.addSlot((Slot)new SingleFakeSlot((InternalInventory)replaceInv, 1), ExSemantics.EX_5);
        for (int x = 0; x < blankPatternInv.size(); ++x) {
            this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, (InternalInventory)blankPatternInv, x), ExSemantics.EX_3);
        }
        this.actions.put("clear", o -> this.clear());
        this.actions.put("clone", o -> this.clonePattern());
        this.actions.put("modify", o -> this.modify((Integer)o.get(0), (Boolean)o.get(1)));
        this.actions.put("replace", o -> this.replace());
        this.actions.put("show", o -> this.showPage());
    }

    public void showPage() {
        AppEngSlot as;
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            if (!(slot instanceof AppEngSlot)) continue;
            as = (AppEngSlot)slot;
            as.setSlotEnabled(this.page == 0 || this.page == 1);
        }
        this.replaceTarget.setSlotEnabled(this.page == 1);
        this.replaceWith.setSlotEnabled(this.page == 1);
        this.targetSlot.setSlotEnabled(this.page == 2);
        this.cloneSlot.setSlotEnabled(this.page == 2);
        for (Slot slot : this.getSlots(ExSemantics.EX_3)) {
            if (!(slot instanceof AppEngSlot)) continue;
            as = (AppEngSlot)slot;
            as.setSlotEnabled(this.page == 2);
        }
    }

    public void replace() {
        ItemStack replace = this.replaceTarget.m_7993_();
        ItemStack with = this.replaceWith.m_7993_();
        if (replace.m_41619_() || with.m_41619_()) {
            return;
        }
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            EncodedPatternItem pattern;
            IPatternDetails detail;
            ItemStack stack = slot.m_7993_();
            Item item = stack.m_41720_();
            if (!(item instanceof EncodedPatternItem) || !((detail = (pattern = (EncodedPatternItem)item).decode(stack, this.getPlayer().m_9236_(), false)) instanceof AEProcessingPattern)) continue;
            AEProcessingPattern process = (AEProcessingPattern)detail;
            GenericStack[] input = process.getSparseInputs();
            GenericStack[] output = process.getOutputs();
            GenericStack[] replaceInput = new GenericStack[input.length];
            GenericStack[] replaceOutput = new GenericStack[output.length];
            this.replace(input, replaceInput, new GenericStack((AEKey)AEItemKey.of((ItemStack)replace), 1L), new GenericStack((AEKey)AEItemKey.of((ItemStack)with), 1L));
            this.replace(output, replaceOutput, new GenericStack((AEKey)AEItemKey.of((ItemStack)replace), 1L), new GenericStack((AEKey)AEItemKey.of((ItemStack)with), 1L));
            ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern((GenericStack[])replaceInput, (GenericStack[])replaceOutput);
            slot.m_5852_(newPattern);
        }
    }

    public void clear() {
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            ItemStack stack = slot.m_7993_();
            if (!(stack.m_41720_() instanceof EncodedPatternItem)) continue;
            slot.m_5852_(AEItems.BLANK_PATTERN.stack());
        }
    }

    public void clonePattern() {
        EncodedPatternItem pattern;
        IPatternDetails detail;
        ItemStack target = this.targetSlot.m_7993_();
        ItemStack clone = this.cloneSlot.m_7993_();
        Item item = target.m_41720_();
        if (item instanceof EncodedPatternItem && (detail = (pattern = (EncodedPatternItem)item).decode(target, this.getPlayer().m_9236_(), false)) != null) {
            ItemStack newPattern = target.m_41777_();
            if (clone.m_41619_()) {
                if (this.consumeBlankPattern()) {
                    this.cloneSlot.m_5852_(newPattern);
                }
            } else if (clone.m_41720_() instanceof EncodedPatternItem) {
                this.cloneSlot.m_5852_(newPattern);
            }
        }
    }

    public void modify(int scale, boolean div) {
        if (scale <= 0) {
            return;
        }
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            EncodedPatternItem pattern;
            IPatternDetails detail;
            ItemStack stack = slot.m_7993_();
            Item item = stack.m_41720_();
            if (!(item instanceof EncodedPatternItem) || !((detail = (pattern = (EncodedPatternItem)item).decode(stack, this.getPlayer().m_9236_(), false)) instanceof AEProcessingPattern)) continue;
            AEProcessingPattern process = (AEProcessingPattern)detail;
            GenericStack[] input = process.getSparseInputs();
            GenericStack[] output = process.getOutputs();
            if (!this.checkModify(input, scale, div) || !this.checkModify(output, scale, div)) continue;
            GenericStack[] mulInput = new GenericStack[input.length];
            GenericStack[] mulOutput = new GenericStack[output.length];
            this.modifyStacks(input, mulInput, scale, div);
            this.modifyStacks(output, mulOutput, scale, div);
            ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern((GenericStack[])mulInput, (GenericStack[])mulOutput);
            slot.m_5852_(newPattern);
        }
    }

    private boolean checkModify(GenericStack[] stacks, int scale, boolean div) {
        if (div) {
            for (GenericStack stack : stacks) {
                if (stack == null || stack.amount() % (long)scale == 0L) continue;
                return false;
            }
        } else {
            for (GenericStack stack : stacks) {
                if (stack == null) continue;
                long upper = 999999L * (long)stack.what().getAmountPerUnit();
                if (stack.amount() * (long)scale <= upper) continue;
                return false;
            }
        }
        return true;
    }

    private void modifyStacks(GenericStack[] stacks, GenericStack[] des, int scale, boolean div) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            long amt = div ? stacks[i].amount() / (long)scale : stacks[i].amount() * (long)scale;
            des[i] = new GenericStack(stacks[i].what(), amt);
        }
    }

    private void replace(GenericStack[] stacks, GenericStack[] des, GenericStack replace, GenericStack with) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            des[i] = stacks[i].what().matches(replace) ? new GenericStack(with.what(), stacks[i].amount()) : new GenericStack(stacks[i].what(), stacks[i].amount());
        }
    }

    private boolean consumeBlankPattern() {
        for (Slot slot : this.getSlots(ExSemantics.EX_3)) {
            ItemStack stack = slot.m_7993_();
            if (stack.m_41619_() || !AEItems.BLANK_PATTERN.isSameAs(stack)) continue;
            stack.m_41774_(1);
            if (stack.m_41613_() <= 0) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @NotNull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.actions;
    }
}

