/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.stacks.GenericStack;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.capabilities.Capabilities;
import appeng.helpers.externalstorage.GenericStackInv;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileIngredientBuffer
extends AEBaseBlockEntity {
    private final GenericStackInv buffer = new GenericStackInv(() -> ((TileIngredientBuffer)this).m_6596_(), 36);
    private static AEKeyType MEK;
    private static AEKeyType BOT;

    public TileIngredientBuffer(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileIngredientBuffer.class, TileIngredientBuffer::new, (Block)EPPItemAndBlock.INGREDIENT_BUFFER), pos, blockState);
        this.buffer.setCapacity(AEKeyType.fluids(), 64000L);
        if (MEK != null) {
            this.buffer.setCapacity(MEK, 64000L);
        }
        if (BOT != null) {
            this.buffer.setCapacity(BOT, 1000L);
        }
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (int index = 0; index < this.buffer.size(); ++index) {
            GenericStack stack = this.buffer.getStack(index);
            if (stack == null) continue;
            stack.what().addDrops(stack.amount(), drops, level, pos);
        }
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.buffer.writeToChildTag(data, "buffer");
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.buffer.readFromChildTag(data, "buffer");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == Capabilities.GENERIC_INTERNAL_INV) {
            return LazyOptional.of(() -> this.buffer).cast();
        }
        return super.getCapability(capability, facing);
    }

    public GenericStackInv getInventory() {
        return this.buffer;
    }

    static {
        try {
            MEK = AEKeyTypes.get((ResourceLocation)new ResourceLocation("appmek:chemical"));
        }
        catch (Exception e) {
            MEK = null;
        }
        try {
            BOT = AEKeyTypes.get((ResourceLocation)new ResourceLocation("appbot:mana"));
        }
        catch (Exception e) {
            BOT = null;
        }
    }
}

