/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.util;

import appeng.api.parts.IPart;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.networking.CableBusBlockEntity;
import com.github.glodblock.epp.util.HashUtil;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenCustomHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IForgeRegistry;

public class FCUtil {
    private static final Object2ReferenceMap<Class<?>, BlockEntityType<? extends BlockEntity>> TILE_CACHE = new Object2ReferenceOpenCustomHashMap(HashUtil.CLASS);

    public static <T extends BlockEntity> BlockEntityType<T> getTileType(Class<T> clazz, BlockEntityType.BlockEntitySupplier<? extends T> supplier, Block block) {
        if (block == null) {
            return (BlockEntityType)TILE_CACHE.get(clazz);
        }
        return (BlockEntityType)TILE_CACHE.computeIfAbsent(clazz, k -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{block}).m_58966_(null));
    }

    public static <T extends BlockEntity> BlockEntityType<T> getTileType(Class<T> clazz) {
        if (!TILE_CACHE.containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("%s isn't an EPP tile entity!", clazz.getName()));
        }
        return (BlockEntityType)TILE_CACHE.get(clazz);
    }

    public static void replaceTile(Level world, BlockPos pos, BlockEntity oldTile, BlockEntity newTile, BlockState newBlock) {
        CompoundTag contents = oldTile.serializeNBT();
        world.m_46747_(pos);
        world.m_7471_(pos, false);
        world.m_7731_(pos, newBlock, 3);
        world.m_151523_(newTile);
        newTile.deserializeNBT(contents);
        if (newTile instanceof AEBaseBlockEntity) {
            AEBaseBlockEntity aeTile = (AEBaseBlockEntity)newTile;
            aeTile.markForUpdate();
        } else {
            newTile.m_6596_();
        }
    }

    public static IPart getPart(BlockEntity te, Direction face) {
        if (te instanceof CableBusBlockEntity) {
            CableBusBlockEntity cable = (CableBusBlockEntity)te;
            return cable.getPart(face);
        }
        return null;
    }

    public static boolean checkInvalidRL(String rl, IForgeRegistry<?> registry) {
        return FCUtil.checkInvalidRL(new ResourceLocation(rl), registry);
    }

    public static boolean checkInvalidRL(ResourceLocation rl, IForgeRegistry<?> registry) {
        return registry.containsKey(rl);
    }

    public static double clamp(double num, double floor, double ceil) {
        return Math.min(ceil, Math.max(floor, num));
    }
}

