/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.network.packet.sync;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public final class ParaSerializer {
    public static void to(Object[] obj, FriendlyByteBuf buf) {
        buf.writeByte(obj.length);
        for (Object o : obj) {
            if (o instanceof Integer) {
                Integer i = (Integer)o;
                buf.writeByte(PT.INT.ordinal());
                buf.m_130130_(i.intValue());
                continue;
            }
            if (o instanceof Long) {
                Long l = (Long)o;
                buf.writeByte(PT.LONG.ordinal());
                buf.m_130103_(l.longValue());
                continue;
            }
            if (o instanceof Short) {
                Short s = (Short)o;
                buf.writeByte(PT.SHORT.ordinal());
                buf.writeShort((int)s.shortValue());
                continue;
            }
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                buf.writeByte(PT.BOOLEN.ordinal());
                buf.writeBoolean(b.booleanValue());
                continue;
            }
            if (o instanceof String) {
                String s = (String)o;
                buf.writeByte(PT.STRING.ordinal());
                buf.m_130072_(s, 1024);
                continue;
            }
            if (o instanceof ItemStack) {
                ItemStack s = (ItemStack)o;
                buf.writeByte(PT.STACK.ordinal());
                buf.writeItemStack(s, true);
                continue;
            }
            throw new IllegalArgumentException("Args contains invalid type: " + o.getClass().getName());
        }
    }

    public static Object[] from(FriendlyByteBuf buf) {
        Object[] objs = new Object[buf.readByte()];
        block8: for (int i = 0; i < objs.length; ++i) {
            switch (PT.values()[buf.readByte()]) {
                case INT: {
                    objs[i] = buf.m_130242_();
                    continue block8;
                }
                case LONG: {
                    objs[i] = buf.m_130258_();
                    continue block8;
                }
                case SHORT: {
                    objs[i] = buf.readShort();
                    continue block8;
                }
                case BOOLEN: {
                    objs[i] = buf.readBoolean();
                    continue block8;
                }
                case STRING: {
                    objs[i] = buf.m_130136_(1024);
                    continue block8;
                }
                case STACK: {
                    objs[i] = buf.m_130267_();
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Args contains unknown type.");
                }
            }
        }
        return objs;
    }

    private static enum PT {
        INT,
        LONG,
        SHORT,
        BOOLEN,
        STRING,
        STACK;

    }
}

