/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.network;

import appeng.core.sync.network.TargetPoint;
import com.github.glodblock.epp.EPP;
import com.github.glodblock.epp.network.packet.CGenericPacket;
import com.github.glodblock.epp.network.packet.CPatternKey;
import com.github.glodblock.epp.network.packet.CUpdatePage;
import com.github.glodblock.epp.network.packet.IMessage;
import com.github.glodblock.epp.network.packet.SAssemblerAnimation;
import com.github.glodblock.epp.network.packet.SExPatternInfo;
import com.github.glodblock.epp.network.packet.SGenericPacket;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;

public class EPPNetworkHandler {
    private static final ResourceLocation channel = EPP.id("network");
    static int id = 0;
    public static final EPPNetworkHandler INSTANCE = new EPPNetworkHandler();
    private final Consumer<IMessage<?>> clientHandler;
    private final Int2ObjectMap<Supplier<IMessage<?>>> packetFactoryMap = new Int2ObjectOpenHashMap();
    private final Object2IntMap<Class<?>> packetIDMap = new Object2IntOpenHashMap();

    public EPPNetworkHandler() {
        EventNetworkChannel ec = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channel).networkProtocolVersion(() -> "1").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).eventNetworkChannel();
        ec.addListener(this::clientPacket);
        ec.addListener(this::serverPacket);
        this.clientHandler = (Consumer)DistExecutor.unsafeRunForDist(() -> () -> EPPNetworkHandler::onClientPacketData, () -> () -> pkt -> {});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onClientPacketData(IMessage<?> packet) {
        if (packet.isClient()) {
            packet.onMessage((Player)Minecraft.m_91087_().f_91074_);
        }
    }

    public void init() {
        this.registerPacket(SExPatternInfo.class, SExPatternInfo::new);
        this.registerPacket(SAssemblerAnimation.class, SAssemblerAnimation::new);
        this.registerPacket(SGenericPacket.class, SGenericPacket::new);
        this.registerPacket(CPatternKey.class, CPatternKey::new);
        this.registerPacket(CUpdatePage.class, CUpdatePage::new);
        this.registerPacket(CGenericPacket.class, CGenericPacket::new);
    }

    private void registerPacket(Class<?> clazz, Supplier<IMessage<?>> factory) {
        this.packetIDMap.put(clazz, id);
        this.packetFactoryMap.put(id, factory);
        ++id;
    }

    public void serverPacket(NetworkEvent.ClientCustomPayloadEvent ev) {
        try {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ev.getSource().get();
            ctx.setPacketHandled(true);
            FriendlyByteBuf bytes = ev.getPayload();
            IMessage packet = (IMessage)((Supplier)this.packetFactoryMap.get(bytes.m_130242_())).get();
            packet.fromBytes(bytes);
            ServerPlayer player = ctx.getSender();
            ctx.enqueueWork(() -> {
                try {
                    packet.onMessage((Player)player);
                }
                catch (IllegalArgumentException e) {
                    EPP.LOGGER.warn(e.getMessage());
                }
            });
        }
        catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
            // empty catch block
        }
    }

    public void clientPacket(NetworkEvent.ServerCustomPayloadEvent ev) {
        if (ev instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
            return;
        }
        if (this.clientHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)ev.getSource().get();
                ctx.setPacketHandled(true);
                FriendlyByteBuf bytes = ev.getPayload();
                IMessage packet = (IMessage)((Supplier)this.packetFactoryMap.get(bytes.m_130242_())).get();
                packet.fromBytes(bytes);
                ctx.enqueueWork(() -> this.clientHandler.accept(packet));
            }
            catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
                // empty catch block
            }
        }
    }

    public void sendToAll(IMessage<?> message) {
        MinecraftServer server = EPP.INSTANCE.getServer();
        if (server != null) {
            server.m_6846_().m_11268_(this.toFMLPacket(message, NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    public void sendTo(IMessage<?> message, ServerPlayer player) {
        player.f_8906_.m_9829_(this.toFMLPacket(message, NetworkDirection.PLAY_TO_CLIENT));
    }

    public void sendToAllAround(IMessage<?> message, TargetPoint point) {
        MinecraftServer server = EPP.INSTANCE.getServer();
        if (server != null) {
            Packet<?> pkt = this.toFMLPacket(message, NetworkDirection.PLAY_TO_CLIENT);
            server.m_6846_().m_11241_((Player)point.excluded, point.x, point.y, point.z, point.r2, point.level.m_46472_(), pkt);
        }
    }

    public void sendToServer(IMessage<?> message) {
        assert (Minecraft.m_91087_().m_91403_() != null);
        Minecraft.m_91087_().m_91403_().m_104955_(this.toFMLPacket(message, NetworkDirection.PLAY_TO_SERVER));
    }

    public Packet<?> toFMLPacket(IMessage<?> message, NetworkDirection direction) {
        FriendlyByteBuf bytes = new FriendlyByteBuf(Unpooled.buffer((int)1024));
        int id = this.packetIDMap.getOrDefault(message.getPacketClass(), -1);
        if (id == -1) {
            EPP.LOGGER.error(String.format("Unregistered Packet: %s", message.getPacketClass()));
        }
        bytes.m_130130_(id);
        message.toBytes(bytes);
        return direction.buildPacket(Pair.of((Object)bytes, (Object)0), channel).getThis();
    }
}

