/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.tileentities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.blockentity.crafting.MolecularAssemblerBlockEntity;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.capabilities.Capabilities;
import appeng.client.render.crafting.AssemblerAnimationStatus;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.TargetPoint;
import appeng.util.inv.CombinedInternalInventory;
import com.github.glodblock.epp.common.EPPItemAndBlock;
import com.github.glodblock.epp.common.me.CraftingThread;
import com.github.glodblock.epp.network.EPPNetworkHandler;
import com.github.glodblock.epp.network.packet.SAssemblerAnimation;
import com.github.glodblock.epp.util.FCUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileExMolecularAssembler
extends AENetworkInvBlockEntity
implements IUpgradeableObject,
IGridTickable,
ICraftingMachine,
IPowerChannelState {
    public static final int MAX_THREAD = 8;
    private final IUpgradeInventory upgrades;
    private boolean isPowered = false;
    private final CraftingThread[] threads = new CraftingThread[8];
    private final InternalInventory internalInv;
    private final InternalInventory gridInvExt;
    @OnlyIn(value=Dist.CLIENT)
    private AssemblerAnimationStatus animationStatus;

    public TileExMolecularAssembler(BlockPos pos, BlockState blockState) {
        super(FCUtil.getTileType(TileExMolecularAssembler.class, TileExMolecularAssembler::new, (Block)EPPItemAndBlock.EX_ASSEMBLER), pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.upgrades = UpgradeInventories.forMachine((ItemLike)EPPItemAndBlock.EX_ASSEMBLER, (int)this.getUpgradeSlots(), () -> ((TileExMolecularAssembler)this).saveChanges());
        ArrayList<InternalInventory> invs = new ArrayList<InternalInventory>();
        ArrayList<InternalInventory> invs2 = new ArrayList<InternalInventory>();
        for (int x = 0; x < 8; ++x) {
            this.threads[x] = new CraftingThread(this);
            invs.add(this.threads[x].getInternalInventory());
            invs2.add(this.threads[x].getExposedInventoryForSide());
        }
        this.internalInv = new CombinedInternalInventory(invs.toArray(new InternalInventory[0]));
        this.gridInvExt = new CombinedInternalInventory(invs2.toArray(new InternalInventory[0]));
    }

    public int getUpgradeSlots() {
        return 5;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    public PatternContainerGroup getCraftingMachineInfo() {
        Component name = this.m_8077_() ? this.m_7770_() : EPPItemAndBlock.EX_ASSEMBLER.m_5456_().m_41466_();
        AEItemKey icon = AEItemKey.of((ItemLike)EPPItemAndBlock.EX_ASSEMBLER);
        int accelerationCards = this.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD);
        List<Object> tooltip = accelerationCards == 0 ? List.of() : List.of(GuiText.CompatibleUpgrade.text(new Object[]{Tooltips.of((Component)AEItems.SPEED_CARD.m_5456_().m_41466_()), Tooltips.ofUnformattedNumber((long)accelerationCards)}));
        return new PatternContainerGroup(icon, name, tooltip);
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputs, Direction ejectionDirection) {
        for (CraftingThread thread : this.threads) {
            if (!thread.acceptJob(patternDetails, inputs, ejectionDirection)) continue;
            return true;
        }
        return false;
    }

    public boolean acceptsPlans() {
        return true;
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        for (int x = 0; x < 8; ++x) {
            CompoundTag tag = this.threads[x].writeNBT();
            data.m_128365_("#ct" + x, (Tag)tag);
        }
        this.upgrades.writeToNBT(data, "upgrades");
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
        for (int x = 0; x < 8; ++x) {
            if (!data.m_128441_("#ct" + x)) continue;
            this.threads[x].readNBT(data.m_128469_("#ct" + x));
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        if (id.equals((Object)MolecularAssemblerBlockEntity.INV_MAIN)) {
            return this.internalInv;
        }
        return super.getSubInventory(id);
    }

    public InternalInventory getCraftInventory(int index) {
        return this.threads[index].getInternalInventory();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        boolean isAwake = false;
        for (CraftingThread t : this.threads) {
            t.recalculatePlan();
            t.updateSleepiness();
            isAwake |= t.isAwake();
        }
        return new TickingRequest(1, 1, !isAwake, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        TickRateModulation rate = TickRateModulation.SLEEP;
        ItemStack firstJob = ItemStack.f_41583_;
        int cards = this.upgrades.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD);
        for (CraftingThread t : this.threads) {
            if (!t.isAwake()) continue;
            TickRateModulation tr = t.tick(cards, ticksSinceLastCall);
            if (tr.ordinal() > rate.ordinal()) {
                rate = tr;
            }
            if (!firstJob.m_41619_()) continue;
            firstJob = t.getOutput();
        }
        AEItemKey item = AEItemKey.of((ItemStack)firstJob);
        if (item != null) {
            TargetPoint where = new TargetPoint((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 32.0, this.f_58857_);
            EPPNetworkHandler.INSTANCE.sendToAllAround(new SAssemblerAnimation(this.f_58858_, 50, (AEKey)item), where);
        }
        return rate;
    }

    public InternalInventory getInternalInventory() {
        return this.internalInv;
    }

    protected InternalInventory getExposedInventoryForSide(Direction side) {
        return this.gridInvExt;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        for (CraftingThread t : this.threads) {
            if (inv != t.getInternalInventory()) continue;
            t.recalculatePlan();
            break;
        }
    }

    public int getCraftingProgress(int index) {
        return this.threads[index].getCraftingProgress();
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    public void m_6211_() {
        super.m_6211_();
        this.upgrades.clear();
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            boolean newState = false;
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                boolean bl = newState = this.getMainNode().isPowered() && grid.getEnergyService().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
            }
            if (newState != this.isPowered) {
                this.isPowered = newState;
                this.markForUpdate();
            }
        }
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (Capabilities.CRAFTING_MACHINE == capability) {
            return Capabilities.CRAFTING_MACHINE.orEmpty(capability, LazyOptional.of(() -> this));
        }
        return super.getCapability(capability, facing);
    }

    public IMolecularAssemblerSupportedPattern getCurrentPattern(int index) {
        return this.threads[index].getCurrentPattern();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setAnimationStatus(@Nullable AssemblerAnimationStatus status) {
        this.animationStatus = status;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public AssemblerAnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }
}

