/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.tileentities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.blockentity.misc.ChargerRecipes;
import appeng.blockentity.powersink.AEBasePoweredBlockEntity;
import appeng.capabilities.Capabilities;
import appeng.core.AEConfig;
import appeng.core.settings.TickRates;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.github.glodblock.epp.common.EPPItemAndBlock;
import com.github.glodblock.epp.common.me.Crankable;
import com.github.glodblock.epp.util.FCUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileExCharger
extends AENetworkPowerBlockEntity
implements IGridTickable {
    public static final int POWER_MAXIMUM_AMOUNT = 3200;
    public static final int MAX_THREAD = 4;
    private static final int POWER_THRESHOLD = 3199;
    private boolean working;
    private final AppEngInternalInventory inv = new AppEngInternalInventory((InternalInventoryHost)this, 4, 1, (IAEItemFilter)new ChargerInvFilter(this));

    public TileExCharger(BlockPos pos, BlockState blockState) {
        super(FCUtil.getTileType(TileExCharger.class, TileExCharger::new, (Block)EPPItemAndBlock.EX_CHARGER), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(3200.0);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.complementOf(EnumSet.of(orientation.getSide(RelativeSide.FRONT)));
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        this.working = data.readBoolean();
        for (int x = 0; x < 4; ++x) {
            if (data.readBoolean()) {
                AEItemKey item = AEItemKey.fromPacket((FriendlyByteBuf)data);
                this.inv.setItemDirect(x, item.toStack());
                continue;
            }
            this.inv.setItemDirect(x, ItemStack.f_41583_);
        }
        return changed;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.working);
        for (int x = 0; x < 4; ++x) {
            AEItemKey is = AEItemKey.of((ItemStack)this.inv.getStackInSlot(x));
            data.writeBoolean(is != null);
            if (is == null) continue;
            is.writeToPacket(data);
        }
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(orientation));
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Charger, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.doWork(ticksSinceLastCall);
        return TickRateModulation.FASTER;
    }

    public boolean isWorking() {
        return this.working;
    }

    @Nullable
    public ICrankable getCrankable(Direction direction) {
        if (direction != this.getFront()) {
            return new Crankable((AEBasePoweredBlockEntity)this);
        }
        return null;
    }

    private void doWork(int ticksSinceLastCall) {
        boolean wasWorking = this.working;
        this.working = false;
        boolean changed = false;
        for (int x = 0; x < 4; ++x) {
            ItemStack myItem = this.inv.getStackInSlot(x);
            if (!myItem.m_41619_()) {
                if (Platform.isChargeable((ItemStack)myItem)) {
                    double maxPower;
                    IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.m_41720_();
                    double currentPower = ps.getAECurrentPower(myItem);
                    if (currentPower < (maxPower = ps.getAEMaxPower(myItem))) {
                        double chargeRate = ps.getChargeRate(myItem) * (double)ticksSinceLastCall * AEConfig.instance().getChargerChargeRate();
                        double extractedAmount = this.extractAEPower(chargeRate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                        double missingChargeRate = chargeRate - extractedAmount;
                        double missingAEPower = maxPower - currentPower;
                        double toExtract = Math.min(missingChargeRate, missingAEPower);
                        IGrid grid2 = this.getMainNode().getGrid();
                        if (grid2 != null) {
                            extractedAmount += grid2.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                        }
                        if (extractedAmount > 0.0) {
                            double adjustment = ps.injectAEPower(myItem, extractedAmount, Actionable.MODULATE);
                            this.setInternalCurrentPower(this.getInternalCurrentPower() + adjustment);
                            this.working = true;
                            changed = true;
                        }
                    }
                } else if (this.getInternalCurrentPower() > 3199.0 && ChargerRecipes.findRecipe((Level)this.f_58857_, (ItemStack)myItem) != null) {
                    this.working = true;
                    if (Platform.getRandomFloat() > 0.8f) {
                        this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                        Item charged = Objects.requireNonNull(ChargerRecipes.findRecipe((Level)this.f_58857_, (ItemStack)myItem)).result;
                        this.inv.setItemDirect(x, new ItemStack((ItemLike)charged));
                        changed = true;
                    }
                }
            }
            if (!(this.getInternalCurrentPower() < 3199.0)) continue;
            this.getMainNode().ifPresent(grid -> {
                double toExtract = Math.min(800.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = grid.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnits.AE, extracted, Actionable.MODULATE);
            });
            changed = true;
        }
        if (changed || this.working != wasWorking) {
            this.markForUpdate();
        }
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        this.markForUpdate();
    }

    public void activate(Player player) {
        ItemStack stored;
        int x;
        if (!Platform.hasPermissions((DimensionalBlockPos)new DimensionalBlockPos((BlockEntity)this), (Player)player)) {
            return;
        }
        for (x = 0; x < 4; ++x) {
            stored = this.inv.getStackInSlot(x);
            if (!stored.m_41619_()) continue;
            ItemStack held = player.m_150109_().m_36056_();
            assert (this.f_58857_ != null);
            if (ChargerRecipes.findRecipe((Level)this.f_58857_, (ItemStack)held) == null && !Platform.isChargeable((ItemStack)held)) continue;
            held = player.m_150109_().m_7407_(player.m_150109_().f_35977_, 1);
            this.inv.setItemDirect(x, held);
            return;
        }
        for (x = 0; x < 4; ++x) {
            stored = this.inv.getStackInSlot(x);
            if (stored.m_41619_()) continue;
            List<ItemStack> drops = List.of(stored);
            this.inv.setItemDirect(x, ItemStack.f_41583_);
            Platform.spawnDrops((Level)player.m_9236_(), (BlockPos)this.f_58858_.m_121945_(this.getFront()), drops);
            return;
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (Capabilities.CRANKABLE.equals(capability)) {
            ICrankable crankable = this.getCrankable(facing);
            if (crankable == null) {
                return LazyOptional.empty();
            }
            return Capabilities.CRANKABLE.orEmpty(capability, LazyOptional.of(() -> crankable));
        }
        return super.getCapability(capability, facing);
    }

    private record ChargerInvFilter(TileExCharger chargerBlockEntity) implements IAEItemFilter
    {
        public boolean allowInsert(InternalInventory inv, int i, ItemStack itemstack) {
            if (Platform.isChargeable((ItemStack)itemstack)) {
                return true;
            }
            assert (this.chargerBlockEntity.f_58857_ != null);
            return ChargerRecipes.allowInsert((Level)this.chargerBlockEntity.f_58857_, (ItemStack)itemstack);
        }

        public boolean allowExtract(InternalInventory inv, int slotIndex, int amount) {
            IAEItemPowerStorage ips;
            ItemStack extractedItem = inv.getStackInSlot(slotIndex);
            if (Platform.isChargeable((ItemStack)extractedItem) && (ips = (IAEItemPowerStorage)extractedItem.m_41720_()).getAECurrentPower(extractedItem) >= ips.getAEMaxPower(extractedItem)) {
                return true;
            }
            assert (this.chargerBlockEntity.f_58857_ != null);
            return ChargerRecipes.allowExtract((Level)this.chargerBlockEntity.f_58857_, (ItemStack)extractedItem);
        }
    }
}

