/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.parts;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.AccessRestriction;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.capabilities.Capabilities;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.core.stats.AdvancementTriggers;
import appeng.helpers.IPriorityHost;
import appeng.helpers.InterfaceLogicHost;
import appeng.items.parts.PartModels;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.CompositeStorage;
import appeng.me.storage.ITickingMonitor;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.NullInventory;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartAdjacentApi;
import appeng.parts.PartModel;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.prioritylist.IPartitionList;
import com.github.glodblock.epp.common.me.taglist.TagExpParser;
import com.github.glodblock.epp.common.me.taglist.TagPriorityList;
import com.github.glodblock.epp.container.ContainerTagStorageBus;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PartTagStorageBus
extends UpgradeablePart
implements IGridTickable,
IStorageProvider,
IPriorityHost {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("expatternprovider", "part/tag_storage_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_has_channel")});
    protected final IActionSource source;
    private final StorageBusInventory handler = new StorageBusInventory(NullInventory.of());
    @Nullable
    private Component handlerDescription;
    private final PartAdjacentApi<MEStorage> adjacentStorageAccessor;
    @Nullable
    private Map<AEKeyType, ExternalStorageStrategy> externalStorageStrategies;
    private boolean wasOnline = false;
    private int priority = 0;
    private String oreExp = "";
    private PendingUpdateStatus updateStatus = PendingUpdateStatus.FAST_UPDATE;
    private ITickingMonitor monitor = null;
    private TagPriorityList filter = null;

    public PartTagStorageBus(IPartItem<?> partItem) {
        super(partItem);
        this.adjacentStorageAccessor = new PartAdjacentApi((AEBasePart)this, Capabilities.STORAGE);
        this.getConfigManager().registerSetting(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        this.getConfigManager().registerSetting(Settings.STORAGE_FILTER, (Enum)StorageFilter.EXTRACTABLE_ONLY);
        this.getConfigManager().registerSetting(Settings.FILTER_ON_EXTRACT, (Enum)YesNo.YES);
        this.source = new MachineSource((IActionHost)this);
        this.getMainNode().addService(IStorageProvider.class, (IGridNodeService)this).addService(IGridTickable.class, (IGridNodeService)this);
    }

    protected final void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentOnline = this.getMainNode().isOnline();
        if (this.wasOnline != currentOnline) {
            this.wasOnline = currentOnline;
            this.getHost().markForUpdate();
            this.remountStorage();
        }
    }

    private void remountStorage() {
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.forceUpdate();
        this.getHost().markForSave();
    }

    public final void upgradesChanged() {
        super.upgradesChanged();
        this.forceUpdate();
    }

    private void scheduleUpdate() {
        if (this.isClientSide()) {
            return;
        }
        this.updateStatus = PendingUpdateStatus.FAST_UPDATE;
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.priority = data.m_128451_("priority");
        this.oreExp = data.m_128461_("oreExp");
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128405_("priority", this.priority);
        data.m_128359_("oreExp", this.oreExp);
    }

    public final boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (!this.isClientSide()) {
            this.openConfigMenu(player);
        }
        return true;
    }

    protected final void openConfigMenu(Player player) {
        MenuOpener.open(this.getMenuType(), (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(this.getMenuType(), (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)this.getPartItem());
    }

    public MenuType<?> getMenuType() {
        return ContainerTagStorageBus.TYPE;
    }

    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    protected final int getUpgradeSlots() {
        return 2;
    }

    public final float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public final void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (pos.m_121945_(this.getSide()).equals((Object)neighbor)) {
            BlockEntity te = level.m_7702_(neighbor);
            if (te == null) {
                this.updateTarget(false);
            } else {
                this.scheduleUpdate();
            }
        }
    }

    public final TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.StorageBus, false, true);
    }

    public final TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.updateStatus != PendingUpdateStatus.NO_UPDATE) {
            this.updateTarget(false);
        }
        if (this.monitor != null) {
            return this.monitor.onTick();
        }
        return this.updateStatus == PendingUpdateStatus.SLOW_UPDATE ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
    }

    private boolean hasRegisteredCellToNetwork() {
        return this.getMainNode().isOnline() && !(this.handler.getDelegate() instanceof NullInventory);
    }

    public Component getConnectedToDescription() {
        return this.handlerDescription;
    }

    public void setTagFilter(String exp) {
        if (!exp.equals(this.oreExp)) {
            this.oreExp = exp;
            this.filter = null;
            this.forceUpdate();
        }
    }

    public String getTagFilter() {
        return this.oreExp;
    }

    private void forceUpdate() {
        if (this.getMainNode().isReady()) {
            this.updateTarget(true);
        }
    }

    private void updateTarget(boolean forceFullUpdate) {
        ITickingMonitor tickingMonitor;
        MEStorage newInventory;
        MEStorage mEStorage;
        if (this.isClientSide()) {
            return;
        }
        MEStorage foundMonitor = null;
        Map<AEKeyType, MEStorage> foundExternalApi = Collections.emptyMap();
        if (Platform.areBlockEntitiesTicking((Level)this.getLevel(), (BlockPos)this.getBlockEntity().m_58899_().m_121945_(this.getSide()))) {
            this.updateStatus = PendingUpdateStatus.NO_UPDATE;
            foundMonitor = (MEStorage)this.adjacentStorageAccessor.find();
            if (foundMonitor == null) {
                foundExternalApi = new IdentityHashMap(2);
                this.findExternalStorages(foundExternalApi);
            }
        } else {
            this.updateStatus = PendingUpdateStatus.SLOW_UPDATE;
        }
        if (!forceFullUpdate && (mEStorage = this.handler.getDelegate()) instanceof CompositeStorage) {
            CompositeStorage compositeStorage = (CompositeStorage)mEStorage;
            if (!foundExternalApi.isEmpty()) {
                compositeStorage.setStorages(foundExternalApi);
                this.handlerDescription = compositeStorage.getDescription();
                return;
            }
        }
        if (!forceFullUpdate && foundMonitor == this.handler.getDelegate()) {
            return;
        }
        boolean wasSleeping = this.monitor == null;
        boolean wasRegistered = this.hasRegisteredCellToNetwork();
        if (foundMonitor != null) {
            newInventory = foundMonitor;
            this.checkStorageBusOnInterface();
            this.handlerDescription = newInventory.getDescription();
        } else if (!foundExternalApi.isEmpty()) {
            newInventory = new CompositeStorage(foundExternalApi);
            this.handlerDescription = newInventory.getDescription();
        } else {
            newInventory = NullInventory.of();
            this.handlerDescription = null;
        }
        this.handler.setDelegate(newInventory);
        this.handler.setAccessRestriction((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS));
        this.handler.setWhitelist(this.isUpgradedWith((ItemLike)AEItems.INVERTER_CARD) ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.handler.setPartitionList(this.createFilter());
        this.handler.setVoidOverflow(this.isUpgradedWith((ItemLike)AEItems.VOID_CARD));
        boolean filterOnExtract = this.getConfigManager().getSetting(Settings.FILTER_ON_EXTRACT) == YesNo.YES;
        this.handler.setExtractFiltering(filterOnExtract, this.isExtractableOnly() && filterOnExtract);
        this.monitor = newInventory instanceof ITickingMonitor ? (tickingMonitor = (ITickingMonitor)newInventory) : null;
        if (wasSleeping != (this.monitor == null)) {
            this.getMainNode().ifPresent((grid, node) -> {
                ITickManager tm = grid.getTickManager();
                if (this.monitor == null) {
                    tm.sleepDevice(node);
                } else {
                    tm.wakeDevice(node);
                }
            });
        }
        if (wasRegistered != this.hasRegisteredCellToNetwork()) {
            this.remountStorage();
        }
    }

    private boolean isExtractableOnly() {
        return this.getConfigManager().getSetting(Settings.STORAGE_FILTER) == StorageFilter.EXTRACTABLE_ONLY;
    }

    private IPartitionList createFilter() {
        if (this.filter == null) {
            this.filter = new TagPriorityList(TagExpParser.getMatchingOre(this.oreExp), this.oreExp);
        }
        return this.filter;
    }

    private void findExternalStorages(Map<AEKeyType, MEStorage> storages) {
        boolean extractableOnly = this.isExtractableOnly();
        for (Map.Entry<AEKeyType, ExternalStorageStrategy> entry : this.getExternalStorageStrategies().entrySet()) {
            MEStorage wrapper = entry.getValue().createWrapper(extractableOnly, this::invalidateOnExternalStorageChange);
            if (wrapper == null) continue;
            storages.put(entry.getKey(), wrapper);
        }
    }

    private void invalidateOnExternalStorageChange() {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    private void checkStorageBusOnInterface() {
        MinecraftServer server;
        ServerPlayer player;
        BlockEntity targetBe;
        Direction oppositeSide = this.getSide().m_122424_();
        BlockPos targetPos = this.getBlockEntity().m_58899_().m_121945_(this.getSide());
        BlockEntity targetHost = targetBe = this.getLevel().m_7702_(targetPos);
        if (targetBe instanceof IPartHost) {
            IPartHost partHost = (IPartHost)targetBe;
            targetHost = partHost.getPart(oppositeSide);
        }
        if (targetHost instanceof InterfaceLogicHost && (player = IPlayerRegistry.getConnected((MinecraftServer)(server = this.getLevel().m_7654_()), (int)this.getActionableNode().getOwningPlayerId())) != null) {
            AdvancementTriggers.RECURSIVE.trigger(player);
        }
    }

    public void mountInventories(IStorageMounts mounts) {
        if (this.hasRegisteredCellToNetwork()) {
            mounts.mount((MEStorage)this.handler, this.priority);
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.remountStorage();
    }

    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        this.oreExp = input.m_128441_("ore_dict_exp") ? input.m_128461_("ore_dict_exp") : "";
    }

    public void exportSettings(SettingsFrom mode, CompoundTag output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.m_128359_("ore_dict_exp", this.oreExp);
        }
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    private Map<AEKeyType, ExternalStorageStrategy> getExternalStorageStrategies() {
        if (this.externalStorageStrategies == null) {
            BlockEntity host = this.getHost().getBlockEntity();
            this.externalStorageStrategies = StackWorldBehaviors.createExternalStorageStrategies((ServerLevel)((ServerLevel)host.m_58904_()), (BlockPos)host.m_58899_().m_121945_(this.getSide()), (Direction)this.getSide().m_122424_());
        }
        return this.externalStorageStrategies;
    }

    private static class StorageBusInventory
    extends MEInventoryHandler {
        public StorageBusInventory(MEStorage inventory) {
            super(inventory);
        }

        protected MEStorage getDelegate() {
            return super.getDelegate();
        }

        protected void setDelegate(MEStorage delegate) {
            super.setDelegate(delegate);
        }

        public void setAccessRestriction(AccessRestriction setting) {
            this.setAllowExtraction(setting.isAllowExtraction());
            this.setAllowInsertion(setting.isAllowInsertion());
        }
    }

    private static enum PendingUpdateStatus {
        FAST_UPDATE,
        SLOW_UPDATE,
        NO_UPDATE;

    }
}

