/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.parts;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.automation.IOBusPart;
import appeng.parts.automation.StackWorldBehaviors;
import com.github.glodblock.epp.common.me.taglist.TagExpParser;
import com.github.glodblock.epp.common.me.taglist.TagPriorityList;
import com.github.glodblock.epp.common.me.taglist.TagStackTransferContext;
import com.github.glodblock.epp.container.ContainerTagExportBus;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartTagExportBus
extends IOBusPart {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("expatternprovider", "part/tag_export_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/export_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/export_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/export_bus_has_channel")});
    @Nullable
    private StackExportStrategy exportStrategy;
    private String oreExp = "";
    private TagPriorityList filter = null;

    public PartTagExportBus(IPartItem<?> partItem) {
        super(TickRates.ExportBus, StackWorldBehaviors.hasExportStrategyFilter(), partItem);
    }

    public void readFromNBT(CompoundTag extra) {
        super.readFromNBT(extra);
        this.oreExp = extra.m_128461_("oreExp");
    }

    public void writeToNBT(CompoundTag extra) {
        super.writeToNBT(extra);
        extra.m_128359_("oreExp", this.oreExp);
    }

    protected final StackExportStrategy getExportStrategy() {
        if (this.exportStrategy == null) {
            BlockEntity self = this.getHost().getBlockEntity();
            BlockPos fromPos = self.m_58899_().m_121945_(this.getSide());
            Direction fromSide = this.getSide().m_122424_();
            this.exportStrategy = StackWorldBehaviors.createExportFacade((ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)fromPos, (Direction)fromSide);
        }
        return this.exportStrategy;
    }

    public String getTagFilter() {
        return this.oreExp;
    }

    public void setTagFilter(String exp) {
        if (!exp.equals(this.oreExp)) {
            this.oreExp = exp;
            this.filter = null;
        }
    }

    protected MenuType<?> getMenuType() {
        return ContainerTagExportBus.TYPE;
    }

    protected boolean doBusWork(IGrid grid) {
        IStorageService storageService = grid.getStorageService();
        TagPriorityList filter = this.createFilter();
        StackTransferContext context = this.createTransferContext(storageService, grid.getEnergyService());
        for (Object2LongMap.Entry what : ImmutableList.copyOf((Iterable)storageService.getCachedInventory())) {
            if (!filter.isListed((AEKey)what.getKey())) continue;
            int transferFactory = ((AEKey)what.getKey()).getAmountPerOperation();
            long amount = (long)context.getOperationsRemaining() * (long)transferFactory;
            amount = this.getExportStrategy().transfer(context, (AEKey)what.getKey(), amount);
            context.reduceOperationsRemaining(Math.max(1L, amount / (long)transferFactory));
            if (context.hasOperationsLeft()) continue;
            break;
        }
        return context.hasDoneWork();
    }

    @NotNull
    private StackTransferContext createTransferContext(IStorageService storageService, IEnergyService energyService) {
        return new TagStackTransferContext(storageService, (IEnergySource)energyService, this.source, this.getOperationsPerTick(), this.createFilter());
    }

    private TagPriorityList createFilter() {
        if (this.filter == null) {
            this.filter = new TagPriorityList(TagExpParser.getMatchingOre(this.oreExp), this.oreExp);
        }
        return this.filter;
    }

    protected final int getUpgradeSlots() {
        return 4;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

