/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.items;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.parts.AEBasePart;
import com.github.glodblock.epp.util.FCUtil;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class ItemUpgrade
extends Item {
    private final HashMap<Class<? extends BlockEntity>, TileEntityPair> BLOCK_MAP = new HashMap();
    private final HashMap<Class<? extends IPart>, IPartItem<?>> PART_MAP = new HashMap();

    public ItemUpgrade(Item.Properties properties) {
        super(properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockEntity tile = world.m_7702_(pos);
        if (tile == null) return InteractionResult.PASS;
        BlockPlaceContext ctx = new BlockPlaceContext(context);
        Class<?> tClazz = tile.getClass();
        if (this.BLOCK_MAP.containsKey(tClazz)) {
            TileEntityPair replaceInfo = this.BLOCK_MAP.get(tClazz);
            BlockState state = replaceInfo.block.m_5573_(ctx);
            BlockEntityType<? extends BlockEntity> tileType = FCUtil.getTileType(replaceInfo.tile);
            assert (state != null);
            BlockEntity te = tileType.m_155264_(pos, state);
            FCUtil.replaceTile(world, pos, tile, te, state);
            context.m_43722_().m_41774_(1);
            return InteractionResult.CONSUME;
        }
        if (!(tile instanceof CableBusBlockEntity)) return InteractionResult.PASS;
        CableBusBlockEntity cable = (CableBusBlockEntity)tile;
        Vec3 hitVec = context.m_43720_();
        Vec3 hitInBlock = new Vec3(hitVec.f_82479_ - (double)pos.m_123341_(), hitVec.f_82480_ - (double)pos.m_123342_(), hitVec.f_82481_ - (double)pos.m_123343_());
        IPart part = cable.getCableBus().selectPartLocal((Vec3)hitInBlock).part;
        if (!(part instanceof AEBasePart)) return InteractionResult.PASS;
        AEBasePart basePart = (AEBasePart)part;
        if (!this.PART_MAP.containsKey(part.getClass())) return InteractionResult.PASS;
        Direction side = basePart.getSide();
        CompoundTag contents = new CompoundTag();
        IPartItem<?> partItem = this.PART_MAP.get(part.getClass());
        part.writeToNBT(contents);
        IPart p = cable.replacePart(partItem, side, context.m_43723_(), null);
        if (p != null) {
            p.readFromNBT(contents);
        }
        context.m_43722_().m_41774_(1);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected void addTile(Class<? extends BlockEntity> clazz, Block block, Class<? extends BlockEntity> tile) {
        this.BLOCK_MAP.put(clazz, new TileEntityPair(block, tile));
    }

    protected void addPart(Class<? extends IPart> clazz, IPartItem<?> item) {
        this.PART_MAP.put(clazz, item);
    }

    private record TileEntityPair(Block block, Class<? extends BlockEntity> tile) {
    }
}

