/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.inventory;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.core.definitions.AEItems;
import com.github.glodblock.epp.common.items.InfinityCell;
import com.github.glodblock.epp.config.EPPConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class InfinityCellInventory
implements StorageCell {
    private final ItemStack stack;
    private final AEKey record;
    private final boolean isVoid;
    public static final ICellHandler HANDLER = new Handler();

    public InfinityCellInventory(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof InfinityCell)) {
            throw new IllegalArgumentException("Cell isn't an infinity cell!");
        }
        InfinityCell cell = (InfinityCell)item;
        this.stack = stack;
        this.record = cell.getRecord(stack);
        this.isVoid = cell.getUpgrades(stack).isInstalled((ItemLike)AEItems.VOID_CARD);
    }

    public CellState getStatus() {
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return EPPConfig.infCellCost;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.isVoid && this.record.equals(what)) {
            return amount;
        }
        return 0L;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.record.equals(what)) {
            return amount;
        }
        return 0L;
    }

    public void persist() {
    }

    public Component getDescription() {
        return this.stack.m_41786_();
    }

    public void getAvailableStacks(KeyCounter out) {
        out.add(this.record, InfinityCell.getAsIntMax(this.record));
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return this.isVoid && this.record.equals(what);
    }

    private static class Handler
    implements ICellHandler {
        private Handler() {
        }

        public boolean isCell(ItemStack is) {
            return is != null && is.m_41720_() instanceof InfinityCell;
        }

        @Nullable
        public StorageCell getCellInventory(ItemStack is, @Nullable ISaveProvider host) {
            return this.isCell(is) ? new InfinityCellInventory(is) : null;
        }
    }
}

