/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common;

import appeng.api.client.StorageCellModels;
import appeng.api.parts.PartModels;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.block.AEBaseBlockItem;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.items.AEBaseItem;
import com.github.glodblock.epp.EPP;
import com.github.glodblock.epp.common.EPPItemAndBlock;
import com.github.glodblock.epp.common.inventory.InfinityCellInventory;
import com.github.glodblock.epp.common.items.ItemMEPackingTape;
import com.github.glodblock.epp.common.parts.PartExExportBus;
import com.github.glodblock.epp.common.parts.PartExImportBus;
import com.github.glodblock.epp.common.parts.PartExInterface;
import com.github.glodblock.epp.common.parts.PartExPatternAccessTerminal;
import com.github.glodblock.epp.common.parts.PartExPatternProvider;
import com.github.glodblock.epp.common.parts.PartTagExportBus;
import com.github.glodblock.epp.common.parts.PartTagStorageBus;
import com.github.glodblock.epp.config.EPPConfig;
import com.github.glodblock.epp.container.ContainerExDrive;
import com.github.glodblock.epp.container.ContainerExIOBus;
import com.github.glodblock.epp.container.ContainerExInscriber;
import com.github.glodblock.epp.container.ContainerExInterface;
import com.github.glodblock.epp.container.ContainerExMolecularAssembler;
import com.github.glodblock.epp.container.ContainerExPatternProvider;
import com.github.glodblock.epp.container.ContainerExPatternTerminal;
import com.github.glodblock.epp.container.ContainerIngredientBuffer;
import com.github.glodblock.epp.container.ContainerPatternModifier;
import com.github.glodblock.epp.container.ContainerTagExportBus;
import com.github.glodblock.epp.container.ContainerTagStorageBus;
import com.github.glodblock.epp.container.ContainerWirelessConnector;
import com.github.glodblock.epp.container.pattern.ContainerCraftingPattern;
import com.github.glodblock.epp.container.pattern.ContainerProcessingPattern;
import com.github.glodblock.epp.container.pattern.ContainerSmithingTablePattern;
import com.github.glodblock.epp.container.pattern.ContainerStonecuttingPattern;
import com.github.glodblock.epp.util.FCUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RegistryHandler {
    public static final RegistryHandler INSTANCE = new RegistryHandler();
    protected final List<Pair<String, Block>> blocks = new ArrayList<Pair<String, Block>>();
    protected final List<Pair<String, Item>> items = new ArrayList<Pair<String, Item>>();
    protected final List<Pair<String, BlockEntityType<?>>> tiles = new ArrayList();

    public void block(String name, Block block) {
        this.blocks.add((Pair<String, Block>)Pair.of((Object)name, (Object)block));
        if (block instanceof AEBaseEntityBlock) {
            AEBaseEntityBlock tileBlock = (AEBaseEntityBlock)block;
            this.tile(name, tileBlock.getBlockEntityType());
        }
    }

    public <T extends AEBaseBlockEntity> void block(String name, AEBaseEntityBlock<T> block, Class<T> clazz, BlockEntityType.BlockEntitySupplier<? extends T> supplier) {
        this.bindTileEntity(clazz, block, supplier);
        this.block(name, (Block)block);
    }

    public void item(String name, Item item) {
        this.items.add((Pair<String, Item>)Pair.of((Object)name, (Object)item));
    }

    public void tile(String name, BlockEntityType<?> type) {
        this.tiles.add(Pair.of((Object)name, type));
    }

    @SubscribeEvent
    public void runRegister(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)Registries.f_256747_)) {
            this.onRegisterBlocks();
            this.onRegisterItems();
            this.onRegisterTileEntities();
            this.onRegisterContainer();
            this.onRegisterModels();
        }
    }

    private void onRegisterBlocks() {
        for (Pair<String, Block> entry : this.blocks) {
            String key = (String)entry.getLeft();
            Block block = (Block)entry.getRight();
            ForgeRegistries.BLOCKS.register(EPP.id(key), (Object)block);
        }
    }

    private void onRegisterItems() {
        for (Pair<String, Block> pair : this.blocks) {
            ForgeRegistries.ITEMS.register(EPP.id((String)pair.getLeft()), (Object)new AEBaseBlockItem((Block)pair.getRight(), new Item.Properties()));
        }
        for (Pair<String, Block> pair : this.items) {
            ForgeRegistries.ITEMS.register(EPP.id((String)pair.getLeft()), (Object)((Item)pair.getRight()));
        }
    }

    private void onRegisterTileEntities() {
        for (Pair<String, BlockEntityType<?>> entry : this.tiles) {
            String key = (String)entry.getLeft();
            BlockEntityType tile = (BlockEntityType)entry.getRight();
            ForgeRegistries.BLOCK_ENTITY_TYPES.register(EPP.id(key), (Object)tile);
        }
    }

    private void onRegisterContainer() {
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_pattern_provider"), ContainerExPatternProvider.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_interface"), ContainerExInterface.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_export_bus"), ContainerExIOBus.EXPORT_TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_import_bus"), ContainerExIOBus.IMPORT_TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_pattern_access_terminal"), ContainerExPatternTerminal.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"wireless_connector"), ContainerWirelessConnector.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ingredient_buffer"), ContainerIngredientBuffer.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_drive"), ContainerExDrive.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"pattern_modifier"), ContainerPatternModifier.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_molecular_assembler"), ContainerExMolecularAssembler.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_inscriber"), ContainerExInscriber.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"tag_storage_bus"), ContainerTagStorageBus.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"tag_export_bus"), ContainerTagExportBus.TYPE);
        ForgeRegistries.MENU_TYPES.register(ContainerProcessingPattern.ID, ContainerProcessingPattern.TYPE);
        ForgeRegistries.MENU_TYPES.register(ContainerCraftingPattern.ID, ContainerCraftingPattern.TYPE);
        ForgeRegistries.MENU_TYPES.register(ContainerStonecuttingPattern.ID, ContainerStonecuttingPattern.TYPE);
        ForgeRegistries.MENU_TYPES.register(ContainerSmithingTablePattern.ID, ContainerSmithingTablePattern.TYPE);
    }

    private <T extends AEBaseBlockEntity> void bindTileEntity(Class<T> clazz, AEBaseEntityBlock<T> block, BlockEntityType.BlockEntitySupplier<? extends T> supplier) {
        BlockEntityTicker serverTicker = null;
        if (ServerTickingBlockEntity.class.isAssignableFrom(clazz)) {
            serverTicker = (level, pos, state, entity) -> ((ServerTickingBlockEntity)entity).serverTick();
        }
        BlockEntityTicker clientTicker = null;
        if (ClientTickingBlockEntity.class.isAssignableFrom(clazz)) {
            clientTicker = (level, pos, state, entity) -> ((ClientTickingBlockEntity)entity).clientTick();
        }
        block.setBlockEntity(clazz, FCUtil.getTileType(clazz, supplier, block), clientTicker, serverTicker);
    }

    public void onInit() {
        for (Pair<String, Block> entry : this.blocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(EPP.id((String)entry.getKey()));
            if (!(block instanceof AEBaseEntityBlock)) continue;
            AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)((AEBaseEntityBlock)block).getBlockEntityType(), (Item)block.m_5456_());
        }
        this.registerAEUpgrade();
        this.registerStorageHandler();
        this.initPackageList();
    }

    private void registerAEUpgrade() {
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)EPPItemAndBlock.EX_INTERFACE.m_5456_(), (int)1, (String)"gui.expatternprovider.ex_interface");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, (ItemLike)EPPItemAndBlock.EX_INTERFACE.m_5456_(), (int)1, (String)"gui.expatternprovider.ex_interface");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)EPPItemAndBlock.EX_INTERFACE_PART.m_5456_(), (int)1, (String)"gui.expatternprovider.ex_interface");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, (ItemLike)EPPItemAndBlock.EX_INTERFACE_PART.m_5456_(), (int)1, (String)"gui.expatternprovider.ex_interface");
        Upgrades.add((ItemLike)AEItems.VOID_CARD, (ItemLike)EPPItemAndBlock.INFINITY_CELL, (int)1, (String)"item.expatternprovider.infinity_cell");
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EPPItemAndBlock.EX_EXPORT_BUS, (int)5, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EPPItemAndBlock.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EPPItemAndBlock.EX_EXPORT_BUS, (int)4, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EPPItemAndBlock.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, EPPItemAndBlock.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EPPItemAndBlock.EX_IMPORT_BUS, (int)5, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EPPItemAndBlock.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EPPItemAndBlock.EX_IMPORT_BUS, (int)4, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.INVERTER_CARD, EPPItemAndBlock.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EPPItemAndBlock.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.ENERGY_CARD, (ItemLike)EPPItemAndBlock.WIRELESS_CONNECTOR, (int)4, (String)"gui.expatternprovider.wireless_connect");
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EPPItemAndBlock.EX_ASSEMBLER, (int)5, (String)"gui.expatternprovider.ex_molecular_assembler");
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EPPItemAndBlock.EX_INSCRIBER, (int)4, (String)"gui.expatternprovider.ex_inscriber");
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EPPItemAndBlock.EX_INSCRIBER, (int)4, (String)"gui.expatternprovider.ex_inscriber");
        Upgrades.add((ItemLike)AEItems.INVERTER_CARD, EPPItemAndBlock.TAG_STORAGE_BUS, (int)1, (String)"item.expatternprovider.tag_storage_bus");
        Upgrades.add((ItemLike)AEItems.VOID_CARD, EPPItemAndBlock.TAG_STORAGE_BUS, (int)1, (String)"item.expatternprovider.tag_storage_bus");
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EPPItemAndBlock.TAG_EXPORT_BUS, (int)1, (String)"item.expatternprovider.tag_export_bus");
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EPPItemAndBlock.TAG_EXPORT_BUS, (int)4, (String)"item.expatternprovider.tag_export_bus");
    }

    private void registerStorageHandler() {
        StorageCells.addCellHandler((ICellHandler)InfinityCellInventory.HANDLER);
        StorageCellModels.registerModel((ItemLike)EPPItemAndBlock.INFINITY_CELL, (ResourceLocation)EPP.id("block/drive/infinity_cell"));
    }

    private void onRegisterModels() {
        PartModels.registerModels(PartExPatternProvider.MODELS);
        PartModels.registerModels(PartExInterface.MODELS);
        PartModels.registerModels(PartExExportBus.MODELS);
        PartModels.registerModels(PartExImportBus.MODELS);
        PartModels.registerModels(PartExPatternAccessTerminal.MODELS);
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartTagStorageBus.MODEL_BASE});
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartTagExportBus.MODEL_BASE});
    }

    private void initPackageList() {
        EPPConfig.tapeWhitelist.forEach(ItemMEPackingTape::registerPackableDevice);
    }

    public void registerTab(Registry<CreativeModeTab> registry) {
        CreativeModeTab tab = CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)EPPItemAndBlock.EX_PATTERN_PROVIDER)).m_257941_((Component)Component.m_237115_((String)"itemGroup.epp")).m_257501_((__, o) -> {
            for (Pair<String, Item> pair : this.items) {
                Object patt12727$temp = pair.getRight();
                if (patt12727$temp instanceof AEBaseItem) {
                    AEBaseItem aeItem = (AEBaseItem)patt12727$temp;
                    aeItem.addToMainCreativeTab(o);
                    continue;
                }
                o.m_246326_((ItemLike)pair.getRight());
            }
            for (Pair<String, Item> pair : this.blocks) {
                o.m_246326_((ItemLike)pair.getRight());
            }
        }).m_257652_();
        Registry.m_122965_(registry, (ResourceLocation)EPP.id("tab_main"), (Object)tab);
    }
}

