/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.client.model;

import appeng.api.client.StorageCellModels;
import appeng.init.internal.InitStorageCells;
import com.github.glodblock.epp.client.model.ExDriveBakedModel;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class ExDriveModel
implements IUnbakedGeometry<ExDriveModel> {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("expatternprovider:block/extended_drive/extended_me_drive_base");
    private static final ResourceLocation MODEL_CELL_EMPTY = new ResourceLocation("ae2:block/drive/drive_cell_empty");

    @Nullable
    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        IdentityHashMap<Item, BakedModel> cellModels = new IdentityHashMap<Item, BakedModel>();
        for (Map.Entry entry : StorageCellModels.models().entrySet()) {
            BakedModel cellModel = baker.bake((ResourceLocation)entry.getValue(), modelTransform, spriteGetter);
            cellModels.put((Item)entry.getKey(), cellModel);
        }
        BakedModel baseModel = baker.bake(MODEL_BASE, modelTransform, spriteGetter);
        BakedModel defaultCell = baker.bake(StorageCellModels.getDefaultModel(), modelTransform, spriteGetter);
        cellModels.put(Items.f_41852_, baker.bake(MODEL_CELL_EMPTY, modelTransform, spriteGetter));
        return new ExDriveBakedModel(modelTransform.m_6189_(), baseModel, cellModels, defaultCell);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableSet.builder().add((Object)StorageCellModels.getDefaultModel()).addAll((Iterable)InitStorageCells.getModels()).addAll(StorageCellModels.models().values()).build();
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        for (ResourceLocation dependency : this.getDependencies()) {
            modelGetter.apply(dependency).m_5500_(modelGetter);
        }
    }

    public static class Loader
    implements IGeometryLoader<ExDriveModel> {
        public ExDriveModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new ExDriveModel();
        }
    }
}

