/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.config.TerminalStyle;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.patternaccess.PatternContainerRecord;
import appeng.client.gui.me.patternaccess.PatternSlot;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.util.inv.AppEngInternalInventory;
import com.github.glodblock.epp.client.button.HighlightButton;
import com.github.glodblock.epp.container.ContainerExPatternTerminal;
import com.google.common.collect.HashMultimap;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiExPatternTerminal
extends AEBaseScreen<ContainerExPatternTerminal> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiExPatternTerminal.class);
    private static final int GUI_WIDTH = 209;
    private static final int MAGIC_NUMBER = 50;
    private static final int GUI_TOP_AND_BOTTOM_PADDING = 54;
    private static final int GUI_PADDING_X = 22;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 51;
    private static final int GUI_FOOTER_HEIGHT = 97;
    private static final int COLUMNS = 9;
    private static final int PATTERN_PROVIDER_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final Rect2i HEADER_BBOX = new Rect2i(0, 0, 209, 51);
    private static final Rect2i ROW_TEXT_TOP_BBOX = new Rect2i(0, 51, 209, 18);
    private static final Rect2i ROW_TEXT_MIDDLE_BBOX = new Rect2i(0, 87, 209, 18);
    private static final Rect2i ROW_TEXT_BOTTOM_BBOX = new Rect2i(0, 123, 209, 18);
    private static final Rect2i ROW_INVENTORY_TOP_BBOX = new Rect2i(0, 69, 209, 18);
    private static final Rect2i ROW_INVENTORY_MIDDLE_BBOX = new Rect2i(0, 105, 209, 18);
    private static final Rect2i ROW_INVENTORY_BOTTOM_BBOX = new Rect2i(0, 141, 209, 18);
    private static final Rect2i FOOTER_BBOX = new Rect2i(0, 159, 209, 97);
    private static final Comparator<PatternContainerGroup> GROUP_COMPARATOR = Comparator.comparing(group -> group.name().getString().toLowerCase(Locale.ROOT));
    private final HashMap<Long, PatternContainerRecord> byId = new HashMap();
    private final HashMap<Integer, HighlightButton> highlightBtns = new HashMap();
    private final HashMap<Long, PatternProviderInfo> infoMap = new HashMap();
    private final HashMultimap<PatternContainerGroup, PatternContainerRecord> byGroup = HashMultimap.create();
    private final ArrayList<PatternContainerGroup> groups = new ArrayList();
    private final ArrayList<Row> rows = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Set<ItemStack> matchedStack = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack o) {
            return o.m_41720_().hashCode() ^ o.m_41773_() ^ (o.m_41782_() ? o.m_41783_().hashCode() : -1);
        }

        public boolean equals(ItemStack a, ItemStack b) {
            return a == b || a != null && b != null && ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
        }
    });
    private final Set<PatternContainerRecord> matchedProvider = new HashSet<PatternContainerRecord>();
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");
    private final AETextField searchOutField;
    private final AETextField searchInField;
    private int visibleRows = 0;
    private final ServerSettingToggleButton<ShowPatternProviders> showPatternProviders;

    public GuiExPatternTerminal(ContainerExPatternTerminal menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.f_97726_ = 209;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar((Button)new SettingToggleButton(Settings.TERMINAL_STYLE, (Enum)terminalStyle, this::toggleTerminalStyle));
        this.showPatternProviders = new ServerSettingToggleButton(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, (Enum)ShowPatternProviders.VISIBLE);
        this.addToLeftToolbar((Button)this.showPatternProviders);
        this.searchOutField = this.widgets.addTextField("search_out");
        this.searchOutField.m_94151_(str -> this.refreshList());
        this.searchOutField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
        this.searchOutField.setTooltipMessage(Collections.singletonList(Component.m_237115_((String)"gui.expatternprovider.ex_pattern_access_terminal.tooltip.01")));
        this.searchInField = this.widgets.addTextField("search_in");
        this.searchInField.m_94151_(str -> this.refreshList());
        this.searchInField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
        this.searchInField.setTooltipMessage(Collections.singletonList(Component.m_237115_((String)"gui.expatternprovider.ex_pattern_access_terminal.tooltip.02")));
    }

    public void m_7856_() {
        this.visibleRows = this.config.getTerminalStyle().getRows((this.f_96544_ - 51 - 97 - 54 + 50) / 18);
        if (this.visibleRows < 2) {
            this.visibleRows = 2;
        }
        this.f_97727_ = 148 + this.visibleRows * 18;
        super.m_7856_();
        this.m_264313_((GuiEventListener)this.searchOutField);
        this.highlightBtns.forEach((k, v) -> {
            v.setVisibility(false);
            this.m_142416_((GuiEventListener)v);
        });
        this.resetScrollbar();
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((ContainerExPatternTerminal)this.f_97732_).f_38839_.removeIf(slot -> slot instanceof PatternSlot);
        this.highlightBtns.forEach((key, value) -> value.setVisibility(false));
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.visibleRows; ++i) {
            int rows;
            if (scrollLevel + i >= this.rows.size()) continue;
            Row row = this.rows.get(scrollLevel + i);
            if (this.highlightBtns.containsKey(scrollLevel + i)) {
                HighlightButton btn = this.highlightBtns.get(scrollLevel + i);
                btn.m_264152_(this.f_97735_ + 22 - 18, this.f_97736_ + (i + 1) * 18 + 34);
                btn.setVisibility(true);
            }
            if (row instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                PatternContainerRecord container = slotsRow.container;
                for (int col = 0; col < slotsRow.slots; ++col) {
                    PatternSlot slot2 = new PatternSlot(container, slotsRow.offset + col, col * 18 + 22, (i + 1) * 18 + 34);
                    ((ContainerExPatternTerminal)this.f_97732_).f_38839_.add((Object)slot2);
                    if (this.searchOutField.m_94155_().isEmpty() && this.searchInField.m_94155_().isEmpty()) continue;
                    if (this.matchedStack.contains(slot2.m_7993_())) {
                        this.fillRect(guiGraphics, new Rect2i(slot2.f_40220_, slot2.f_40221_, 16, 16), -1979646208);
                        continue;
                    }
                    if (this.matchedProvider.contains(container)) continue;
                    this.fillRect(guiGraphics, new Rect2i(slot2.f_40220_, slot2.f_40221_, 16, 16), 0x6A000000);
                }
                continue;
            }
            if (!(row instanceof GroupHeaderRow)) continue;
            GroupHeaderRow headerRow = (GroupHeaderRow)row;
            PatternContainerGroup group = headerRow.group;
            if (group.icon() != null) {
                SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
                renderContext.renderItem(group.icon().toStack(), 24, 57 + i * 18, 8.0f, 8.0f);
            }
            Object displayName = (rows = this.byGroup.get((Object)group).size()) > 1 ? Component.m_237119_().m_7220_(group.name()).m_7220_((Component)Component.m_237113_((String)(" (" + rows + ")"))) : group.name();
            FormattedCharSequence text = Language.m_128107_().m_5536_(this.f_96547_.m_92854_((FormattedText)displayName, 145));
            guiGraphics.m_280649_(this.f_96547_, text, 34, 57 + i * 18, textColor, false);
        }
    }

    protected void m_280072_(@NotNull GuiGraphics guiGraphics, int x, int y) {
        Row row;
        int hoveredLineIndex;
        if (this.f_97734_ == null && (hoveredLineIndex = this.getHoveredLineIndex(x, y)) != -1 && (row = this.rows.get(hoveredLineIndex)) instanceof GroupHeaderRow) {
            GroupHeaderRow headerRow = (GroupHeaderRow)row;
            if (!headerRow.group.tooltip().isEmpty()) {
                guiGraphics.m_280677_(this.f_96547_, headerRow.group.tooltip(), Optional.empty(), x, y);
                return;
            }
        }
        super.m_280072_(guiGraphics, x, y);
    }

    private int getHoveredLineIndex(int x, int y) {
        x = x - this.f_97735_ - 22;
        y = y - this.f_97736_ - 18;
        if (x < 0 || y < 0) {
            return -1;
        }
        if (x >= 162 || y >= this.visibleRows * 18) {
            return -1;
        }
        int rowIndex = this.scrollbar.getCurrentScroll() + y / 18;
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return -1;
        }
        return rowIndex;
    }

    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchOutField.m_5953_(xCoord, yCoord)) {
            this.searchOutField.m_94144_("");
        }
        if (btn == 1 && this.searchInField.m_5953_(xCoord, yCoord)) {
            this.searchInField.m_94144_("");
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    protected void m_6597_(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof PatternSlot) {
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!this.getPlayer().m_150110_().f_35937_) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                PatternSlot machineSlot = (PatternSlot)slot;
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.getSlotIndex(), machineSlot.getMachineInv().getServerId());
                NetworkHandler.instance().sendToServer((BasePacket)p);
            }
            return;
        }
        super.m_6597_(slot, slotIdx, mouseButton, clickType);
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.blit(guiGraphics, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 51;
        this.blit(guiGraphics, offsetX, currentY + this.visibleRows * 18, FOOTER_BBOX);
        for (int i = 0; i < this.visibleRows; ++i) {
            Row row;
            boolean firstLine = i == 0;
            boolean lastLine = i == this.visibleRows - 1;
            Rect2i bbox = this.selectRowBackgroundBox(false, firstLine, lastLine);
            this.blit(guiGraphics, offsetX, currentY, bbox);
            if (scrollLevel + i < this.rows.size() && (row = this.rows.get(scrollLevel + i)) instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                bbox = this.selectRowBackgroundBox(true, firstLine, lastLine);
                bbox.m_173056_(22 + 18 * slotsRow.slots - 1);
                this.blit(guiGraphics, offsetX, currentY, bbox);
            }
            currentY += 18;
        }
    }

    private Rect2i selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean m_5534_(char character, int key) {
        if (character == ' ' && (this.searchOutField.m_94155_().isEmpty() && this.searchOutField.m_93696_() || this.searchInField.m_94155_().isEmpty() && this.searchInField.m_93696_())) {
            return true;
        }
        return super.m_5534_(character, key);
    }

    public void clear() {
        this.byId.clear();
        this.infoMap.clear();
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postTileInfo(long id, BlockPos pos, ResourceKey<Level> dim, Direction face) {
        this.infoMap.put(id, new PatternProviderInfo(pos, face, dim));
        this.refreshList();
    }

    public void postFullUpdate(long inventoryId, long sortBy, PatternContainerGroup group, int inventorySize, Int2ObjectMap<ItemStack> slots) {
        PatternContainerRecord record = new PatternContainerRecord(inventoryId, inventorySize, sortBy, group);
        this.byId.put(inventoryId, record);
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postIncrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots) {
        PatternContainerRecord record = this.byId.get(inventoryId);
        if (record == null) {
            LOGGER.warn("Ignoring incremental update for unknown inventory id {}", (Object)inventoryId);
            return;
        }
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
    }

    public void updateBeforeRender() {
        super.updateBeforeRender();
        this.showPatternProviders.set((Enum)((ContainerExPatternTerminal)this.f_97732_).getShownProviders());
    }

    private void refreshList() {
        this.byGroup.clear();
        this.highlightBtns.forEach((k, v) -> this.m_169411_((GuiEventListener)v));
        this.highlightBtns.clear();
        this.matchedStack.clear();
        this.matchedProvider.clear();
        String outputFilter = this.searchOutField.m_94155_().toLowerCase();
        String inputFilter = this.searchInField.m_94155_().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm("out:" + outputFilter + "in:" + inputFilter);
        boolean rebuild = cachedSearch.isEmpty();
        for (PatternContainerRecord entry : this.byId.values()) {
            boolean found;
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean bl = found = outputFilter.isEmpty() && inputFilter.isEmpty();
            if (!found) {
                for (ItemStack itemStack : entry.getInventory()) {
                    boolean midRes = !outputFilter.isEmpty() ? this.itemStackMatchesSearchTerm(itemStack, outputFilter, true) : true;
                    if (!inputFilter.isEmpty() && midRes) {
                        midRes = this.itemStackMatchesSearchTerm(itemStack, inputFilter, false);
                    }
                    if (!midRes) continue;
                    found = true;
                }
            }
            if (found || entry.getSearchName().contains(outputFilter) && entry.getSearchName().contains(inputFilter)) {
                this.byGroup.put((Object)entry.getGroup(), (Object)entry);
                cachedSearch.add(entry);
                if (!entry.getSearchName().contains(outputFilter) || !entry.getSearchName().contains(inputFilter)) continue;
                this.matchedProvider.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.groups.clear();
        this.groups.addAll(this.byGroup.keySet());
        this.groups.sort(GROUP_COMPARATOR);
        this.rows.clear();
        this.rows.ensureCapacity(this.getMaxRows());
        for (PatternContainerGroup group : this.groups) {
            this.rows.add(new GroupHeaderRow(group));
            ArrayList containers = new ArrayList(this.byGroup.get((Object)group));
            Collections.sort(containers);
            for (PatternContainerRecord container : containers) {
                AppEngInternalInventory inventory = container.getInventory();
                if (inventory.size() > 0) {
                    PatternProviderInfo info = this.infoMap.get(container.getServerId());
                    HighlightButton btn = new HighlightButton();
                    btn.setMultiplier(this.playerToBlockDis(info.pos()));
                    btn.setTarget(info.pos, info.face, info.playerWorld);
                    btn.setSuccessJob(() -> {
                        if (this.getPlayer() != null && info.pos != null && info.playerWorld != null) {
                            this.getPlayer().m_5661_((Component)Component.m_237110_((String)"chat.ex_pattern_access_terminal.pos", (Object[])new Object[]{info.pos.m_123344_(), info.playerWorld.m_135782_().m_135815_()}), false);
                        }
                    });
                    btn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.expatternprovider.ex_pattern_access_terminal.tooltip.03")));
                    btn.setVisibility(false);
                    this.highlightBtns.put(this.rows.size(), (HighlightButton)this.m_142416_((GuiEventListener)btn));
                }
                for (int offset = 0; offset < inventory.size(); offset += 9) {
                    int slots = Math.min(inventory.size() - offset, 9);
                    SlotsRow containerRow = new SlotsRow(container, offset, slots);
                    this.rows.add(containerRow);
                }
            }
        }
        this.resetScrollbar();
    }

    private double playerToBlockDis(BlockPos pos) {
        if (pos == null) {
            return 0.0;
        }
        BlockPos ps = this.getPlayer().m_20097_();
        return pos.m_123331_((Vec3i)ps);
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.visibleRows * 18 - 2);
        this.scrollbar.setRange(0, this.rows.size() - this.visibleRows, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm, boolean checkOut) {
        if (itemStack.m_41619_()) {
            return false;
        }
        IPatternDetails result = null;
        Item item = itemStack.m_41720_();
        if (item instanceof EncodedPatternItem) {
            EncodedPatternItem pattern = (EncodedPatternItem)item;
            result = pattern.decode(itemStack, ((ContainerExPatternTerminal)this.f_97732_).getPlayer().m_9236_(), false);
        }
        if (result == null) {
            return false;
        }
        List<GenericStack> list = checkOut ? Arrays.asList(result.getOutputs()) : Arrays.stream(result.getInputs()).map(i -> i.getPossibleInputs()[0]).collect(Collectors.toList());
        for (GenericStack item2 : list) {
            String displayName;
            if (item2 == null || !(displayName = item2.what().getDisplayName().getString().toLowerCase()).contains(searchTerm)) continue;
            this.matchedStack.add(itemStack);
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    private void reinitialize() {
        this.m_6702_().removeAll(this.f_169369_);
        this.f_169369_.clear();
        this.m_7856_();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = (TerminalStyle)btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set((Enum)next);
        this.reinitialize();
    }

    private int getMaxRows() {
        return this.groups.size() + this.byId.size();
    }

    private void blit(GuiGraphics guiGraphics, int offsetX, int offsetY, Rect2i srcRect) {
        ResourceLocation texture = AppEng.makeId((String)"textures/guis/ex_pattern_access_terminal.png");
        guiGraphics.m_280218_(texture, offsetX, offsetY, srcRect.m_110085_(), srcRect.m_110086_(), srcRect.m_110090_(), srcRect.m_110091_());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Row {
    }

    record SlotsRow(PatternContainerRecord container, int offset, int slots) implements Row
    {
    }

    record GroupHeaderRow(PatternContainerGroup group) implements Row
    {
    }

    public record PatternProviderInfo(@Nullable BlockPos pos, @Nullable Direction face, @Nullable ResourceKey<Level> playerWorld) {
    }
}

