/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.item;

import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.registry.ModConfigs;
import jackyy.exchangers.util.Reference;
import jackyy.gunpowderlib.capability.FEItemStackCapability;
import jackyy.gunpowderlib.capability.FEStorageCapability;
import jackyy.gunpowderlib.capability.IFEContainer;
import jackyy.gunpowderlib.helper.EnergyHelper;
import jackyy.gunpowderlib.helper.KeyHelper;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;

public class ItemExchangerBasePowered
extends ItemExchangerBase
implements IFEContainer {
    public ItemExchangerBasePowered(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public int receiveEnergy(ItemStack container, int energy, boolean simulate) {
        return EnergyHelper.receiveEnergy((ItemStack)container, (int)energy, (boolean)simulate);
    }

    public int extractEnergy(ItemStack container, int energy, boolean simulate) {
        return EnergyHelper.extractEnergy((ItemStack)container, (int)energy, (boolean)simulate);
    }

    public int getEnergyStored(ItemStack container) {
        return EnergyHelper.getEnergyStored((ItemStack)container);
    }

    public int getMaxEnergyStored(ItemStack container) {
        if (((Boolean)ModConfigs.CONFIG.holdingEnchantment.get()).booleanValue() && ModList.get().isLoaded("cofh_core")) {
            int enchant = container.getEnchantmentLevel(Reference.holdingEnchant);
            return this.getMaxEnergy() + this.getMaxEnergy() * enchant / 2;
        }
        return this.getMaxEnergy();
    }

    @Override
    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return (int)Math.round(13.0 * (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack));
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)0.33333334f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (KeyHelper.isShiftKeyDown()) {
            tooltip.add((Component)StringHelper.formatNumber((long)this.getEnergyStored(stack)).m_130946_(" / ").m_7220_((Component)StringHelper.formatNumber((long)this.getMaxEnergyStored(stack))).m_130946_(" " + (String)ModConfigs.CONFIG.energyUnit.get()));
        }
    }

    @Override
    public boolean isPowered() {
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new FEItemStackCapability((IEnergyStorage)new FEStorageCapability((IFEContainer)this, stack));
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44987_ || enchantment == Enchantments.f_44985_ || enchantment == Enchantments.f_44986_ || enchantment == Reference.holdingEnchant;
    }
}

