/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.capabilities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.ingredient.recipe.IngredientRecipeHelpers;
import org.cyclops.cyclopscore.ingredient.recipe.RecipeHandlerRecipeType;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuser;
import org.cyclops.evilcraft.core.recipe.type.IInventoryFluidTier;
import org.cyclops.evilcraft.core.recipe.type.InventoryFluidTier;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;
import org.cyclops.evilcraftcompat.Capabilities;

public class RecipeHandlerBloodInfuserBlockEntityCompat
extends SimpleCapabilityConstructor<IRecipeHandler, BlockEntityBloodInfuser> {
    public Capability<IRecipeHandler> getCapability() {
        return Capabilities.RECIPE_HANDLER;
    }

    @Nullable
    public ICapabilityProvider createProvider(BlockEntityBloodInfuser host) {
        return new DefaultCapabilityProvider(() -> Capabilities.RECIPE_HANDLER, (Object)new RecipeHandler(host));
    }

    public static class RecipeHandler
    extends RecipeHandlerRecipeType<IInventoryFluidTier, RecipeBloodInfuser> {
        private final BlockEntityBloodInfuser host;

        public RecipeHandler(BlockEntityBloodInfuser host) {
            super(() -> ((BlockEntityBloodInfuser)host).m_58904_(), RegistryEntries.RECIPETYPE_BLOOD_INFUSER, (Set)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK, IngredientComponent.FLUIDSTACK}), (Set)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK}));
            this.host = host;
        }

        public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
            return (component == IngredientComponent.ITEMSTACK || component == IngredientComponent.FLUIDSTACK) && size == 1;
        }

        @Nullable
        protected IInventoryFluidTier getRecipeInputContainer(IMixedIngredients input) {
            InventoryFluidTier inventory = new InventoryFluidTier((NonNullList<ItemStack>)NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_), (NonNullList<FluidStack>)NonNullList.m_122780_((int)1, (Object)FluidStack.EMPTY), this.host.getTileWorkingMetadata().getTier((Container)this.host.getInventory()));
            if (!input.getInstances(IngredientComponent.ITEMSTACK).isEmpty()) {
                inventory.m_6836_(0, (ItemStack)input.getInstances(IngredientComponent.ITEMSTACK).get(0));
            }
            if (!input.getInstances(IngredientComponent.FLUIDSTACK).isEmpty()) {
                inventory.getFluidHandler().fill((FluidStack)input.getInstances(IngredientComponent.FLUIDSTACK).get(0), IFluidHandler.FluidAction.EXECUTE);
            }
            return inventory;
        }

        @Nullable
        protected Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> getRecipeInputIngredients(RecipeBloodInfuser recipe) {
            IdentityHashMap inputs = Maps.newIdentityHashMap();
            if (!recipe.getInputIngredient().m_43947_()) {
                inputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{IngredientRecipeHelpers.getPrototypesFromIngredient((Ingredient)recipe.getInputIngredient())}));
            }
            if (!recipe.getInputFluid().isEmpty()) {
                inputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponent.FLUIDSTACK, (Object)recipe.getInputFluid(), (Object)7)}))}));
            }
            return inputs;
        }

        @Nullable
        protected IMixedIngredients getRecipeOutputIngredients(RecipeBloodInfuser recipe) {
            IdentityHashMap outputIngredients = Maps.newIdentityHashMap();
            if (!recipe.getOutputItemFirst().m_41619_()) {
                outputIngredients.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipe.getOutputItemFirst()}));
            }
            if (outputIngredients.isEmpty()) {
                return null;
            }
            return new MixedIngredients((Map)outputIngredients);
        }
    }
}

