/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.client.particle.ParticleBloodSplash;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemBloodExtractorConfig;
import org.cyclops.evilcraft.item.ItemVeinSword;
import org.cyclops.evilcraft.item.ItemVeinSwordConfig;

public class ItemBloodExtractor
extends ItemBloodContainer {
    public ItemBloodExtractor(Item.Properties properties) {
        super(properties, ItemBloodExtractorConfig.containerSize);
        this.setPlaceFluids(true);
        MinecraftForge.EVENT_BUS.addListener(this::bloodObtainEvent);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        Block block = context.m_43725_().m_8055_(context.m_8083_()).m_60734_();
        if (context.m_43723_().m_6047_() && block instanceof BlockBloodStain) {
            RandomSource random = context.m_43725_().f_46441_;
            BlockEntityHelpers.getCapability((BlockGetter)context.m_43725_(), (BlockPos)context.m_8083_(), (Capability)ForgeCapabilities.FLUID_HANDLER).ifPresent(source -> {
                FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null)), (IFluidHandler)source, (int)Integer.MAX_VALUE, (boolean)true);
                if (!moved.isEmpty() && context.m_43725_().m_5776_()) {
                    ParticleBloodSplash.spawnParticles(context.m_43725_(), context.m_8083_(), 5, 1 + random.m_188503_(2));
                }
            });
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.m_5524_() + ".info.auto_supply"));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!player.m_6047_()) {
            return super.m_7203_(world, player, hand);
        }
        BlockHitResult target = ItemBloodExtractor.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (!(target != null && target.m_6662_() != HitResult.Type.MISS || world.m_5776_())) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public static void fillForAllBloodExtractors(Player player, int minimumMB, int maximumMB) {
        int toFill = minimumMB + player.m_217043_().m_188503_(Math.max(1, maximumMB - minimumMB));
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext() && toFill > 0) {
            ItemStack itemStack = it.next();
            if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof ItemBloodExtractor)) continue;
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
            toFill -= fluidHandler.fill(new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, toFill), IFluidHandler.FluidAction.EXECUTE);
            it.replace(fluidHandler.getContainer());
        }
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int itemSlot, boolean par5) {
        if (ItemHelpers.isActivated(itemStack)) {
            ItemHelpers.updateAutoFill((IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null), world, entity, ItemBloodExtractorConfig.autoFillBuckets);
        }
        super.m_6883_(itemStack, world, entity, itemSlot, par5);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public void bloodObtainEvent(LivingDeathEvent event) {
        Entity e = event.getSource().m_7639_();
        if (e != null && e instanceof ServerPlayer && !e.m_9236_().m_5776_() && event.getEntity() != null) {
            float boost = 1.0f;
            ServerPlayer player = (ServerPlayer)e;
            InteractionHand hand = player.m_7655_();
            if (hand != null && player.m_21120_(hand) != null && player.m_21120_(hand).m_41720_() instanceof ItemVeinSword) {
                boost = (float)ItemVeinSwordConfig.extractionBoost;
            }
            float health = event.getEntity().m_21233_();
            int minimumMB = Mth.m_14143_((float)(health * (float)ItemBloodExtractorConfig.minimumMobMultiplier * boost));
            int maximumMB = Mth.m_14143_((float)(health * (float)ItemBloodExtractorConfig.maximumMobMultiplier * boost));
            ItemBloodExtractor.fillForAllBloodExtractors((Player)player, minimumMB, maximumMB);
        }
    }
}

