/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.client.particle.ParticleBlurTargettedEntityData;
import org.cyclops.evilcraft.client.particle.ParticleDistortData;
import org.cyclops.evilcraft.client.particle.ParticleExplosionExtendedData;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemPowerableHelpers;

public abstract class ItemMace
extends ItemBloodContainer {
    private final int hitUsage;
    private final int maximumCharge;
    private final int powerLevels;
    private final float meleeDamage;

    public ItemMace(Item.Properties builder, int containerSize, int hitUsage, int maximumCharge, int powerLevels, float meleeDamage) {
        super(builder, containerSize);
        this.hitUsage = hitUsage;
        this.maximumCharge = maximumCharge;
        this.powerLevels = powerLevels;
        this.meleeDamage = meleeDamage;
    }

    protected boolean isUsable(ItemStack itemStack, Player player) {
        return this.canConsume(1, itemStack, player);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity attacked, LivingEntity attacker) {
        if (attacker instanceof Player && this.isUsable(itemStack, (Player)attacker)) {
            ((IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemStack).orElseGet(null)).drain(this.hitUsage, IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack itemStack, Player player, Entity entity) {
        return !this.isUsable(itemStack, player);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack itemStack) {
        return this.maximumCharge * (this.powerLevels - this.getPower(itemStack));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (ItemPowerableHelpers.onPowerableItemItemRightClick(itemStack, world, player, this.powerLevels, true)) {
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        if (this.isUsable(itemStack, player)) {
            player.m_6672_(hand);
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        if (world.m_5776_()) {
            this.animateOutOfEnergy(world, (LivingEntity)player);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack itemStack, int duration) {
        Level world = player.m_9236_();
        if (world.m_5776_() && duration % 2 == 0) {
            this.showUsingItemTick(world, itemStack, player, duration);
        }
        super.m_5929_(level, player, itemStack, duration);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showUsingItemTick(Level world, ItemStack itemStack, LivingEntity entity, int duration) {
        int itemUsedCount = this.m_8105_(itemStack) - duration;
        double area = this.getArea(itemUsedCount);
        int points = (int)Math.pow(area, 0.55) * 2 + 1;
        int particleChance = 5 * (this.powerLevels - this.getPower(itemStack));
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            for (double pointHeight = (double)(-points); pointHeight <= (double)points; pointHeight += 0.5) {
                if (world.f_46441_.m_188503_(particleChance) != 0) continue;
                double u = Math.PI * (point / (double)points);
                double v = Math.PI * -2 * (pointHeight / (double)points);
                double xOffset = Math.cos(u) * Math.sin(v) * area;
                double yOffset = Math.sin(u) * area;
                double zOffset = Math.cos(v) * area;
                double xCoord = entity.m_20185_();
                double yCoord = entity.m_20186_() + (double)entity.m_20192_() - (Minecraft.m_91087_().f_91074_ == entity ? 0.5 : 1.5);
                double zCoord = entity.m_20189_();
                double particleX = xCoord + xOffset - (double)world.f_46441_.m_188501_() * area / 4.0 - 0.5;
                double particleY = yCoord + yOffset - (double)world.f_46441_.m_188501_() * area / 4.0 - 0.5;
                double particleZ = zCoord + zOffset - (double)world.f_46441_.m_188501_() * area / 4.0 - 0.5;
                float particleMotionX = (float)(xOffset * 10.0);
                float particleMotionY = (float)(yOffset * 10.0);
                float particleMotionZ = (float)(zOffset * 10.0);
                Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleDistortData((float)area * 3.0f), false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
                if (world.f_46441_.m_188503_(10) != 0) continue;
                int spread = 10;
                float scale2 = 0.3f - world.f_46441_.m_188501_() * 0.2f;
                float r = 1.0f * world.f_46441_.m_188501_();
                float g = 0.2f + 0.01f * world.f_46441_.m_188501_();
                float b = 0.1f + 0.5f * world.f_46441_.m_188501_();
                float ageMultiplier2 = 20.0f;
                double motionX = (double)spread - world.f_46441_.m_188500_() * 2.0 * (double)spread;
                double motionY = (double)spread - world.f_46441_.m_188500_() * 2.0 * (double)spread;
                double motionZ = (double)spread - world.f_46441_.m_188500_() * 2.0 * (double)spread;
                Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleBlurTargettedEntityData(r, g, b, scale2, ageMultiplier2, entity.m_19879_()), false, particleX, particleY, particleZ, motionX, motionY, motionZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showUsedItemTick(Level world, LivingEntity player, int power) {
        int particles = (power + 1) * (power + 1) * (power + 1) * 10;
        for (int i = 0; i < particles; ++i) {
            double x = player.m_20185_() - 0.5 + world.f_46441_.m_188500_();
            double y = player.m_20186_() + (double)player.m_20192_() - 1.0 + world.f_46441_.m_188500_();
            double z = player.m_20189_() - 0.5 + world.f_46441_.m_188500_();
            double particleMotionX = (-1.0 + world.f_46441_.m_188500_() * 2.0) * (double)(power + 1) / 2.0;
            double particleMotionY = (-1.0 + world.f_46441_.m_188500_() * 2.0) * (double)(power + 1) / 2.0;
            double particleMotionZ = (-1.0 + world.f_46441_.m_188500_() * 2.0) * (double)(power + 1) / 2.0;
            float r = 1.0f * world.f_46441_.m_188501_();
            float g = 0.2f + 0.01f * world.f_46441_.m_188501_();
            float b = 0.1f + 0.5f * world.f_46441_.m_188501_();
            Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleExplosionExtendedData(r, g, b, 0.3f), false, x, y, z, particleMotionX, particleMotionY, particleMotionZ);
        }
    }

    protected double getArea(int itemUsedCount) {
        return (double)(itemUsedCount / 5) + 2.0;
    }

    public void m_5551_(ItemStack itemStack, Level world, LivingEntity entity, int itemInUseCount) {
        if (entity instanceof Player) {
            IFluidHandlerItemCapacity fluidHandler = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack).orElse(null);
            Player player = (Player)entity;
            int itemUsedCount = this.m_8105_(itemStack) - itemInUseCount;
            int toDrain = itemUsedCount * fluidHandler.getCapacity() * (this.getPower(itemStack) + 1) / (this.m_8105_(itemStack) * this.powerLevels);
            FluidStack consumed = this.consume(toDrain, itemStack, player);
            int consumedAmount = consumed == null ? 0 : consumed.getAmount();
            itemUsedCount = consumedAmount * this.m_8105_(itemStack) / fluidHandler.getCapacity();
            if (consumedAmount > 0) {
                this.use(world, entity, itemUsedCount, this.getPower(itemStack));
                if (world.m_5776_()) {
                    this.showUsedItemTick(world, entity, this.getPower(itemStack));
                }
            } else if (world.m_5776_()) {
                this.animateOutOfEnergy(world, entity);
            }
        }
    }

    protected abstract void use(Level var1, LivingEntity var2, int var3, int var4);

    @OnlyIn(value=Dist.CLIENT)
    protected void animateOutOfEnergy(Level world, LivingEntity entity) {
        double xCoord = entity.m_20185_();
        double yCoord = entity.m_20186_();
        double zCoord = entity.m_20189_();
        float particleMotionX = world.f_46441_.m_188501_() * 0.2f - 0.1f;
        float particleMotionY = 0.2f;
        float particleMotionZ = world.f_46441_.m_188501_() * 0.2f - 0.1f;
        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, xCoord, yCoord, zCoord, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)SoundEvents.f_12208_.m_203334_(), SoundSource.NEUTRAL, 0.5f, 0.4f / (world.f_46441_.m_188501_() * 0.4f + 0.8f));
    }

    public int m_6473_() {
        return 15;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack itemStack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.meleeDamage, AttributeModifier.Operation.ADDITION));
        }
        return super.getAttributeModifiers(slot, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        ItemPowerableHelpers.addPreInformation(itemStack, list);
        super.m_7373_(itemStack, world, list, flag);
        ItemPowerableHelpers.addPostInformation(itemStack, list);
    }

    public int getPower(ItemStack itemStack) {
        return ItemPowerableHelpers.getPower(itemStack);
    }
}

