/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;

public class ItemEffortlessRing
extends Item {
    private static final int TICK_MODULUS = 1;
    private static final String PLAYER_NBT_KEY = "evilcraft:lastStepSize";
    private static final float SPEED_BONUS = 0.05f;
    private static final float STEP_SIZE = 1.0f;
    private static final float JUMP_DISTANCE_FACTOR = 0.05f;
    private static final float JUMP_HEIGHT_FACTOR = 0.3f;
    private static final float FALLDISTANCE_REDUCTION = 2.0f;

    public ItemEffortlessRing(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerFall);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerJump);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerUpdate);
    }

    public void adjustParameters(ItemStack itemStack, Player player) {
        if (player.f_20902_ > 0.0f && player.m_20096_()) {
            player.m_19920_(player.m_20069_() ? 0.016666668f : 0.05f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!player.getPersistentData().m_128441_(PLAYER_NBT_KEY)) {
            player.getPersistentData().m_128350_(PLAYER_NBT_KEY, player.m_274421_());
        }
        player.m_274367_(player.m_6047_() ? 0.5f : 1.0f);
    }

    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && ItemStackHelpers.hasPlayerItem((Player)(player = (Player)event.getEntity()), (Item)this)) {
            player.m_20256_(player.m_20184_().m_82520_(0.0, (double)0.3f, 0.0));
        }
    }

    public void onPlayerUpdate(LivingEvent.LivingTickEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).getPersistentData().m_128441_(PLAYER_NBT_KEY) && !ItemStackHelpers.hasPlayerItem((Player)player, (Item)this)) {
            player.m_274367_(player.getPersistentData().m_128457_(PLAYER_NBT_KEY));
            player.getPersistentData().m_128473_(PLAYER_NBT_KEY);
        }
    }

    public void onPlayerFall(LivingFallEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && ItemStackHelpers.hasPlayerItem((Player)(player = (Player)event.getEntity()), (Item)this)) {
            event.setDistance(event.getDistance() - 2.0f);
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            this.adjustParameters(stack, (Player)entityIn);
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }
}

