/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.data.recipes;

import com.enderio.EnderIO;
import com.enderio.base.common.init.EIOEnchantments;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.data.recipe.RecipeDataUtil;
import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.core.data.recipes.EnderRecipeProvider;
import com.enderio.machines.common.init.MachineRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchanterRecipeProvider
extends EnderRecipeProvider {
    public EnchanterRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        this.build(Enchantments.f_44965_, CountedIngredient.of(16, EIOTags.Items.INGOTS_DARK_STEEL), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44966_, CountedIngredient.of(16, new ItemLike[]{Items.f_42542_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44967_, CountedIngredient.of((TagKey<Item>)Tags.Items.FEATHERS), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44968_, CountedIngredient.of(16, new ItemLike[]{Items.f_42403_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44969_, CountedIngredient.of(16, (TagKey<Item>)Tags.Items.LEATHER), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44970_, CountedIngredient.of(new ItemLike[]{Items.f_42590_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44971_, CountedIngredient.of(new ItemLike[]{Items.f_42094_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44973_, CountedIngredient.of(new ItemLike[]{Items.f_42695_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44974_, CountedIngredient.of(16, new ItemLike[]{Items.f_41980_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44972_, CountedIngredient.of(4, new ItemLike[]{Items.f_42208_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44977_, CountedIngredient.of(12, (TagKey<Item>)Tags.Items.GEMS_QUARTZ), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44978_, CountedIngredient.of(12, new ItemLike[]{Items.f_42583_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44979_, CountedIngredient.of(12, new ItemLike[]{Items.f_42591_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44980_, CountedIngredient.of(new ItemLike[]{Items.f_41869_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44981_, CountedIngredient.of(8, new ItemLike[]{Items.f_42585_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44982_, CountedIngredient.of(new ItemLike[]{Items.f_42678_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44984_, CountedIngredient.of(12, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44985_, CountedIngredient.of((TagKey<Item>)Tags.Items.SLIMEBALLS), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44986_, CountedIngredient.of((TagKey<Item>)Tags.Items.OBSIDIAN), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44962_, CountedIngredient.of((ItemLike)EIOItems.EXPERIENCE_ROD.get()), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44987_, CountedIngredient.of((TagKey<Item>)Tags.Items.GEMS_EMERALD), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44988_, CountedIngredient.of(12, new ItemLike[]{Items.f_42484_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44989_, CountedIngredient.of((TagKey<Item>)Tags.Items.STRING), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44990_, CountedIngredient.of((TagKey<Item>)Tags.Items.NETHERRACK), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44952_, CountedIngredient.of(EIOTags.Items.DUSTS_GRAINS_OF_INFINITY), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44953_, CountedIngredient.of((TagKey<Item>)Tags.Items.GEMS_LAPIS), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44954_, CountedIngredient.of((TagKey<Item>)ItemTags.f_13156_), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44983_, CountedIngredient.of(8, (TagKey<Item>)Tags.Items.INGOTS_IRON), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44958_, CountedIngredient.of(new ItemLike[]{Items.f_151041_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44956_, CountedIngredient.of(8, (TagKey<Item>)Tags.Items.INGOTS_IRON), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44955_, CountedIngredient.of(new ItemLike[]{Items.f_42655_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44959_, CountedIngredient.of(16, (TagKey<Item>)ItemTags.f_13161_), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44961_, CountedIngredient.of(8, (TagKey<Item>)Tags.Items.GEMS_PRISMARINE), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44960_, CountedIngredient.of(16, new ItemLike[]{Items.f_42501_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44957_, CountedIngredient.of(8, new ItemLike[]{Items.f_42688_}), 1, pFinishedRecipeConsumer);
        this.build(Enchantments.f_44976_, CountedIngredient.of(16, new ItemLike[]{Items.f_42050_}), 1, pFinishedRecipeConsumer);
        this.build((Enchantment)EIOEnchantments.SOULBOUND.get(), CountedIngredient.of(EIOTags.Items.GEMS_ENDER_CRYSTAL), 1, pFinishedRecipeConsumer);
        this.build((Enchantment)EIOEnchantments.WITHERING.get(), CountedIngredient.of(4, (ItemLike)EIOItems.WITHERING_POWDER.get()), 1, pFinishedRecipeConsumer);
        this.build((Enchantment)EIOEnchantments.REPELLENT.get(), CountedIngredient.of(4, new ItemLike[]{Items.f_42584_}), 2, pFinishedRecipeConsumer);
        this.build((Enchantment)EIOEnchantments.AUTO_SMELT.get(), CountedIngredient.of(16, new ItemLike[]{Items.f_42593_}), 1, pFinishedRecipeConsumer);
        this.build((Enchantment)EIOEnchantments.XP_BOOST.get(), CountedIngredient.of(16, new ItemLike[]{Items.f_42612_}), 1, pFinishedRecipeConsumer);
    }

    protected void build(Enchantment enchantment, CountedIngredient input, int levelModifier, Consumer<FinishedRecipe> recipeConsumer) {
        recipeConsumer.accept(new FinishedEnchantingRecipe(EnderIO.loc("enchanting/" + ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).m_135815_()), enchantment, input, levelModifier));
    }

    protected static class FinishedEnchantingRecipe
    extends EnderRecipeProvider.EnderFinishedRecipe {
        private final Enchantment enchantment;
        private final CountedIngredient input;
        private final int costMultiplier;

        public FinishedEnchantingRecipe(ResourceLocation id, Enchantment enchantment, CountedIngredient input, int costMultiplier) {
            super(id);
            this.enchantment = enchantment;
            this.input = input;
            this.costMultiplier = costMultiplier;
        }

        @Override
        protected Set<String> getModDependencies() {
            HashSet<String> mods = new HashSet<String>(RecipeDataUtil.getCountedIngredientModIds(this.input));
            mods.add(ForgeRegistries.ENCHANTMENTS.getKey((Object)this.enchantment).m_135827_());
            return mods;
        }

        @Override
        public void m_7917_(JsonObject json) {
            json.addProperty("enchantment", ForgeRegistries.ENCHANTMENTS.getKey((Object)this.enchantment).toString());
            json.add("input", (JsonElement)this.input.toJson());
            json.addProperty("cost_multiplier", (Number)this.costMultiplier);
            super.m_7917_(json);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)MachineRecipes.ENCHANTING.serializer().get();
        }
    }
}

