/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.IOMode;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.io.FixedIOConfig;
import com.enderio.machines.common.io.item.MachineInventory;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.EnchanterMenu;
import com.enderio.machines.common.recipe.EnchanterRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class EnchanterBlockEntity
extends MachineBlockEntity {
    private final RecipeWrapper container = new RecipeWrapper((IItemHandlerModifiable)this.getInventory());
    @Nullable
    private EnchanterRecipe currentRecipe;
    public static final SingleSlotAccess BOOK = new SingleSlotAccess();
    public static final SingleSlotAccess CATALYST = new SingleSlotAccess();
    public static final SingleSlotAccess LAPIS = new SingleSlotAccess();
    public static final SingleSlotAccess OUTPUT = new SingleSlotAccess();

    public EnchanterBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
    }

    public RecipeWrapper getContainer() {
        return this.container;
    }

    @Override
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().inputSlot((slot, stack) -> stack.m_41720_() == Items.f_42614_).slotAccess(BOOK).inputSlot().slotAccess(CATALYST).inputSlot((slot, stack) -> stack.m_204117_(Tags.Items.GEMS_LAPIS)).slotAccess(LAPIS).outputSlot().slotAccess(OUTPUT).build();
    }

    @Override
    public boolean supportsRedstoneControl() {
        return false;
    }

    @Override
    protected IIOConfig createIOConfig() {
        return new FixedIOConfig(IOMode.DISABLED);
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new EnchanterMenu(this, pInventory, pContainerId);
    }

    @Override
    protected MachineInventory createMachineInventory(MachineInventoryLayout layout) {
        return new MachineInventory(this.getIOConfig(), layout){

            protected void onContentsChanged(int slot) {
                if (EnchanterBlockEntity.this.f_58857_ == null) {
                    return;
                }
                EnchanterBlockEntity.this.currentRecipe = EnchanterBlockEntity.this.f_58857_.m_7465_().m_44015_((RecipeType)MachineRecipes.ENCHANTING.type().get(), (Container)EnchanterBlockEntity.this.container, EnchanterBlockEntity.this.f_58857_).orElse(null);
                if (!OUTPUT.isSlot(slot)) {
                    if (EnchanterBlockEntity.this.currentRecipe != null) {
                        OUTPUT.setStackInSlot(this, EnchanterBlockEntity.this.currentRecipe.m_5874_((Container)EnchanterBlockEntity.this.container, EnchanterBlockEntity.this.f_58857_.m_9598_()));
                    } else {
                        OUTPUT.setStackInSlot(this, ItemStack.f_41583_);
                    }
                }
                EnchanterBlockEntity.this.onInventoryContentsChanged(slot);
                EnchanterBlockEntity.this.m_6596_();
            }

            @Override
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (EnchanterBlockEntity.this.f_58857_ == null) {
                    return ItemStack.f_41583_;
                }
                if (OUTPUT.isSlot(slot) && EnchanterBlockEntity.this.f_58857_.m_5776_()) {
                    return ItemStack.f_41583_;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    @Nullable
    public EnchanterRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }
}

