/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.blockentity;

import com.enderio.api.conduit.IConduitType;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.api.misc.ColorControl;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.conduits.common.blockentity.ConduitBlockEntity;
import com.enderio.conduits.common.blockentity.ConduitBundle;
import com.enderio.conduits.common.blockentity.SlotType;
import com.enderio.conduits.common.blockentity.connection.DynamicConnectionState;
import com.enderio.conduits.common.blockentity.connection.IConnectionState;
import com.enderio.conduits.common.blockentity.connection.StaticConnectionStates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public class ConduitConnection
implements INBTSerializable<CompoundTag> {
    private final IConnectionState[] connectionStates = (IConnectionState[])Util.m_137537_(() -> {
        Object[] states = new IConnectionState[9];
        Arrays.fill(states, StaticConnectionStates.DISCONNECTED);
        return states;
    });
    private final ConduitBundle on;
    private static final String KEY_STATIC = "Static";
    private static final String KEY_INDEX = "Index";
    private static final String KEY_IS_EXTRACT = "IsExtract";
    private static final String KEY_EXTRACT = "Extract";
    private static final String KEY_IS_INSERT = "IsInsert";
    private static final String KEY_INSERT = "Insert";
    private static final String KEY_REDSTONE_CONTROL = "RedstoneControl";
    private static final String KEY_REDSTONE_CHANNEL = "Channel";

    public ConduitConnection(ConduitBundle on) {
        this.on = on;
    }

    public void addType(int index) {
        for (int i = 8; i > index; --i) {
            this.connectionStates[i] = this.connectionStates[i - 1];
        }
        this.connectionStates[index] = StaticConnectionStates.DISCONNECTED;
    }

    public void connectTo(Level level, BlockPos pos, NodeIdentifier<?> nodeIdentifier, Direction direction, IConduitType<?> type, int typeIndex, boolean end) {
        if (end) {
            DynamicConnectionState state = DynamicConnectionState.defaultConnection(level, pos, direction, type);
            this.connectionStates[typeIndex] = state;
            ConduitBlockEntity.pushIOState(direction, nodeIdentifier, state);
        } else {
            this.connectionStates[typeIndex] = StaticConnectionStates.CONNECTED;
        }
    }

    public void tryDisconnect(int typeIndex) {
        if (this.connectionStates[typeIndex] != StaticConnectionStates.DISABLED) {
            this.connectionStates[typeIndex] = StaticConnectionStates.DISCONNECTED;
        }
    }

    public void removeType(int index) {
        this.connectionStates[index] = StaticConnectionStates.DISCONNECTED;
        for (int i = index + 1; i < 9; ++i) {
            this.connectionStates[i - 1] = this.connectionStates[i];
        }
        this.connectionStates[8] = StaticConnectionStates.DISCONNECTED;
    }

    public void disconnectType(int index) {
        this.connectionStates[index] = StaticConnectionStates.DISCONNECTED;
    }

    public void disableType(int index) {
        this.connectionStates[index] = StaticConnectionStates.DISABLED;
        this.on.incrementDataVersion();
    }

    public boolean isEnd() {
        return Arrays.stream(this.connectionStates).anyMatch(DynamicConnectionState.class::isInstance);
    }

    public List<IConduitType<?>> getConnectedTypes() {
        ArrayList connected = new ArrayList();
        for (int i = 0; i < this.connectionStates.length; ++i) {
            if (!this.connectionStates[i].isConnection()) continue;
            connected.add(this.on.getTypes().get(i));
        }
        return connected;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < 9; ++i) {
            CompoundTag element = new CompoundTag();
            IConnectionState state = this.connectionStates[i];
            element.m_128379_(KEY_STATIC, state instanceof StaticConnectionStates);
            if (state instanceof StaticConnectionStates) {
                StaticConnectionStates staticState = (StaticConnectionStates)state;
                element.m_128405_(KEY_INDEX, staticState.ordinal());
            } else if (state instanceof DynamicConnectionState) {
                DynamicConnectionState dynamicState = (DynamicConnectionState)state;
                element.m_128379_(KEY_IS_EXTRACT, dynamicState.isExtract());
                element.m_128405_(KEY_EXTRACT, dynamicState.extract().ordinal());
                element.m_128379_(KEY_IS_INSERT, dynamicState.isInsert());
                element.m_128405_(KEY_INSERT, dynamicState.insert().ordinal());
                element.m_128405_(KEY_REDSTONE_CONTROL, dynamicState.control().ordinal());
                element.m_128405_(KEY_REDSTONE_CHANNEL, dynamicState.redstoneChannel().ordinal());
            }
            tag.m_128365_(String.valueOf(i), (Tag)element);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        for (int i = 0; i < 9; ++i) {
            DynamicConnectionState dynState;
            CompoundTag nbt = tag.m_128469_(String.valueOf(i));
            if (nbt.m_128471_(KEY_STATIC)) {
                this.connectionStates[i] = StaticConnectionStates.values()[nbt.m_128451_(KEY_INDEX)];
                continue;
            }
            boolean isExtract = nbt.m_128471_(KEY_IS_EXTRACT);
            int extractIndex = nbt.m_128451_(KEY_EXTRACT);
            boolean isInsert = nbt.m_128471_(KEY_IS_INSERT);
            int insertIndex = nbt.m_128451_(KEY_INSERT);
            int redControl = nbt.m_128451_(KEY_REDSTONE_CONTROL);
            int redChannel = nbt.m_128451_(KEY_REDSTONE_CHANNEL);
            IConnectionState prev = this.connectionStates[i];
            Optional<Object> dyn = Optional.ofNullable(prev instanceof DynamicConnectionState ? (dynState = (DynamicConnectionState)prev) : null);
            this.connectionStates[i] = new DynamicConnectionState(isInsert, ColorControl.values()[insertIndex], isExtract, ColorControl.values()[extractIndex], RedstoneControl.values()[redControl], ColorControl.values()[redChannel], dyn.map(DynamicConnectionState::filterInsert).orElse(ItemStack.f_41583_), dyn.map(DynamicConnectionState::filterExtract).orElse(ItemStack.f_41583_), dyn.map(DynamicConnectionState::upgradeExtract).orElse(ItemStack.f_41583_));
        }
    }

    public ConduitConnection deepCopy(ConduitBundle on) {
        ConduitConnection connection = new ConduitConnection(on);
        System.arraycopy(this.connectionStates, 0, connection.connectionStates, 0, 9);
        return connection;
    }

    public IConnectionState getConnectionState(int index) {
        return this.connectionStates[index];
    }

    public IConnectionState getConnectionState(IConduitType<?> type) {
        return this.connectionStates[this.on.getTypeIndex(type)];
    }

    public void setConnectionState(IConduitType<?> type, IConnectionState state) {
        this.setConnectionState(this.on.getTypeIndex(type), state);
        this.on.incrementDataVersion();
    }

    private void setConnectionState(int i, IConnectionState state) {
        this.connectionStates[i] = state;
        this.on.incrementDataVersion();
    }

    public ItemStack getItem(SlotType type, int conduitIndex) {
        IConnectionState iConnectionState = this.connectionStates[conduitIndex];
        if (iConnectionState instanceof DynamicConnectionState) {
            DynamicConnectionState dynamicConnectionState = (DynamicConnectionState)iConnectionState;
            return dynamicConnectionState.getItem(type);
        }
        return ItemStack.f_41583_;
    }

    public void setItem(SlotType type, int conduitIndex, ItemStack stack) {
        IConnectionState iConnectionState = this.connectionStates[conduitIndex];
        if (iConnectionState instanceof DynamicConnectionState) {
            DynamicConnectionState dynamicConnectionState = (DynamicConnectionState)iConnectionState;
            this.connectionStates[conduitIndex] = dynamicConnectionState.withItem(type, stack);
        }
    }
}

