/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.data.recipe;

import com.enderio.EnderIO;
import com.enderio.base.common.block.glass.FusedQuartzBlock;
import com.enderio.base.common.block.glass.GlassBlocks;
import com.enderio.base.common.block.glass.GlassCollisionPredicate;
import com.enderio.base.common.init.EIOBlocks;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.tag.EIOTags;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class GlassRecipeProvider
extends RecipeProvider {
    public GlassRecipeProvider(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> recipeConsumer) {
        for (GlassBlocks glassBlocks : EIOBlocks.GLASS_BLOCKS.values()) {
            GlassRecipeProvider.recolor(glassBlocks, recipeConsumer);
            if (glassBlocks.getGlassIdentifier().collisionPredicate() == GlassCollisionPredicate.NONE) {
                for (Item token : new Item[]{(Item)EIOItems.PLAYER_TOKEN.get(), (Item)EIOItems.ANIMAL_TOKEN.get(), (Item)EIOItems.MONSTER_TOKEN.get()}) {
                    GlassRecipeProvider.addCollisionToken(glassBlocks, token, recipeConsumer);
                }
                continue;
            }
            GlassRecipeProvider.invert(glassBlocks, recipeConsumer);
        }
    }

    private static void recolor(GlassBlocks blocks, Consumer<FinishedRecipe> recipeConsumer) {
        for (DyeColor color : DyeColor.values()) {
            ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blocks.COLORS.get(color).get()), (int)8);
            for (int i = 0; i < 8; ++i) {
                builder.m_206419_(EIOTags.Items.GLASS_TAGS.get(blocks.getGlassIdentifier()));
            }
            builder.m_206419_(color.getTag()).m_126132_("has_ingredient", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)blocks.CLEAR.get()})).m_126140_(recipeConsumer, EnderIO.loc("recolor_" + ForgeRegistries.BLOCKS.getKey((Object)((Block)blocks.COLORS.get(color).get())).m_135815_()));
        }
    }

    private static void addCollisionToken(GlassBlocks blocks, Item token, Consumer<FinishedRecipe> recipeConsumer) {
        GlassCollisionPredicate collision = GlassCollisionPredicate.fromToken(token);
        if (collision == null) {
            return;
        }
        FusedQuartzBlock output = (FusedQuartzBlock)((Object)EIOBlocks.GLASS_BLOCKS.get((Object)blocks.getGlassIdentifier().withCollision((GlassCollisionPredicate)collision)).CLEAR.get());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)8).m_126127_(Character.valueOf('G'), (ItemLike)blocks.CLEAR.get()).m_126127_(Character.valueOf('T'), (ItemLike)token).m_126130_("GGG").m_126130_("GTG").m_126130_("GGG").m_126132_("has_ingredient", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{token})).m_126140_(recipeConsumer, EnderIO.loc("collision_token_" + ForgeRegistries.BLOCKS.getKey((Object)output).m_135815_()));
    }

    private static void invert(GlassBlocks blocks, Consumer<FinishedRecipe> recipeConsumer) {
        GlassCollisionPredicate collision = GlassCollisionPredicate.invert(blocks.getGlassIdentifier().collisionPredicate());
        if (collision == GlassCollisionPredicate.NONE) {
            return;
        }
        FusedQuartzBlock output = (FusedQuartzBlock)((Object)EIOBlocks.GLASS_BLOCKS.get((Object)blocks.getGlassIdentifier().withCollision((GlassCollisionPredicate)collision)).CLEAR.get());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)8).m_126127_(Character.valueOf('G'), (ItemLike)blocks.CLEAR.get()).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_41978_).m_126130_("GGG").m_126130_("GTG").m_126130_("GGG").m_126132_("has_ingredient", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)blocks.CLEAR.get()})).m_126140_(recipeConsumer, EnderIO.loc("invert_" + ForgeRegistries.BLOCKS.getKey((Object)output).m_135815_()));
    }
}

