/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.tool;

import com.enderio.api.capability.CoordinateSelection;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.base.common.menu.CoordinateMenu;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;

public class CoordinateSelectorItem
extends Item {
    public CoordinateSelectorItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!CoordinateSelectorItem.checkPaper(pPlayer)) {
            return super.m_7203_(pLevel, pPlayer, pHand);
        }
        BlockHitResult hitResult = pLevel.m_45547_(new ClipContext(pPlayer.m_146892_(), pPlayer.m_20154_().m_82490_(64.0).m_82549_(pPlayer.m_146892_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)pPlayer));
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            if (pPlayer instanceof LocalPlayer) {
                pPlayer.m_5661_(EIOLang.COORDINATE_SELECTOR_NO_BLOCK, true);
            }
            return super.m_7203_(pLevel, pPlayer, pHand);
        }
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            CoordinateSelectorItem.openMenu(serverPlayer, pLevel, hitResult.m_82425_());
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.f_46443_);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (pContext.m_43723_() != null && CoordinateSelectorItem.checkPaper(pContext.m_43723_())) {
            Player player = pContext.m_43723_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CoordinateSelectorItem.openMenu(serverPlayer, pContext.m_43725_(), pContext.m_8083_());
            }
            return InteractionResult.m_19078_((boolean)pContext.m_43725_().f_46443_);
        }
        return super.m_6225_(pContext);
    }

    private static void openMenu(ServerPlayer player, Level level, BlockPos pos) {
        final CoordinateSelection selection = CoordinateSelection.of(level, pos);
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"");
            }

            public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
                return new CoordinateMenu(pContainerId, selection, null);
            }
        }, buf -> CoordinateMenu.writeAdditionalData(buf, selection, ""));
    }

    private static boolean checkPaper(Player player) {
        if (player.m_150109_().m_36063_(Items.f_42516_.m_7968_())) {
            return true;
        }
        if (player instanceof LocalPlayer) {
            player.m_5661_(EIOLang.COORDINATE_SELECTOR_NO_PAPER, true);
        }
        return false;
    }
}

