/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.utility;

import com.enderio.machines.common.io.item.MachineInventory;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RecipeInputCache<C extends Container, T extends Recipe<C>> {
    private final Supplier<RecipeType<T>> recipeType;
    private final HashMap<Item, HashSet<T>> itemToRecipesCache;
    private final HashMap<T, List<Ingredient>> recipeToIngredientCache;
    private boolean isDirty;

    public RecipeInputCache(Supplier<RecipeType<T>> recipeType) {
        this.recipeType = recipeType;
        this.itemToRecipesCache = new HashMap();
        this.recipeToIngredientCache = new HashMap();
    }

    public boolean hasValidRecipeIf(MachineInventory inventory, MultiSlotAccess inputs, int slot, ItemStack toAdd) {
        ArrayList<ItemStack> currentItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inputs.size(); ++i) {
            ItemStack invStack = inputs.get(i).getItemStack(inventory);
            if (i == slot) {
                currentItems.add(toAdd);
                continue;
            }
            if (invStack.m_41619_()) continue;
            currentItems.add(invStack);
        }
        return this.hasRecipe(currentItems);
    }

    public boolean hasRecipe(List<ItemStack> inputs) {
        this.checkCacheRebuild();
        Set<T> possibleMatches = null;
        for (ItemStack input : inputs) {
            HashSet<T> matches = this.itemToRecipesCache.get(input.m_41720_());
            if (matches == null) {
                return false;
            }
            if ((possibleMatches = possibleMatches == null ? matches : possibleMatches.stream().filter(matches::contains).collect(Collectors.toSet())).isEmpty()) {
                return false;
            }
            boolean anyMatches = false;
            for (Recipe match : possibleMatches) {
                List<Ingredient> ingredients = this.recipeToIngredientCache.get(match);
                boolean[] checked = new boolean[inputs.size()];
                int matchCount = 0;
                block2: for (Ingredient ingredient : ingredients) {
                    for (int i = 0; i < inputs.size(); ++i) {
                        if (checked[i] || !ingredient.test(inputs.get(i))) continue;
                        checked[i] = true;
                        ++matchCount;
                        continue block2;
                    }
                }
                if (matchCount < inputs.size()) continue;
                anyMatches = true;
            }
            if (anyMatches) continue;
            return false;
        }
        return true;
    }

    public void markCacheDirty() {
        this.isDirty = true;
    }

    private void checkCacheRebuild() {
        if (this.isDirty && EffectiveSide.get().isServer()) {
            this.rebuildCache(ServerLifecycleHooks.getCurrentServer().m_129894_());
            this.isDirty = false;
        }
    }

    public void rebuildCache(RecipeManager recipeManager) {
        this.itemToRecipesCache.clear();
        this.recipeToIngredientCache.clear();
        recipeManager.m_44013_(this.recipeType.get()).forEach(recipe -> {
            List<Item> items = recipe.m_7527_().stream().flatMap(ingredient -> Arrays.stream(ingredient.m_43908_())).map(ItemStack::m_41720_).toList();
            this.recipeToIngredientCache.put(recipe, (List<Ingredient>)recipe.m_7527_());
            for (Item item : items) {
                this.itemToRecipesCache.computeIfAbsent(item, i -> new HashSet()).add(recipe);
            }
        });
    }
}

