/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.common.util.ExperienceUtil;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.menu.XPObeliskMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class XPObeliskBlockEntity
extends MachineBlockEntity {
    IntegerNetworkDataSlot xpTankDataSlot = new IntegerNetworkDataSlot(() -> this.getFluidTankNN().getFluidAmount(), amount -> this.getFluidTankNN().setFluid(new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), amount.intValue())));

    public XPObeliskBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.addDataSlot(this.xpTankDataSlot);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new XPObeliskMenu(this, playerInventory, containerId);
    }

    @Override
    @Nullable
    protected FluidTank createFluidTank() {
        return new FluidTank(Integer.MAX_VALUE, fluidStack -> fluidStack.getFluid().m_205067_(EIOTags.Fluids.EXPERIENCE)){

            protected void onContentsChanged() {
                super.onContentsChanged();
                XPObeliskBlockEntity.this.m_6596_();
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (this.isFluidValid(resource)) {
                    Fluid currentFluid = this.getFluid().getFluid();
                    if (currentFluid == Fluids.f_76191_ || resource.getFluid().m_6212_(currentFluid)) {
                        return super.fill(resource, action);
                    }
                    return super.fill(new FluidStack(currentFluid, resource.getAmount()), action);
                }
                return 0;
            }
        };
    }

    public void addLevelToPlayer(int levelDiff, Player player) {
        int requestedLevel = player.f_36078_ + levelDiff;
        requestedLevel = Math.max(requestedLevel, 0);
        long playerXP = ExperienceUtil.getPlayerTotalXp(player);
        long requestedXP = ExperienceUtil.getTotalXpFromLevel(requestedLevel) - playerXP;
        int storedXP = this.getFluidTankNN().getFluidAmount() / ExperienceUtil.EXP_TO_FLUID;
        long awardXP = levelDiff > 0 ? Math.min((long)storedXP, requestedXP) : requestedXP;
        this.awardXP(awardXP, player);
    }

    public void addAllLevelToPlayer(boolean give, Player player) {
        long awardXP = 0L;
        awardXP = give ? (long)(this.getFluidTankNN().getFluidAmount() / ExperienceUtil.EXP_TO_FLUID) : -ExperienceUtil.getPlayerTotalXp(player);
        this.awardXP(awardXP, player);
    }

    public void awardXP(long exp, Player player) {
        long volumeToRemove = exp * (long)ExperienceUtil.EXP_TO_FLUID;
        if (volumeToRemove > 0L) {
            int cappedVolume = (int)Math.min(Integer.MAX_VALUE, volumeToRemove);
            FluidStack drained = this.getFluidTankNN().drain(new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), cappedVolume), IFluidHandler.FluidAction.EXECUTE);
            player.m_6756_(drained.getAmount() / ExperienceUtil.EXP_TO_FLUID);
        } else {
            int cappedVolume = (int)Math.min(Integer.MAX_VALUE, -volumeToRemove);
            int filled = this.getFluidTankNN().fill(new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), cappedVolume), IFluidHandler.FluidAction.EXECUTE);
            player.m_6756_(-1 * filled / ExperienceUtil.EXP_TO_FLUID);
        }
    }
}

