/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.EnderIO;
import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.integration.IntegrationManager;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.core.common.blockentity.EnderBlockEntity;
import com.enderio.core.common.network.slot.EnumNetworkDataSlot;
import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.machines.common.blockentity.AlloySmelterMode;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.blockentity.task.PoweredCraftingMachineTask;
import com.enderio.machines.common.blockentity.task.host.CraftingMachineTaskHost;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.integrations.vanilla.VanillaAlloySmeltingRecipe;
import com.enderio.machines.common.io.energy.IMachineEnergyStorage;
import com.enderio.machines.common.io.item.MachineInventory;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.AlloySmelterMenu;
import com.enderio.machines.common.recipe.AlloySmeltingRecipe;
import com.enderio.machines.common.recipe.RecipeCaches;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlloySmelterBlockEntity
extends PoweredMachineBlockEntity {
    public static final MultiSlotAccess INPUTS = new MultiSlotAccess();
    public static final SingleSlotAccess OUTPUT = new SingleSlotAccess();
    public static final QuadraticScalable CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.ALLOY_SMELTER_CAPACITY);
    public static final QuadraticScalable USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.ALLOY_SMELTER_USAGE);
    private AlloySmelterMode mode = AlloySmelterMode.ALL;
    protected final AlloySmeltingMachineTaskHost craftingTaskHost = new AlloySmeltingMachineTaskHost(this, this::canAcceptTask, (RecipeType<AlloySmeltingRecipe>)((RecipeType)MachineRecipes.ALLOY_SMELTING.type().get()), new AlloySmeltingRecipe.ContainerWrapper(this.isPrimitiveSmelter(), (IItemHandlerModifiable)this.getInventoryNN()), this::createTask);
    @Nullable
    private final EnumNetworkDataSlot<AlloySmelterMode> modeDataSlot;

    public AlloySmelterBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(EnergyIOMode.Input, CAPACITY, USAGE, pType, pWorldPosition, pBlockState);
        if (!this.isPrimitiveSmelter()) {
            this.modeDataSlot = new EnumNetworkDataSlot<AlloySmelterMode>(AlloySmelterMode.class, this::getMode, m -> {
                this.mode = m;
                this.craftingTaskHost.newTaskAvailable();
            });
            this.addDataSlot(this.modeDataSlot);
        } else {
            this.modeDataSlot = null;
        }
    }

    protected boolean canAcceptTask() {
        return this.hasEnergy();
    }

    public AlloySmelterMode getMode() {
        return this.mode;
    }

    public void setMode(AlloySmelterMode mode) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.clientUpdateSlot(this.modeDataSlot, mode);
        } else {
            this.mode = mode;
            this.craftingTaskHost.newTaskAvailable();
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new AlloySmelterMenu(this, inventory, containerId);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.canAct()) {
            this.craftingTaskHost.tick();
        }
    }

    public void onLoad() {
        super.onLoad();
        this.craftingTaskHost.onLevelReady();
    }

    protected boolean isPrimitiveSmelter() {
        return false;
    }

    protected MultiSlotAccess getInputsSlotAccess() {
        return INPUTS;
    }

    protected SingleSlotAccess getOutputSlotAccess() {
        return OUTPUT;
    }

    @Override
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().inputSlot(3, this::acceptSlotInput).slotAccess(INPUTS).outputSlot().slotAccess(OUTPUT).capacitor().build();
    }

    protected boolean acceptSlotInput(int slot, ItemStack stack) {
        List<ItemStack> currentStacks;
        if (this.getMode().canAlloy() && RecipeCaches.ALLOY_SMELTING.hasValidRecipeIf(this.getInventoryNN(), this.getInputsSlotAccess(), slot, stack)) {
            return true;
        }
        return this.getMode().canSmelt() && ((currentStacks = this.getInputsSlotAccess().getAccesses().stream().map(i -> i.isSlot(slot) ? stack : i.getItemStack(this.getInventoryNN())).filter(i -> !i.m_41619_()).toList()).stream().allMatch(i -> i.m_150930_(stack.m_41720_())) || currentStacks.size() == 1) && RecipeCaches.SMELTING.hasRecipe(List.of(stack));
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        this.craftingTaskHost.newTaskAvailable();
    }

    public float getCraftingProgress() {
        return this.craftingTaskHost.getProgress();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy() && this.craftingTaskHost.hasTask();
    }

    protected AlloySmeltingMachineTask createTask(Level level, AlloySmeltingRecipe.ContainerWrapper container, @Nullable AlloySmeltingRecipe recipe) {
        return new AlloySmeltingMachineTask(level, this.getInventoryNN(), this.getEnergyStorage(), container, this.getInputsSlotAccess(), this.getOutputSlotAccess(), recipe);
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        this.craftingTaskHost.save(pTag);
        if (!this.isPrimitiveSmelter()) {
            pTag.m_128405_("Mode", this.mode.ordinal());
        }
        pTag.m_128405_("ProcessedInputs", ((AlloySmeltingRecipe.ContainerWrapper)((Object)this.craftingTaskHost.getContainer())).getInputsTaken());
        super.m_183515_(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        this.craftingTaskHost.load(pTag);
        if (!this.isPrimitiveSmelter()) {
            try {
                this.mode = AlloySmelterMode.values()[pTag.m_128451_("Mode")];
            }
            catch (IndexOutOfBoundsException ex) {
                EnderIO.LOGGER.error("Invalid alloy smelter mode loaded from NBT. Ignoring.");
            }
        }
        ((AlloySmeltingRecipe.ContainerWrapper)((Object)this.craftingTaskHost.getContainer())).setInputsTaken(pTag.m_128451_("ProcessedInputs"));
        super.m_142466_(pTag);
    }

    protected class AlloySmeltingMachineTaskHost
    extends CraftingMachineTaskHost<AlloySmeltingRecipe, AlloySmeltingRecipe.ContainerWrapper> {
        public AlloySmeltingMachineTaskHost(EnderBlockEntity blockEntity, Supplier<Boolean> canAcceptNewTask, RecipeType<AlloySmeltingRecipe> recipeType, AlloySmeltingRecipe.ContainerWrapper container, CraftingMachineTaskHost.ICraftingMachineTaskFactory<AlloySmeltingMachineTask, AlloySmeltingRecipe, AlloySmeltingRecipe.ContainerWrapper> taskFactory) {
            super(blockEntity, canAcceptNewTask, recipeType, container, taskFactory);
        }

        @Override
        protected Optional<AlloySmeltingRecipe> findRecipe() {
            Optional<AlloySmeltingRecipe> recipe;
            Level level = this.getLevel();
            if (level == null) {
                return Optional.empty();
            }
            if (AlloySmelterBlockEntity.this.getMode().canAlloy() && (recipe = super.findRecipe()).isPresent()) {
                return recipe;
            }
            if (AlloySmelterBlockEntity.this.getMode().canSmelt()) {
                for (int i = 0; i < INPUTS.size(); ++i) {
                    Optional recipe2 = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new ContainerSubWrapper((AlloySmeltingRecipe.ContainerWrapper)((Object)this.getContainer()), i), level);
                    if (!recipe2.isPresent() || !IntegrationManager.allMatch(integration -> integration.acceptSmeltingRecipe((SmeltingRecipe)recipe2.get()))) continue;
                    return Optional.of(new VanillaAlloySmeltingRecipe((SmeltingRecipe)recipe2.get()));
                }
            }
            return Optional.empty();
        }
    }

    protected static class AlloySmeltingMachineTask
    extends PoweredCraftingMachineTask<AlloySmeltingRecipe, AlloySmeltingRecipe.ContainerWrapper> {
        private final MultiSlotAccess inputs;

        public AlloySmeltingMachineTask(@NotNull Level level, MachineInventory inventory, IMachineEnergyStorage energyStorage, AlloySmeltingRecipe.ContainerWrapper container, MultiSlotAccess inputs, SingleSlotAccess outputSlot, @Nullable AlloySmeltingRecipe recipe) {
            super(level, inventory, energyStorage, container, outputSlot, recipe);
            this.inputs = inputs;
        }

        @Override
        protected void onDetermineOutputs(AlloySmeltingRecipe recipe) {
            if (recipe instanceof VanillaAlloySmeltingRecipe) {
                CountedIngredient input = recipe.getInputs().get(0);
                int inputCount = 0;
                for (int i = this.inputs.size() - 1; i >= 0; --i) {
                    ItemStack itemStack = this.inputs.get(i).getItemStack(this.getInventory());
                    if (!input.test(itemStack)) continue;
                    inputCount += Math.min(3 - inputCount, itemStack.m_41613_());
                }
                ((AlloySmeltingRecipe.ContainerWrapper)this.container).setInputsTaken(inputCount);
            } else {
                ((AlloySmeltingRecipe.ContainerWrapper)this.container).setInputsTaken(1);
            }
        }

        @Override
        protected void consumeInputs(AlloySmeltingRecipe recipe) {
            MachineInventory inv = this.getInventory();
            if (recipe instanceof VanillaAlloySmeltingRecipe) {
                CountedIngredient input = recipe.getInputs().get(0);
                int consumed = 0;
                for (int i = this.inputs.size() - 1; i >= 0; --i) {
                    ItemStack itemStack = this.inputs.get(i).getItemStack(this.getInventory());
                    if (!input.test(itemStack)) continue;
                    int consumedNow = Math.min(((AlloySmeltingRecipe.ContainerWrapper)this.container).getInputsTaken() - consumed, itemStack.m_41613_());
                    itemStack.m_41774_(consumedNow);
                    consumed += consumedNow;
                }
            } else {
                List<CountedIngredient> inputs = recipe.getInputs();
                boolean[] consumed = new boolean[3];
                for (SingleSlotAccess slot : this.inputs.getAccesses()) {
                    ItemStack stack = slot.getItemStack(inv);
                    for (int i = 0; i < 3; ++i) {
                        if (consumed[i]) continue;
                        if (i < inputs.size()) {
                            CountedIngredient input = inputs.get(i);
                            if (!input.test(stack)) continue;
                            consumed[i] = true;
                            stack.m_41774_(input.count());
                            continue;
                        }
                        if (!stack.m_41619_()) continue;
                        consumed[i] = true;
                    }
                }
            }
        }

        @Override
        @Nullable
        protected AlloySmeltingRecipe loadRecipe(ResourceLocation id) {
            return this.level.m_7465_().m_44043_(id).map(recipe -> {
                if (recipe.m_6671_() == MachineRecipes.ALLOY_SMELTING.type().get()) {
                    return (AlloySmeltingRecipe)recipe;
                }
                if (recipe.m_6671_() == RecipeType.f_44108_) {
                    return new VanillaAlloySmeltingRecipe((SmeltingRecipe)recipe);
                }
                return null;
            }).orElse(null);
        }
    }

    public record ContainerSubWrapper(AlloySmeltingRecipe.ContainerWrapper wrapper, int index) implements Container
    {
        public int m_6643_() {
            return 1;
        }

        public boolean m_7983_() {
            return INPUTS.get(this.index).getItemStack((Container)this.wrapper).m_41619_();
        }

        public ItemStack m_8020_(int slot) {
            if (slot != 0) {
                return ItemStack.f_41583_;
            }
            return INPUTS.get(this.index).getItemStack((Container)this.wrapper);
        }

        public ItemStack m_7407_(int slot, int amount) {
            return ItemStack.f_41583_;
        }

        public ItemStack m_8016_(int slot) {
            return ItemStack.f_41583_;
        }

        public void m_6836_(int slot, ItemStack stack) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return false;
        }

        public void m_6211_() {
        }
    }
}

