/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.loader;

import com.mojang.authlib.GameProfile;
import customskinloader.CustomSkinLoader;
import customskinloader.config.SkinSiteProfile;
import customskinloader.plugin.ICustomSkinLoaderPlugin;
import customskinloader.plugin.PluginLoader;
import customskinloader.profile.UserProfile;
import java.util.HashMap;

public class ProfileLoader {
    public static final HashMap<String, IProfileLoader> LOADERS = ProfileLoader.initLoaders();

    private static HashMap<String, IProfileLoader> initLoaders() {
        HashMap<String, IProfileLoader> profileLoaders = new HashMap<String, IProfileLoader>();
        for (ICustomSkinLoaderPlugin plugin : PluginLoader.PLUGINS) {
            IProfileLoader profileLoader = plugin.getProfileLoader();
            if (profileLoader == null) continue;
            profileLoaders.put(profileLoader.getName().toLowerCase(), profileLoader);
            CustomSkinLoader.logger.info("Add a profile loader: " + profileLoader.getName());
        }
        return profileLoaders;
    }

    public static interface IProfileLoader {
        public UserProfile loadProfile(SkinSiteProfile var1, GameProfile var2) throws Exception;

        public boolean compare(SkinSiteProfile var1, SkinSiteProfile var2);

        public String getName();

        public void init(SkinSiteProfile var1);
    }
}

