/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item;

import java.util.List;
import net.brnbrd.delightful.common.item.DItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FurnaceFuelItem
extends DItem {
    private final int fuelTime;

    public FurnaceFuelItem(Item.Properties pProperties, int fuelTime) {
        super(pProperties);
        this.fuelTime = fuelTime;
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> comps, @NotNull TooltipFlag pIsAdvanced) {
        if (this.enabled()) {
            comps.add((Component)Component.m_237113_((String)"Sneak Right Click:").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.UNDERLINE));
            comps.add((Component)Component.m_237113_((String)("Applies " + this.fuelTime / 20 + "s of burn time")));
        }
        super.m_7373_(stack, level, comps, pIsAdvanced);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext con) {
        return FurnaceFuelItem.useFuel(con.m_43722_(), con.m_43725_().getExistingBlockEntity(con.m_8083_()), con.m_43723_());
    }

    public static InteractionResult useFuel(ItemStack stack, BlockEntity entity, Player player) {
        Item item = stack.m_41720_();
        if (item instanceof FurnaceFuelItem) {
            FurnaceFuelItem fuel = (FurnaceFuelItem)item;
            if (entity instanceof AbstractFurnaceBlockEntity) {
                AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)entity;
                ContainerData data = furnace.f_58311_;
                int newTime = data.m_6413_(0) + fuel.fuelTime + 1;
                data.m_8050_(0, newTime);
                data.m_8050_(1, newTime);
                furnace.m_6596_();
                FurnaceFuelItem.shrinkAdd(player, stack);
                return InteractionResult.CONSUME_PARTIAL;
            }
        }
        return InteractionResult.FAIL;
    }

    private static void shrinkAdd(Player p, ItemStack i) {
        if (i.hasCraftingRemainingItem()) {
            p.m_36356_(i.getCraftingRemainingItem());
        }
        i.m_41774_(1);
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.fuelTime;
    }
}

