/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.defaultsettings;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import net.jomcraft.defaultsettings.DefaultSettings;
import net.jomcraft.defaultsettings.KeyContainer;
import net.jomcraft.jcplugin.FileUtilNoMC;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Level;

public class FileUtil {
    public static void restoreContents() throws NullPointerException, IOException {
        File serversFile;
        File optionsAmecs;
        File optionsJEK;
        File optionsShaders;
        File optionsOF;
        String version = FileUtilNoMC.getMainJSON().getVersion();
        if (!DefaultSettings.VERSION.equals(version)) {
            FileUtilNoMC.mainJson.setVersion(DefaultSettings.VERSION).setPrevVersion(version);
        }
        if (FileUtilNoMC.mainJson.generatedBy.equals("<default>")) {
            FileUtilNoMC.mainJson.generatedBy = FileUtilNoMC.privateJson.privateIdentifier;
        }
        FileUtilNoMC.activeProfile = FileUtilNoMC.privateJson.currentProfile;
        if (!FileUtilNoMC.privateJson.firstBootUp) {
            FileUtilNoMC.copyAndHashPrivate((boolean)true, (boolean)true);
        }
        if (!(optionsOF = new File(FileUtilNoMC.mcDataDir, "optionsof.txt")).exists()) {
            FileUtilNoMC.restoreOptionsOF();
        }
        if (!(optionsShaders = new File(FileUtilNoMC.mcDataDir, "optionsshaders.txt")).exists()) {
            FileUtilNoMC.restoreOptionsShaders();
        }
        if (!(optionsJEK = new File(FileUtilNoMC.mcDataDir, "options.justenoughkeys.txt")).exists()) {
            FileUtilNoMC.restoreOptionsJEK();
        }
        if (!(optionsAmecs = new File(FileUtilNoMC.mcDataDir, "options.amecsapi.txt")).exists()) {
            FileUtilNoMC.restoreOptionsAmecs();
        }
        if (!(serversFile = new File(FileUtilNoMC.mcDataDir, "servers.dat")).exists()) {
            FileUtilNoMC.restoreServers();
        }
        FileUtilNoMC.mainJson.save();
    }

    public static void restoreKeys(boolean update, boolean initial) throws NullPointerException, IOException, NumberFormatException {
        DefaultSettings.keyRebinds.clear();
        File keysFile = new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.activeProfile + "/keys.txt");
        if (keysFile.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(keysFile));
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    DefaultSettings.keyRebinds.put(line.split(":")[0], new KeyContainer(InputConstants.m_84851_((String)line.split(":")[1]), line.split(":").length > 2 ? KeyModifier.valueFromString((String)line.split(":")[2]) : KeyModifier.NONE));
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
            if (update) {
                ArrayList<String> presentKeys = new ArrayList<String>();
                File localKeysFile = new File(FileUtilNoMC.mcDataDir, "options.txt");
                if (localKeysFile.exists()) {
                    BufferedReader localReader = null;
                    try {
                        String line;
                        localReader = new BufferedReader(new FileReader(localKeysFile));
                        while ((line = localReader.readLine()) != null) {
                            if (line.isEmpty() || !line.startsWith("key_key.")) continue;
                            String key = line.split("key_")[1].split(":")[0];
                            presentKeys.add(key);
                        }
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (NullPointerException e) {
                        throw e;
                    }
                    finally {
                        try {
                            localReader.close();
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (NullPointerException e) {
                            throw e;
                        }
                    }
                }
                for (KeyMapping keyBinding : Minecraft.m_91087_().f_91066_.f_92059_) {
                    if (!DefaultSettings.keyRebinds.containsKey(keyBinding.m_90860_())) continue;
                    KeyContainer container = DefaultSettings.keyRebinds.get(keyBinding.m_90860_());
                    if (initial || !presentKeys.contains(keyBinding.m_90860_())) {
                        keyBinding.m_90848_(container.input);
                    }
                    keyBinding.f_90814_ = container.input;
                    ObfuscationReflectionHelper.setPrivateValue(KeyMapping.class, (Object)keyBinding, (Object)container.modifier, (String)"keyModifierDefault");
                    keyBinding.setKeyModifierAndCode(keyBinding.getDefaultKeyModifier(), container.input);
                }
                KeyMapping.m_90854_();
            }
        }
    }

    public static void saveKeys() throws IOException, NullPointerException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.activeProfile + "/keys.txt")));
            for (KeyMapping keyBinding : Minecraft.m_91087_().f_91066_.f_92059_) {
                writer.print(keyBinding.m_90860_() + ":" + keyBinding.getKey().toString() + ":" + keyBinding.getKeyModifier().name() + "\n");
            }
        }
        BufferedReader reader = null;
        if (new File(FileUtilNoMC.mcDataDir, "options.justenoughkeys.txt").exists()) {
            try {
                String line;
                writer = new PrintWriter(new FileWriter(new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.activeProfile + "/options.justenoughkeys.txt")));
                reader = new BufferedReader(new FileReader(new File(FileUtilNoMC.mcDataDir, "options.justenoughkeys.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
        if (new File(FileUtilNoMC.mcDataDir, "options.amecsapi.txt").exists()) {
            try {
                String line;
                writer = new PrintWriter(new FileWriter(new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.activeProfile + "/options.amecsapi.txt")));
                reader = new BufferedReader(new FileReader(new File(FileUtilNoMC.mcDataDir, "options.amecsapi.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static boolean saveOptions() throws NullPointerException, IOException {
        String line;
        Minecraft.m_91087_().f_91066_.m_92169_();
        PrintWriter writer = null;
        BufferedReader reader = null;
        try {
            writer = new PrintWriter(new FileWriter(new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.activeProfile + "/options.txt")));
            reader = new BufferedReader(new FileReader(new File(FileUtilNoMC.mcDataDir, "options.txt")));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("key_")) continue;
                writer.print(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
        }
        if (!new File(FileUtilNoMC.mcDataDir, "optionsof.txt").exists()) {
            return false;
        }
        try {
            writer = new PrintWriter(new FileWriter(new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.activeProfile + "/optionsof.txt")));
            reader = new BufferedReader(new FileReader(new File(FileUtilNoMC.mcDataDir, "optionsof.txt")));
            while ((line = reader.readLine()) != null) {
                writer.print(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
        }
        if (!new File(FileUtilNoMC.mcDataDir, "optionsshaders.txt").exists()) {
            return false;
        }
        try {
            writer = new PrintWriter(new FileWriter(new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.activeProfile + "/optionsshaders.txt")));
            reader = new BufferedReader(new FileReader(new File(FileUtilNoMC.mcDataDir, "optionsshaders.txt")));
            while ((line = reader.readLine()) != null) {
                writer.print(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
        }
        return true;
    }

    public static InputStream getKeysStream() throws IOException, NullPointerException {
        FileInputStream stream = null;
        File file = new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.activeProfile + "/keys.txt_temp");
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(file));
            for (KeyMapping keyBinding : Minecraft.m_91087_().f_91066_.f_92059_) {
                writer.print(keyBinding.m_90860_() + ":" + keyBinding.getKey().toString() + ":" + keyBinding.getKeyModifier().name() + "\n");
            }
            stream = new FileInputStream(file);
        }
        return stream;
    }

    public static boolean checkChanged() {
        boolean ret = false;
        try {
            InputStream keys = FileUtil.getKeysStream();
            InputStream options = FileUtilNoMC.getOptionsStream();
            InputStream optionsOF = FileUtilNoMC.getOptionsOFStream();
            InputStream optionsShaders = FileUtilNoMC.getOptionsShadersStream();
            InputStream optionsJEK = FileUtilNoMC.getOptionsJEKStream();
            InputStream optionsAmecs = FileUtilNoMC.getOptionsAmecsStream();
            InputStream servers = FileUtilNoMC.getServersStream();
            String hashO = "";
            String writtenHashO = "";
            if (options != null) {
                hashO = FileUtilNoMC.fileToHash((InputStream)options);
                writtenHashO = (String)FileUtilNoMC.mainJson.hashes.get(FileUtilNoMC.activeProfile + "/options.txt");
            }
            String hashK = "";
            String writtenHashK = "";
            if (keys != null) {
                hashK = FileUtilNoMC.fileToHash((InputStream)keys);
                writtenHashK = (String)FileUtilNoMC.mainJson.hashes.get(FileUtilNoMC.activeProfile + "/keys.txt");
            }
            String hashOF = "";
            String writtenHashOF = "";
            if (optionsOF != null) {
                hashOF = FileUtilNoMC.fileToHash((InputStream)optionsOF);
                writtenHashOF = (String)FileUtilNoMC.mainJson.hashes.get(FileUtilNoMC.activeProfile + "/optionsof.txt");
            }
            String hashShaders = "";
            String writtenHashShaders = "";
            if (optionsShaders != null) {
                hashShaders = FileUtilNoMC.fileToHash((InputStream)optionsShaders);
                writtenHashShaders = (String)FileUtilNoMC.mainJson.hashes.get(FileUtilNoMC.activeProfile + "/optionsshaders.txt");
            }
            String hashJEK = "";
            String writtenHashJEK = "";
            if (optionsJEK != null) {
                hashJEK = FileUtilNoMC.fileToHash((InputStream)optionsJEK);
                writtenHashJEK = (String)FileUtilNoMC.mainJson.hashes.get(FileUtilNoMC.activeProfile + "/options.justenoughkeys.txt");
            }
            String hashAmecs = "";
            String writtenHashAmecs = "";
            if (optionsAmecs != null) {
                hashAmecs = FileUtilNoMC.fileToHash((InputStream)optionsAmecs);
                writtenHashAmecs = (String)FileUtilNoMC.mainJson.hashes.get(FileUtilNoMC.activeProfile + "/options.amecsapi.txt");
            }
            String hashS = "";
            String writtenHashS = "";
            if (servers != null) {
                hashS = FileUtilNoMC.fileToHash((InputStream)servers);
                writtenHashS = (String)FileUtilNoMC.mainJson.hashes.get(FileUtilNoMC.activeProfile + "/servers.dat");
            }
            if (FileUtilNoMC.mainJson.hashes.containsKey(FileUtilNoMC.activeProfile + "/options.txt") && !hashO.equals(writtenHashO)) {
                ret = true;
            } else if (FileUtilNoMC.mainJson.hashes.containsKey(FileUtilNoMC.activeProfile + "/keys.txt") && !hashK.equals(writtenHashK)) {
                ret = true;
            } else if (FileUtilNoMC.mainJson.hashes.containsKey(FileUtilNoMC.activeProfile + "/optionsof.txt") && !hashOF.equals(writtenHashOF)) {
                ret = true;
            } else if (FileUtilNoMC.mainJson.hashes.containsKey(FileUtilNoMC.activeProfile + "/optionsshaders.txt") && !hashShaders.equals(writtenHashShaders)) {
                ret = true;
            } else if (FileUtilNoMC.mainJson.hashes.containsKey(FileUtilNoMC.activeProfile + "/options.justenoughkeys.txt") && !hashJEK.equals(writtenHashJEK)) {
                ret = true;
            } else if (FileUtilNoMC.mainJson.hashes.containsKey(FileUtilNoMC.activeProfile + "/options.amecsapi.txt") && !hashAmecs.equals(writtenHashAmecs)) {
                ret = true;
            } else if (FileUtilNoMC.mainJson.hashes.containsKey(FileUtilNoMC.activeProfile + "/servers.dat") && !hashS.equals(writtenHashS)) {
                ret = true;
            }
            if (options != null) {
                options.close();
                File fileO = new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.activeProfile + "/options.txt_temp");
                Files.delete(fileO.toPath());
            }
            if (keys != null) {
                keys.close();
                File fileK = new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.activeProfile + "/keys.txt_temp");
                Files.delete(fileK.toPath());
            }
        }
        catch (Exception e) {
            DefaultSettings.log.log(Level.ERROR, "Error while saving configs: ", (Throwable)e);
        }
        return ret;
    }
}

