/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.joml.Vector3d;

public abstract class PacketCodec
extends PacketBase {
    public static final int READ_STRING_MAX_LENGTH = Short.MAX_VALUE;
    private static Map<Class<?>, ICodecAction> codecActions = Maps.newHashMap();
    protected SingleCache<Void, List<Field>> fieldCache = new SingleCache<Void, List<Field>>(new SingleCache.ICacheUpdater<Void, List<Field>>(){

        @Override
        public List<Field> getNewValue(Void key) {
            LinkedList fieldList = Lists.newLinkedList();
            for (Class<?> clazz = PacketCodec.this.getClass(); clazz != PacketCodec.class && clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                Arrays.sort(fields, new Comparator<Field>(){

                    @Override
                    public int compare(Field o1, Field o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(CodecField.class)) continue;
                    fieldList.add(field);
                }
            }
            return fieldList;
        }

        @Override
        public boolean isKeyEqual(Void cacheKey, Void newKey) {
            return true;
        }
    });

    public static void addCodedAction(Class<?> clazz, ICodecAction action) {
        codecActions.put(clazz, action);
    }

    @Nullable
    protected static ICodecAction getActionSuper(Class<?> clazz) {
        ICodecAction action;
        if (ClassUtils.isPrimitiveWrapper(clazz)) {
            clazz = ClassUtils.wrapperToPrimitive(clazz);
        }
        if ((action = codecActions.get(clazz)) == null) {
            for (Class<?> iface : clazz.getInterfaces()) {
                action = codecActions.get(iface);
                if (action == null) continue;
                return action;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return PacketCodec.getActionSuper(superClass);
            }
            return null;
        }
        return action;
    }

    public static ICodecAction getAction(Class<?> clazz) {
        ICodecAction action = PacketCodec.getActionSuper(clazz);
        if (action == null) {
            System.err.println("No ICodecAction was found for " + clazz + ". You should add one in PacketCodec.");
        }
        return action;
    }

    private void loopCodecFields(ICodecRunnable runnable) {
        for (Field field : this.fieldCache.get(null)) {
            Class<?> clazz = field.getType();
            ICodecAction action = PacketCodec.getAction(clazz);
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            runnable.run(field, action);
        }
    }

    @Override
    public void encode(FriendlyByteBuf output) {
        this.loopCodecFields((field, action) -> {
            Object object = null;
            try {
                object = field.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            action.encode(object, output);
        });
    }

    @Override
    public void decode(FriendlyByteBuf input) {
        this.loopCodecFields((field, action) -> {
            Object object = action.decode(input);
            try {
                field.set(this, object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        });
    }

    public static void write(FriendlyByteBuf packetBuffer, Object object) {
        ICodecAction action = Objects.requireNonNull(PacketCodec.getActionSuper(object.getClass()), "No codec action was registered for " + object.getClass().getName());
        action.encode(object, packetBuffer);
    }

    public static <T> T read(FriendlyByteBuf packetBuffer, Class<T> clazz) {
        ICodecAction action = Objects.requireNonNull(PacketCodec.getActionSuper(clazz));
        return (T)action.decode(packetBuffer);
    }

    static {
        codecActions.put(String.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.m_130070_((String)object);
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return input.m_130136_(Short.MAX_VALUE);
            }
        });
        codecActions.put(Double.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.writeDouble(((Double)object).doubleValue());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return input.readDouble();
            }
        });
        codecActions.put(Integer.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.writeInt(((Integer)object).intValue());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return input.readInt();
            }
        });
        codecActions.put(Long.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.writeLong(((Long)object).longValue());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return input.readLong();
            }
        });
        codecActions.put(Short.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.writeShort((int)((Short)object).shortValue());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return input.readShort();
            }
        });
        codecActions.put(Boolean.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.writeBoolean(((Boolean)object).booleanValue());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return input.readBoolean();
            }
        });
        codecActions.put(Float.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.writeFloat(((Float)object).floatValue());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return Float.valueOf(input.readFloat());
            }
        });
        codecActions.put(Vector3d.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                Vector3d v = (Vector3d)object;
                output.writeDouble(v.x);
                output.writeDouble(v.y);
                output.writeDouble(v.z);
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                double x = input.readDouble();
                double y = input.readDouble();
                double z = input.readDouble();
                return new Vector3d(x, y, z);
            }
        });
        codecActions.put(Vec3i.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                Vec3i v = (Vec3i)object;
                output.writeInt(v.m_123341_());
                output.writeInt(v.m_123342_());
                output.writeInt(v.m_123343_());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                int x = input.readInt();
                int y = input.readInt();
                int z = input.readInt();
                return new Vec3i(x, y, z);
            }
        });
        codecActions.put(Vec3.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                Vec3 v = (Vec3)object;
                output.writeDouble(v.f_82479_);
                output.writeDouble(v.f_82480_);
                output.writeDouble(v.f_82481_);
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                double x = input.readDouble();
                double y = input.readDouble();
                double z = input.readDouble();
                return new Vec3(x, y, z);
            }
        });
        codecActions.put(Map.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                Map map = (Map)object;
                output.writeInt(map.size());
                Set entries = map.entrySet();
                ICodecAction keyAction = null;
                ICodecAction valueAction = null;
                for (Map.Entry entry : entries) {
                    if (keyAction == null) {
                        keyAction = PacketCodec.getAction(entry.getKey().getClass());
                        output.m_130070_(entry.getKey().getClass().getName());
                    }
                    if (valueAction == null) {
                        valueAction = PacketCodec.getAction(entry.getValue().getClass());
                        output.m_130070_(entry.getValue().getClass().getName());
                    }
                    keyAction.encode(entry.getKey(), output);
                    valueAction.encode(entry.getValue(), output);
                }
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                HashMap map = Maps.newHashMap();
                int size = input.readInt();
                if (size == 0) {
                    return map;
                }
                try {
                    ICodecAction keyAction = PacketCodec.getAction(Class.forName(input.m_130136_(Short.MAX_VALUE)));
                    ICodecAction valueAction = PacketCodec.getAction(Class.forName(input.m_130136_(Short.MAX_VALUE)));
                    for (int i = 0; i < size; ++i) {
                        Object key = keyAction.decode(input);
                        Object value = valueAction.decode(input);
                        map.put(key, value);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                return map;
            }
        });
        codecActions.put(CompoundTag.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.m_130079_((CompoundTag)object);
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return input.m_130260_();
            }
        });
        codecActions.put(Tag.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("v", (Tag)object);
                output.m_130079_(tag);
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                CompoundTag tag = input.m_130260_();
                return tag.m_128423_("v");
            }
        });
        codecActions.put(ItemStack.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.m_130055_((ItemStack)object);
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return input.m_130267_();
            }
        });
        codecActions.put(FluidStack.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.m_130079_(((FluidStack)object).writeToNBT(new CompoundTag()));
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return FluidStack.loadFluidStackFromNBT((CompoundTag)input.m_130260_());
            }
        });
        codecActions.put(Direction.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.writeInt(((Direction)object).ordinal());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return Direction.values()[input.readInt()];
            }
        });
        codecActions.put(BlockPos.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.m_130064_((BlockPos)object);
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return input.m_130135_();
            }
        });
        codecActions.put(ResourceKey.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.m_130070_(((ResourceKey)object).m_211136_().toString());
                output.m_130070_(((ResourceKey)object).m_135782_().toString());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(input.m_130136_(Short.MAX_VALUE))), (ResourceLocation)new ResourceLocation(input.m_130136_(Short.MAX_VALUE)));
            }
        });
        codecActions.put(DimPos.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                PacketCodec.write(output, ((DimPos)object).getLevelKey());
                PacketCodec.write(output, ((DimPos)object).getBlockPos());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                ResourceKey dimensionType = PacketCodec.read(input, ResourceKey.class);
                BlockPos blockPos = PacketCodec.read(input, BlockPos.class);
                return DimPos.of((ResourceKey<Level>)dimensionType, blockPos);
            }
        });
        codecActions.put(List.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                List list = (List)object;
                output.writeInt(list.size());
                if (list.size() == 0) {
                    return;
                }
                ICodecAction valueAction = null;
                for (int i = 0; i < list.size(); ++i) {
                    Object value = list.get(i);
                    if (value == null) continue;
                    if (valueAction == null) {
                        valueAction = PacketCodec.getAction(value.getClass());
                        output.m_130070_(value.getClass().getName());
                    }
                    output.writeInt(i);
                    valueAction.encode(value, output);
                }
                if (valueAction == null) {
                    output.m_130070_("__noclass");
                } else {
                    output.writeInt(-1);
                }
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                int size = input.readInt();
                if (size == 0) {
                    return Collections.emptyList();
                }
                ArrayList list = Lists.newArrayListWithExpectedSize((int)size);
                try {
                    String className = input.m_130136_(Short.MAX_VALUE);
                    if (!className.equals("__noclass")) {
                        int i;
                        ICodecAction valueAction = PacketCodec.getAction(Class.forName(className));
                        int currentLength = 0;
                        while ((i = input.readInt()) >= 0) {
                            while (currentLength < i) {
                                list.add(null);
                                ++currentLength;
                            }
                            Object value = valueAction.decode(input);
                            list.add(value);
                            ++currentLength;
                        }
                        while (currentLength < size) {
                            list.add(null);
                            ++currentLength;
                        }
                    } else {
                        for (int i = 0; i < size; ++i) {
                            list.add(null);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                return list;
            }
        });
        codecActions.put(Pair.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                output.m_130070_(((Pair)object).getLeft().getClass().getName());
                output.m_130070_(((Pair)object).getRight().getClass().getName());
                PacketCodec.write(output, ((Pair)object).getLeft());
                PacketCodec.write(output, ((Pair)object).getRight());
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                try {
                    ICodecAction keyAction = PacketCodec.getAction(Class.forName(input.m_130136_(Short.MAX_VALUE)));
                    ICodecAction valueAction = PacketCodec.getAction(Class.forName(input.m_130136_(Short.MAX_VALUE)));
                    Object key = keyAction.decode(input);
                    Object value = valueAction.decode(input);
                    return Pair.of((Object)key, (Object)value);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return Pair.of(null, null);
                }
            }
        });
        codecActions.put(ItemLocation.class, new ICodecAction(){

            @Override
            public void encode(Object object, FriendlyByteBuf output) {
                ItemLocation.writeToPacketBuffer(output, (ItemLocation)object);
            }

            @Override
            public Object decode(FriendlyByteBuf input) {
                return ItemLocation.readFromPacketBuffer(input);
            }
        });
    }

    public static interface ICodecAction {
        public void encode(Object var1, FriendlyByteBuf var2);

        public Object decode(FriendlyByteBuf var1);
    }

    public static interface ICodecRunnable {
        public void run(Field var1, ICodecAction var2);
    }
}

