/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.potinteraction;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.api.data.sound.Sound;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.data.recipes.potinteraction.BasicPotInteraction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public final class BasicPotInteractionSerializer
implements RecipeSerializer<BasicPotInteraction> {
    public static final RecipeSerializer<?> SERIALIZER = new BasicPotInteractionSerializer();

    public BasicPotInteraction fromJson(ResourceLocation id, JsonObject json) {
        Ingredient heldTest = (Ingredient)Serializers.INGREDIENT.fromJSON(json, "held_ingredient");
        boolean damageHeld = (Boolean)Serializers.BOOLEAN.fromJSON(json, "damage_held", (Object)true);
        Ingredient soilTest = (Ingredient)Serializers.INGREDIENT.fromJSONNullable(json, "soil_ingredient");
        Ingredient seedTest = (Ingredient)Serializers.INGREDIENT.fromJSONNullable(json, "seed_ingredient");
        ItemStack soilOutput = (ItemStack)Serializers.ITEM_STACK.fromJSONNullable(json, "soil_output");
        ItemStack seedOutput = (ItemStack)Serializers.ITEM_STACK.fromJSONNullable(json, "seed_output");
        Sound sound = (Sound)Serializers.SOUND.fromJSONNullable(json, "sound");
        List extraDrops = Serializers.ITEM_STACK.fromJSONList(json, "drops", new ArrayList());
        if (soilTest == null && seedTest == null) {
            throw new JsonParseException("Recipe requires at least one soil or seed ingredient.");
        }
        if (soilOutput == null && seedOutput == null) {
            throw new JsonParseException("Recipe requires at least one output.");
        }
        return new BasicPotInteraction(id, heldTest, damageHeld, soilTest, seedTest, soilOutput, seedOutput, sound, extraDrops);
    }

    public BasicPotInteraction fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        Ingredient heldTest = (Ingredient)Serializers.INGREDIENT.fromByteBuf(buffer);
        boolean damageHeld = (Boolean)Serializers.BOOLEAN.fromByteBuf(buffer);
        Ingredient soilTest = (Ingredient)Serializers.INGREDIENT.fromByteBufNullable(buffer);
        Ingredient seedTest = (Ingredient)Serializers.INGREDIENT.fromByteBufNullable(buffer);
        ItemStack soilOutput = (ItemStack)Serializers.ITEM_STACK.fromByteBufNullable(buffer);
        ItemStack seedOutput = (ItemStack)Serializers.ITEM_STACK.fromByteBufNullable(buffer);
        Sound sound = (Sound)Serializers.SOUND.fromByteBufNullable(buffer);
        List extraDrops = Serializers.ITEM_STACK.fromByteBufList(buffer);
        return new BasicPotInteraction(id, heldTest, damageHeld, soilTest, seedTest, soilOutput, seedOutput, sound, extraDrops);
    }

    public void toNetwork(FriendlyByteBuf buffer, BasicPotInteraction toWrite) {
        Serializers.INGREDIENT.toByteBuf(buffer, (Object)toWrite.heldTest);
        Serializers.BOOLEAN.toByteBuf(buffer, (Object)toWrite.damageHeld);
        Serializers.INGREDIENT.toByteBufNullable(buffer, (Object)toWrite.soilTest);
        Serializers.INGREDIENT.toByteBufNullable(buffer, (Object)toWrite.seedTest);
        Serializers.ITEM_STACK.toByteBufNullable(buffer, (Object)toWrite.newSoilStack);
        Serializers.ITEM_STACK.toByteBufNullable(buffer, (Object)toWrite.newSeedStack);
        Serializers.SOUND.toByteBufNullable(buffer, (Object)toWrite.sound);
        Serializers.ITEM_STACK.toByteBufList(buffer, toWrite.extraDrops);
    }
}

