/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.xplat.XplatAbstractions;

public final class ItemNBTHelper {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public static void set(ItemStack stack, String tag, Tag nbt) {
        stack.m_41784_().m_128365_(tag, nbt);
    }

    public static void setBoolean(ItemStack stack, String tag, boolean b) {
        stack.m_41784_().m_128379_(tag, b);
    }

    public static void setByte(ItemStack stack, String tag, byte b) {
        stack.m_41784_().m_128344_(tag, b);
    }

    public static void setShort(ItemStack stack, String tag, short s) {
        stack.m_41784_().m_128376_(tag, s);
    }

    public static void setInt(ItemStack stack, String tag, int i) {
        stack.m_41784_().m_128405_(tag, i);
    }

    public static void setIntArray(ItemStack stack, String tag, int[] val) {
        stack.m_41784_().m_128385_(tag, val);
    }

    public static void setLong(ItemStack stack, String tag, long l) {
        stack.m_41784_().m_128356_(tag, l);
    }

    public static void setFloat(ItemStack stack, String tag, float f) {
        stack.m_41784_().m_128350_(tag, f);
    }

    public static void setDouble(ItemStack stack, String tag, double d) {
        stack.m_41784_().m_128347_(tag, d);
    }

    public static void setCompound(ItemStack stack, String tag, CompoundTag cmp) {
        if (!tag.equalsIgnoreCase("ench")) {
            stack.m_41784_().m_128365_(tag, (Tag)cmp);
        }
    }

    public static void setString(ItemStack stack, String tag, String s) {
        stack.m_41784_().m_128359_(tag, s);
    }

    public static void setList(ItemStack stack, String tag, ListTag list) {
        stack.m_41784_().m_128365_(tag, (Tag)list);
    }

    public static void removeEntry(ItemStack stack, String tag) {
        stack.m_41749_(tag);
    }

    public static boolean verifyExistance(ItemStack stack, String tag) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41784_().m_128441_(tag);
    }

    @Nullable
    public static Tag get(ItemStack stack, String tag) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128423_(tag) : null;
    }

    public static boolean getBoolean(ItemStack stack, String tag, boolean defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128471_(tag) : defaultExpected;
    }

    public static byte getByte(ItemStack stack, String tag, byte defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128445_(tag) : defaultExpected;
    }

    public static short getShort(ItemStack stack, String tag, short defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128448_(tag) : defaultExpected;
    }

    public static int getInt(ItemStack stack, String tag, int defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128451_(tag) : defaultExpected;
    }

    public static int[] getIntArray(ItemStack stack, String tag) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128465_(tag) : EMPTY_INT_ARRAY;
    }

    public static long getLong(ItemStack stack, String tag, long defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128454_(tag) : defaultExpected;
    }

    public static float getFloat(ItemStack stack, String tag, float defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128457_(tag) : defaultExpected;
    }

    public static double getDouble(ItemStack stack, String tag, double defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128459_(tag) : defaultExpected;
    }

    @Nullable
    @Contract(value="_, _, false -> !null")
    public static CompoundTag getCompound(ItemStack stack, String tag, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128469_(tag) : (nullifyOnFail ? null : new CompoundTag());
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    public static String getString(ItemStack stack, String tag, String defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128461_(tag) : defaultExpected;
    }

    @Nullable
    @Contract(value="_, _, _, false -> !null")
    public static ListTag getList(ItemStack stack, String tag, int objtype, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128437_(tag, objtype) : (nullifyOnFail ? null : new ListTag());
    }

    public static int getFullness(ManaItem item) {
        int mana = item.getMana();
        if (mana == 0) {
            return 0;
        }
        if (mana == item.getMaxMana()) {
            return 2;
        }
        return 1;
    }

    public static ItemStack duplicateAndClearMana(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(copy);
        if (manaItem != null) {
            manaItem.addMana(-manaItem.getMana());
        }
        return copy;
    }

    public static boolean matchTagAndManaFullness(ItemStack stack1, ItemStack stack2) {
        if (!ItemStack.m_41656_((ItemStack)stack1, (ItemStack)stack2)) {
            return false;
        }
        ManaItem manaItem1 = XplatAbstractions.INSTANCE.findManaItem(stack1);
        ManaItem manaItem2 = XplatAbstractions.INSTANCE.findManaItem(stack2);
        if (manaItem1 != null && manaItem2 != null) {
            if (ItemNBTHelper.getFullness(manaItem1) != ItemNBTHelper.getFullness(manaItem2)) {
                return false;
            }
            return ItemStack.m_41728_((ItemStack)ItemNBTHelper.duplicateAndClearMana(stack1), (ItemStack)ItemNBTHelper.duplicateAndClearMana(stack2));
        }
        return ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static JsonObject serializeStack(ItemStack stack) {
        CompoundTag nbt = stack.m_41739_(new CompoundTag());
        byte c = nbt.m_128445_("Count");
        if (c != 1) {
            nbt.m_128344_("count", c);
        }
        nbt.m_128473_("Count");
        ItemNBTHelper.renameTag(nbt, "id", "item");
        ItemNBTHelper.renameTag(nbt, "tag", "nbt");
        Dynamic dyn = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    public static void renameTag(CompoundTag nbt, String oldName, String newName) {
        Tag tag = nbt.m_128423_(oldName);
        if (tag != null) {
            nbt.m_128473_(oldName);
            nbt.m_128365_(newName, tag);
        }
    }
}

