/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.mixin.HopperBlockEntityAccessor;

public class InventoryHelper {
    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ItemStack simulateTransfer(Container to, ItemStack stack, @Nullable Direction side) {
        stack = stack.m_41777_();
        if (to instanceof WorldlyContainer) {
            WorldlyContainer sidedInventory = (WorldlyContainer)to;
            if (side != null) {
                int[] is = sidedInventory.m_7071_(side);
                int i = 0;
                while (i < is.length) {
                    if (stack.m_41619_()) return stack;
                    stack = InventoryHelper.simulateTransfer(to, stack, is[i], side);
                    ++i;
                }
                return stack;
            }
        }
        int j = to.m_6643_();
        int k = 0;
        while (k < j) {
            if (stack.m_41619_()) return stack;
            stack = InventoryHelper.simulateTransfer(to, stack, k, side);
            ++k;
        }
        return stack;
    }

    private static ItemStack simulateTransfer(Container to, ItemStack stack, int slot, @Nullable Direction direction) {
        ItemStack itemStack = to.m_8020_(slot);
        if (HopperBlockEntityAccessor.botania_canInsert(to, stack, slot, direction)) {
            boolean bl = false;
            boolean bl2 = to.m_7983_();
            if (itemStack.m_41619_()) {
                stack = ItemStack.f_41583_;
                bl = true;
            } else if (HopperBlockEntityAccessor.botania_canMerge(itemStack, stack)) {
                int i = stack.m_41741_() - itemStack.m_41613_();
                int j = Math.min(stack.m_41613_(), i);
                stack.m_41774_(j);
                bl = j > 0;
            }
        }
        return stack;
    }

    public static void withdrawFromInventory(SimpleInventoryBlockEntity inv, Player player) {
        for (int i = inv.inventorySize() - 1; i >= 0; --i) {
            ItemStack stackAt = inv.getItemHandler().m_8020_(i);
            if (stackAt.m_41619_()) continue;
            ItemStack copy = stackAt.m_41777_();
            player.m_150109_().m_150079_(copy);
            inv.getItemHandler().m_6836_(i, ItemStack.f_41583_);
            break;
        }
    }

    public static boolean overrideStackedOnOther(Function<ItemStack, Container> inventoryGetter, boolean selfGuiOpen, @NotNull ItemStack container, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        if (!selfGuiOpen && clickAction == ClickAction.SECONDARY) {
            ItemStack toInsert = slot.m_7993_();
            Container inventory = inventoryGetter.apply(container);
            if (InventoryHelper.simulateTransfer(inventory, toInsert, null).m_41619_()) {
                ItemStack taken = slot.m_150647_(toInsert.m_41613_(), Integer.MAX_VALUE, player);
                HopperBlockEntity.m_59326_(null, (Container)inventory, (ItemStack)taken, null);
                return true;
            }
        }
        return false;
    }

    public static boolean overrideOtherStackedOnMe(Function<ItemStack, Container> inventoryGetter, boolean selfGuiOpen, @NotNull ItemStack container, @NotNull ItemStack toInsert, @NotNull ClickAction clickAction, @NotNull SlotAccess cursorAccess) {
        Container inventory;
        if (!selfGuiOpen && clickAction == ClickAction.SECONDARY && InventoryHelper.simulateTransfer(inventory = inventoryGetter.apply(container), toInsert, null).m_41619_()) {
            HopperBlockEntity.m_59326_(null, (Container)inventory, (ItemStack)toInsert, null);
            cursorAccess.m_142104_(ItemStack.f_41583_);
            return true;
        }
        return false;
    }

    public static void checkEmpty(ItemStack remainder) {
        if (!remainder.m_41619_()) {
            BotaniaAPI.LOGGER.warn("Remainder was not empty after insert, item may have been lost: {}", (Object)remainder);
        }
    }

    public static boolean tryToSetLastRecipe(Player player, Container inv, @Nullable List<ItemStack> lastRecipe, @Nullable SoundEvent sound) {
        if (lastRecipe == null || lastRecipe.isEmpty()) {
            return false;
        }
        int index = 0;
        boolean didAny = false;
        block0: for (ItemStack stack : lastRecipe) {
            if (stack.m_41619_()) continue;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack pstack = player.m_150109_().m_8020_(i);
                if (!player.m_7500_() && (pstack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)pstack))) continue;
                inv.m_6836_(index, player.m_7500_() ? stack.m_41777_() : pstack.m_41620_(1));
                didAny = true;
                ++index;
                continue block0;
            }
        }
        if (didAny) {
            if (sound != null) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.BLOCKS, 0.1f, 10.0f);
            }
            ServerPlayer mp = (ServerPlayer)player;
            mp.f_36095_.m_38946_();
        }
        return didAny;
    }
}

