/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;

public class CorporeaCrystalCubeBlockEntity
extends BaseCorporeaBlockEntity
implements CorporeaRequestor,
Wandable {
    private static final String TAG_REQUEST_TARGET = "requestTarget";
    private static final String TAG_ITEM_COUNT = "itemCount";
    private static final String TAG_LOCK = "lock";
    private ItemStack requestTarget = ItemStack.f_41583_;
    private int itemCount = 0;
    private int ticks = 0;
    private int compValue = 0;
    public boolean locked = false;

    public CorporeaCrystalCubeBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CORPOREA_CRYSTAL_CUBE, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CorporeaCrystalCubeBlockEntity self) {
        ++self.ticks;
        if (self.ticks % 20 == 0) {
            self.updateCount();
        }
    }

    public void setRequestTarget(ItemStack stack) {
        if (!stack.m_41619_() && !this.locked) {
            this.requestTarget = stack.m_255036_(1);
            this.updateCount();
            if (!this.f_58857_.f_46443_) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
    }

    public ItemStack getRequestTarget() {
        return this.requestTarget;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void doRequest(Player player) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        CorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !this.requestTarget.m_41619_()) {
            int count = player.m_6144_() ? this.requestTarget.m_41741_() : 1;
            CorporeaRequestMatcher matcher = CorporeaHelper.instance().createMatcher(this.requestTarget, true);
            this.doCorporeaRequest(matcher, count, spark, (LivingEntity)player);
        }
    }

    private void updateCount() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        int sum = 0;
        CorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !this.requestTarget.m_41619_()) {
            CorporeaRequestMatcher matcher = CorporeaHelper.instance().createMatcher(this.requestTarget, true);
            List<ItemStack> stacks = CorporeaHelper.instance().requestItem(matcher, -1, spark, null, false).stacks();
            for (ItemStack stack : stacks) {
                sum += stack.m_41613_();
            }
        }
        this.setCount(sum);
    }

    private void setCount(int count) {
        int oldCount = this.itemCount;
        this.itemCount = count;
        if (this.itemCount != oldCount) {
            int oldCompValue = this.compValue;
            this.compValue = CorporeaHelper.instance().signalStrengthForRequestSize(this.itemCount);
            if (this.compValue != oldCompValue && this.f_58857_ != null) {
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            }
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        CompoundTag cmp = new CompoundTag();
        if (!this.requestTarget.m_41619_()) {
            cmp = this.requestTarget.m_41739_(cmp);
        }
        tag.m_128365_(TAG_REQUEST_TARGET, (Tag)cmp);
        tag.m_128405_(TAG_ITEM_COUNT, this.itemCount);
        tag.m_128379_(TAG_LOCK, this.locked);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        CompoundTag cmp = tag.m_128469_(TAG_REQUEST_TARGET);
        this.requestTarget = ItemStack.m_41712_((CompoundTag)cmp);
        this.setCount(tag.m_128451_(TAG_ITEM_COUNT));
        this.locked = tag.m_128471_(TAG_LOCK);
    }

    public int getComparatorValue() {
        return this.compValue;
    }

    @Override
    public void doCorporeaRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, @Nullable LivingEntity entity) {
        if (!this.requestTarget.m_41619_()) {
            List<ItemStack> stacks = CorporeaHelper.instance().requestItem(request, count, spark, entity, true).stacks();
            spark.onItemsRequested(stacks);
            boolean did = false;
            int sum = 0;
            for (ItemStack reqStack : stacks) {
                ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, reqStack);
                this.f_58857_.m_7967_((Entity)item);
                if (!ItemStack.m_41656_((ItemStack)this.requestTarget, (ItemStack)reqStack)) continue;
                sum += reqStack.m_41613_();
                did = true;
            }
            if (did) {
                this.setCount(this.getItemCount() - sum);
            }
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player == null || player.m_6144_()) {
            boolean bl = this.locked = !this.locked;
            if (!this.f_58857_.f_46443_) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
            return true;
        }
        return false;
    }

    public static class Hud {
        public static void render(GuiGraphics gui, CorporeaCrystalCubeBlockEntity cube) {
            PoseStack ps = gui.m_280168_();
            Minecraft mc = Minecraft.m_91087_();
            ProfilerFiller profiler = mc.m_91307_();
            profiler.m_6180_("crystalCube");
            ItemStack target = cube.getRequestTarget();
            if (!target.m_41619_()) {
                String nameStr = target.m_41786_().getString();
                String countStr = cube.getItemCount() + "x";
                String lockedStr = I18n.m_118938_((String)"botaniamisc.locked", (Object[])new Object[0]);
                int strlen = Math.max(mc.f_91062_.m_92895_(nameStr), mc.f_91062_.m_92895_(countStr));
                if (cube.locked) {
                    strlen = Math.max(strlen, mc.f_91062_.m_92895_(lockedStr));
                }
                int centerX = mc.m_91268_().m_85445_() / 2;
                int centerY = mc.m_91268_().m_85446_() / 2;
                ps.m_85836_();
                ps.m_252880_((float)centerX, (float)centerY, 0.0f);
                RenderHelper.renderHUDBox(gui, 8, -11, strlen + 32, cube.locked ? 21 : 11);
                gui.m_280488_(mc.f_91062_, nameStr, 30, -9, 0x6666FF);
                gui.m_280488_(mc.f_91062_, countStr, 30, 1, 0xFFFFFF);
                if (cube.locked) {
                    gui.m_280488_(mc.f_91062_, lockedStr, 30, 11, 0xFFAA00);
                }
                gui.m_280480_(target, 10, 9);
                ps.m_85849_();
            }
            profiler.m_7238_();
        }
    }
}

