/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.gui.crafting.AssemblyHaloContainer;
import vazkii.botania.client.integration.jei.BreweryRecipeCategory;
import vazkii.botania.client.integration.jei.ElvenTradeRecipeCategory;
import vazkii.botania.client.integration.jei.ManaPoolRecipeCategory;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.PureDaisyRecipeCategory;
import vazkii.botania.client.integration.jei.RunicAltarRecipeCategory;
import vazkii.botania.client.integration.jei.TerrestrialAgglomerationRecipeCategory;
import vazkii.botania.client.integration.jei.crafting.AncientWillRecipeWrapper;
import vazkii.botania.client.integration.jei.crafting.CompositeLensRecipeWrapper;
import vazkii.botania.client.integration.jei.crafting.TerraShattererTippingRecipeWrapper;
import vazkii.botania.client.integration.jei.orechid.MarimorphosisRecipeCategory;
import vazkii.botania.client.integration.jei.orechid.OrechidIgnemRecipeCategory;
import vazkii.botania.client.integration.jei.orechid.OrechidRecipeCategory;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.LexiconElvenTradeRecipe;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.crafting.recipe.TerraShattererTippingRecipe;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.LaputaShardItem;
import vazkii.botania.common.item.ManaTabletItem;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.XplatAbstractions;

@JeiPlugin
public class JEIBotaniaPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocationHelper.prefix("main");
    private static final Comparator<Recipe<?>> BY_ID = Comparator.comparing(Recipe::m_6423_);
    private static final Comparator<Recipe<?>> BY_GROUP = Comparator.comparing(Recipe::m_6076_);
    private static final Comparator<OrechidRecipe> BY_WEIGHT = Comparator.comparing(OrechidRecipe::getWeight).reversed();
    private static final Comparator<ManaInfusionRecipe> BY_CATALYST = (l, r) -> {
        StateIngredient left = l.getRecipeCatalyst();
        StateIngredient right = r.getRecipeCatalyst();
        if (left == null) {
            return right == null ? 0 : -1;
        }
        if (right == null) {
            return 1;
        }
        return left.toString().compareTo(right.toString());
    };
    private static final HoveredStackGetter HOVERED_STACK_GETTER = new HoveredStackGetter();

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registry) {
        IIngredientSubtypeInterpreter interpreter = (stack, ctx) -> BaseBrewItem.getSubtype(stack);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.brewVial, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.brewFlask, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.incenseStick, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.bloodPendant, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.flightTiara, (stack, ctx) -> String.valueOf(FlugelTiaraItem.getVariant(stack)));
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.lexicon, (stack, ctx) -> String.valueOf(ItemNBTHelper.getBoolean(stack, "botania:elven_unlock", false)));
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.laputaShard, (stack, ctx) -> String.valueOf(LaputaShardItem.getShardLevel(stack)));
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.terraPick, (stack, ctx) -> {
            if (ctx == UidContext.Recipe) {
                return String.valueOf(TerraShattererItem.isTipped(stack));
            }
            return String.valueOf(TerraShattererItem.getLevel(stack)) + TerraShattererItem.isTipped(stack);
        });
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.manaTablet, (stack, ctx) -> {
            int mana = XplatAbstractions.INSTANCE.findManaItem((ItemStack)stack).getMana();
            return String.valueOf(mana) + ManaTabletItem.isStackCreative(stack);
        });
        for (Item item : new Item[]{BotaniaItems.manaRing, BotaniaItems.manaRingGreater}) {
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)item, (stack, ctx) -> {
                int mana = XplatAbstractions.INSTANCE.findManaItem((ItemStack)stack).getMana();
                return String.valueOf(mana);
            });
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PureDaisyRecipeCategory(registry.getJeiHelpers().getGuiHelper(), registry.getJeiHelpers().getPlatformFluidHelper()), new ManaPoolRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new PetalApothecaryRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new RunicAltarRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ElvenTradeRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new BreweryRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new OrechidRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new OrechidIgnemRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new MarimorphosisRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new TerrestrialAgglomerationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(AncientWillRecipe.class, AncientWillRecipeWrapper::new);
        registration.getCraftingCategory().addCategoryExtension(TerraShattererTippingRecipe.class, TerraShattererTippingRecipeWrapper::new);
        registration.getCraftingCategory().addCategoryExtension(CompositeLensRecipe.class, CompositeLensRecipeWrapper::new);
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        registry.addRecipes(BreweryRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.BREW_TYPE, BY_ID));
        registry.addRecipes(PureDaisyRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.PURE_DAISY_TYPE, BY_ID));
        registry.addRecipes(PetalApothecaryRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.PETAL_TYPE, BY_ID));
        registry.addRecipes(ElvenTradeRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.ELVEN_TRADE_TYPE, BY_ID));
        registry.addRecipes(RunicAltarRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.RUNE_TYPE, BY_ID));
        registry.addRecipes(ManaPoolRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.MANA_INFUSION_TYPE, BY_CATALYST.thenComparing(BY_GROUP).thenComparing(BY_ID)));
        registry.addRecipes(TerrestrialAgglomerationRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.TERRA_PLATE_TYPE, BY_ID));
        Comparator<Recipe<?>> comp = BY_WEIGHT.thenComparing(BY_ID);
        registry.addRecipes(OrechidRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.ORECHID_TYPE, comp));
        registry.addRecipes(OrechidIgnemRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.ORECHID_IGNEM_TYPE, comp));
        registry.addRecipes(MarimorphosisRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.MARIMORPHOSIS_TYPE, comp));
    }

    private static <T extends Recipe<C>, C extends Container> List<T> sortRecipes(net.minecraft.world.item.crafting.RecipeType<T> type, Comparator<? super T> comparator) {
        Collection recipes = BotaniaRecipeTypes.getRecipes((Level)Minecraft.m_91087_().f_91073_, type).values();
        ArrayList list = new ArrayList(recipes);
        list.sort(comparator);
        return list;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(AssemblyHaloContainer.class, null, RecipeTypes.CRAFTING, 1, 9, 10, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.brewery), new RecipeType[]{BreweryRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.alfPortal), new RecipeType[]{ElvenTradeRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.manaPool), new RecipeType[]{ManaPoolRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.dilutedPool), new RecipeType[]{ManaPoolRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.fabulousPool), new RecipeType[]{ManaPoolRecipeCategory.TYPE});
        for (Block apothecary : BotaniaBlocks.ALL_APOTHECARIES) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)apothecary), new RecipeType[]{PetalApothecaryRecipeCategory.TYPE});
        }
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.orechid), new RecipeType[]{OrechidRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.orechidFloating), new RecipeType[]{OrechidRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.orechidIgnem), new RecipeType[]{OrechidIgnemRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.orechidIgnemFloating), new RecipeType[]{OrechidIgnemRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.marimorphosis), new RecipeType[]{MarimorphosisRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.marimorphosisChibi), new RecipeType[]{MarimorphosisRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.marimorphosisFloating), new RecipeType[]{MarimorphosisRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.marimorphosisChibiFloating), new RecipeType[]{MarimorphosisRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.pureDaisy), new RecipeType[]{PureDaisyRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.pureDaisyFloating), new RecipeType[]{PureDaisyRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.runeAltar), new RecipeType[]{RunicAltarRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.terraPlate), new RecipeType[]{TerrestrialAgglomerationRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaItems.autocraftingHalo), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaItems.craftingHalo), new RecipeType[]{RecipeTypes.CRAFTING});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager recipeRegistry = jeiRuntime.getRecipeManager();
        for (ElvenTradeRecipe recipe : AlfheimPortalBlockEntity.elvenTradeRecipes((Level)Minecraft.m_91087_().f_91073_)) {
            if (recipe instanceof LexiconElvenTradeRecipe) continue;
            NonNullList<Ingredient> inputs = recipe.m_7527_();
            List<ItemStack> outputs = recipe.getOutputs();
            if (inputs.size() != 1 || outputs.size() != 1 || !recipe.containsItem(outputs.get(0))) continue;
            recipeRegistry.hideRecipes(ElvenTradeRecipeCategory.TYPE, List.of(recipe));
        }
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        recipeManager.m_44043_(ResourceLocationHelper.prefix("petal_apothecary/daybloom_motif")).ifPresent(r -> {
            if (r instanceof PetalApothecaryRecipe) {
                PetalApothecaryRecipe pr = (PetalApothecaryRecipe)r;
                recipeRegistry.hideRecipes(PetalApothecaryRecipeCategory.TYPE, List.of(pr));
            }
        });
        recipeManager.m_44043_(ResourceLocationHelper.prefix("petal_apothecary/nightshade_motif")).ifPresent(r -> {
            if (r instanceof PetalApothecaryRecipe) {
                PetalApothecaryRecipe pr = (PetalApothecaryRecipe)r;
                recipeRegistry.hideRecipes(PetalApothecaryRecipeCategory.TYPE, List.of(pr));
            }
        });
        JEIBotaniaPlugin.HOVERED_STACK_GETTER.jeiRuntimeRef = new WeakReference<IJeiRuntime>(jeiRuntime);
        if (!CorporeaInputHandler.hoveredStackGetters.contains(HOVERED_STACK_GETTER)) {
            CorporeaInputHandler.hoveredStackGetters.add(HOVERED_STACK_GETTER);
        }
        CorporeaInputHandler.supportedGuiFilter = CorporeaInputHandler.supportedGuiFilter.or(gui -> gui instanceof IRecipesGui);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    private static class HoveredStackGetter
    implements Supplier<ItemStack> {
        WeakReference<IJeiRuntime> jeiRuntimeRef;

        private HoveredStackGetter() {
        }

        @Override
        public ItemStack get() {
            IJeiRuntime jeiRuntime = (IJeiRuntime)this.jeiRuntimeRef.get();
            if (jeiRuntime == null) {
                return ItemStack.f_41583_;
            }
            return (ItemStack)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> (ItemStack)jeiRuntime.getIngredientListOverlay().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK), () -> jeiRuntime.getRecipesGui().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK).orElse(null), () -> (ItemStack)jeiRuntime.getBookmarkOverlay().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK), () -> ItemStack.f_41583_});
        }
    }
}

