/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.client.model.TinyPotatoModel;
import vazkii.botania.client.render.block_entity.CorporeaCrystalCubeBlockEntityRenderer;
import vazkii.botania.client.render.block_entity.ManaPumpBlockEntityRenderer;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class MiscellaneousModels {
    public static final MiscellaneousModels INSTANCE = new MiscellaneousModels();
    public boolean registeredModels = false;
    public final BakedModel[] tiaraWingIcons = new BakedModel[9];
    public final BakedModel[] thirdEyeLayers = new BakedModel[3];
    public BakedModel goldfishModel;
    public BakedModel phiFlowerModel;
    public BakedModel nerfBatModel;
    public BakedModel bloodPendantChain;
    public BakedModel bloodPendantGem;
    public BakedModel snowflakePendantGem;
    public BakedModel itemFinderGem;
    public BakedModel pyroclastGem;
    public BakedModel crimsonGem;
    public BakedModel cirrusGem;
    public BakedModel nimbusGem;
    public BakedModel terrasteelHelmWillModel;
    public BakedModel elvenSpreaderCore;
    public BakedModel gaiaSpreaderCore;
    public BakedModel manaSpreaderCore;
    public BakedModel redstoneSpreaderCore;
    public BakedModel manaSpreaderScaffolding;
    public BakedModel elvenSpreaderScaffolding;
    public BakedModel gaiaSpreaderScaffolding;
    public final HashMap<DyeColor, BakedModel> spreaderPaddings = new HashMap();
    public final BakedModel[] kingKeyWeaponModels = new BakedModel[12];

    public void onModelRegister(ResourceManager rm, Consumer<ResourceLocation> consumer) {
        int i;
        consumer.accept(ResourceLocationHelper.prefix("icon/goldfish"));
        consumer.accept(ResourceLocationHelper.prefix("icon/phiflower"));
        consumer.accept(ResourceLocationHelper.prefix("icon/nerfbat"));
        consumer.accept(ResourceLocationHelper.prefix("icon/blood_pendant_chain"));
        consumer.accept(ResourceLocationHelper.prefix("icon/blood_pendant_gem"));
        for (i = 0; i < 12; ++i) {
            consumer.accept(ResourceLocationHelper.prefix("icon/gate_weapon_" + i));
        }
        consumer.accept(ResourceLocationHelper.prefix("icon/will_flame"));
        for (i = 0; i < this.thirdEyeLayers.length; ++i) {
            consumer.accept(ResourceLocationHelper.prefix("icon/third_eye_" + i));
        }
        consumer.accept(ResourceLocationHelper.prefix("icon/lava_pendant_gem"));
        consumer.accept(ResourceLocationHelper.prefix("icon/super_lava_pendant_gem"));
        consumer.accept(ResourceLocationHelper.prefix("icon/itemfinder_gem"));
        consumer.accept(ResourceLocationHelper.prefix("icon/cloud_pendant_gem"));
        consumer.accept(ResourceLocationHelper.prefix("icon/super_cloud_pendant_gem"));
        consumer.accept(ResourceLocationHelper.prefix("icon/ice_pendant_gem"));
        for (i = 0; i < this.tiaraWingIcons.length; ++i) {
            consumer.accept(ResourceLocationHelper.prefix("icon/tiara_wing_" + (i + 1)));
        }
        consumer.accept(ResourceLocationHelper.prefix("block/corporea_crystal_cube_glass"));
        consumer.accept(ResourceLocationHelper.prefix("block/pump_head"));
        consumer.accept(ResourceLocationHelper.prefix("block/elven_spreader_core"));
        consumer.accept(ResourceLocationHelper.prefix("block/gaia_spreader_core"));
        consumer.accept(ResourceLocationHelper.prefix("block/mana_spreader_core"));
        consumer.accept(ResourceLocationHelper.prefix("block/redstone_spreader_core"));
        consumer.accept(ResourceLocationHelper.prefix("block/mana_spreader_scaffolding"));
        consumer.accept(ResourceLocationHelper.prefix("block/elven_spreader_scaffolding"));
        consumer.accept(ResourceLocationHelper.prefix("block/gaia_spreader_scaffolding"));
        for (DyeColor color : DyeColor.values()) {
            consumer.accept(ResourceLocationHelper.prefix("block/" + color.toString() + "_spreader_padding"));
        }
        MiscellaneousModels.registerIslands();
        MiscellaneousModels.registerTaters(rm, consumer);
        if (!this.registeredModels) {
            this.registeredModels = true;
        }
    }

    private static void registerIslands() {
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.GRASS, ResourceLocationHelper.prefix("block/islands/island_grass"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.PODZOL, ResourceLocationHelper.prefix("block/islands/island_podzol"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.MYCEL, ResourceLocationHelper.prefix("block/islands/island_mycel"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.SNOW, ResourceLocationHelper.prefix("block/islands/island_snow"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.DRY, ResourceLocationHelper.prefix("block/islands/island_dry"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.GOLDEN, ResourceLocationHelper.prefix("block/islands/island_golden"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.VIVID, ResourceLocationHelper.prefix("block/islands/island_vivid"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.SCORCHED, ResourceLocationHelper.prefix("block/islands/island_scorched"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.INFUSED, ResourceLocationHelper.prefix("block/islands/island_infused"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.MUTATED, ResourceLocationHelper.prefix("block/islands/island_mutated"));
    }

    private static void registerTaters(ResourceManager rm, Consumer<ResourceLocation> consumer) {
        for (ResourceLocation model : rm.m_214159_("models/tiny_potato", s -> s.m_135815_().endsWith(".json")).keySet()) {
            if (!"botania".equals(model.m_135827_())) continue;
            String path = model.m_135815_();
            path = path.substring("models/".length(), path.length() - ".json".length());
            consumer.accept(new ResourceLocation("botania", path));
        }
    }

    public void onModelBake(ModelBakery loader, Map<ResourceLocation, BakedModel> map) {
        int i;
        if (!this.registeredModels) {
            BotaniaAPI.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
            return;
        }
        ModelResourceLocation abstruseName = new ModelResourceLocation(ResourceLocationHelper.prefix("abstruse_platform"), "");
        BakedModel abstruse = map.get(abstruseName);
        ModelResourceLocation spectralName = new ModelResourceLocation(ResourceLocationHelper.prefix("spectral_platform"), "");
        BakedModel spectral = map.get(spectralName);
        ModelResourceLocation infrangibleName = new ModelResourceLocation(ResourceLocationHelper.prefix("infrangible_platform"), "");
        BakedModel infrangible = map.get(infrangibleName);
        map.put((ResourceLocation)abstruseName, ClientXplatAbstractions.INSTANCE.wrapPlatformModel(abstruse));
        map.put((ResourceLocation)spectralName, ClientXplatAbstractions.INSTANCE.wrapPlatformModel(spectral));
        map.put((ResourceLocation)infrangibleName, ClientXplatAbstractions.INSTANCE.wrapPlatformModel(infrangible));
        ModelResourceLocation tinyPotato = new ModelResourceLocation(ResourceLocationHelper.prefix("tiny_potato"), "inventory");
        BakedModel originalPotato = map.get(tinyPotato);
        map.put((ResourceLocation)tinyPotato, new TinyPotatoModel(originalPotato));
        CorporeaCrystalCubeBlockEntityRenderer.cubeModel = map.get(ResourceLocationHelper.prefix("block/corporea_crystal_cube_glass"));
        ManaPumpBlockEntityRenderer.headModel = map.get(ResourceLocationHelper.prefix("block/pump_head"));
        this.elvenSpreaderCore = map.get(ResourceLocationHelper.prefix("block/elven_spreader_core"));
        this.gaiaSpreaderCore = map.get(ResourceLocationHelper.prefix("block/gaia_spreader_core"));
        this.manaSpreaderCore = map.get(ResourceLocationHelper.prefix("block/mana_spreader_core"));
        this.redstoneSpreaderCore = map.get(ResourceLocationHelper.prefix("block/redstone_spreader_core"));
        this.manaSpreaderScaffolding = map.get(ResourceLocationHelper.prefix("block/mana_spreader_scaffolding"));
        this.elvenSpreaderScaffolding = map.get(ResourceLocationHelper.prefix("block/elven_spreader_scaffolding"));
        this.gaiaSpreaderScaffolding = map.get(ResourceLocationHelper.prefix("block/gaia_spreader_scaffolding"));
        for (DyeColor color : DyeColor.values()) {
            this.spreaderPaddings.put(color, map.get(ResourceLocationHelper.prefix("block/" + color.m_41065_() + "_spreader_padding")));
        }
        this.goldfishModel = map.get(ResourceLocationHelper.prefix("icon/goldfish"));
        this.phiFlowerModel = map.get(ResourceLocationHelper.prefix("icon/phiflower"));
        this.nerfBatModel = map.get(ResourceLocationHelper.prefix("icon/nerfbat"));
        this.bloodPendantChain = map.get(ResourceLocationHelper.prefix("icon/blood_pendant_chain"));
        this.bloodPendantGem = map.get(ResourceLocationHelper.prefix("icon/blood_pendant_gem"));
        for (i = 0; i < 12; ++i) {
            this.kingKeyWeaponModels[i] = map.get(ResourceLocationHelper.prefix("icon/gate_weapon_" + i));
        }
        this.terrasteelHelmWillModel = map.get(ResourceLocationHelper.prefix("icon/will_flame"));
        for (i = 0; i < this.thirdEyeLayers.length; ++i) {
            this.thirdEyeLayers[i] = map.get(ResourceLocationHelper.prefix("icon/third_eye_" + i));
        }
        this.pyroclastGem = map.get(ResourceLocationHelper.prefix("icon/lava_pendant_gem"));
        this.crimsonGem = map.get(ResourceLocationHelper.prefix("icon/super_lava_pendant_gem"));
        this.itemFinderGem = map.get(ResourceLocationHelper.prefix("icon/itemfinder_gem"));
        this.cirrusGem = map.get(ResourceLocationHelper.prefix("icon/cloud_pendant_gem"));
        this.nimbusGem = map.get(ResourceLocationHelper.prefix("icon/super_cloud_pendant_gem"));
        this.snowflakePendantGem = map.get(ResourceLocationHelper.prefix("icon/ice_pendant_gem"));
        for (i = 0; i < this.tiaraWingIcons.length; ++i) {
            this.tiaraWingIcons[i] = map.get(ResourceLocationHelper.prefix("icon/tiara_wing_" + (i + 1)));
        }
    }

    private MiscellaneousModels() {
    }
}

