/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib.impl;

import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class BooleanAttribute
extends Attribute
implements IFormattableAttribute {
    public BooleanAttribute(String pDescriptionId, boolean defaultValue) {
        super(pDescriptionId, defaultValue ? 1.0 : 0.0);
    }

    @Override
    public MutableComponent toValueComponent(@Nullable AttributeModifier.Operation op, double value, TooltipFlag flag) {
        if (op == null) {
            return Component.m_237115_((String)("attributeslib.value.boolean." + (value > 0.0 ? "enabled" : "disabled")));
        }
        if (op == AttributeModifier.Operation.ADDITION && (int)value == 1) {
            return Component.m_237115_((String)"attributeslib.value.boolean.enable");
        }
        if (op == AttributeModifier.Operation.MULTIPLY_TOTAL && (int)value == -1) {
            return Component.m_237115_((String)"attributeslib.value.boolean.force_disable");
        }
        return Component.m_237115_((String)"attributeslib.value.boolean.invalid");
    }

    @Override
    public MutableComponent toComponent(AttributeModifier modif, TooltipFlag flag) {
        Attribute attr = this.ths();
        double value = modif.m_22218_();
        MutableComponent comp = value > 0.0 ? Component.m_237110_((String)"attributeslib.modifier.bool", (Object[])new Object[]{this.toValueComponent(modif.m_22217_(), value, flag), Component.m_237115_((String)attr.m_22087_())}).m_130940_(ChatFormatting.BLUE) : Component.m_237110_((String)"attributeslib.modifier.bool", (Object[])new Object[]{this.toValueComponent(modif.m_22217_(), value *= -1.0, flag), Component.m_237115_((String)attr.m_22087_())}).m_130940_(ChatFormatting.RED);
        return comp.m_7220_(this.getDebugInfo(modif, flag));
    }

    public double m_6740_(double value) {
        return Math.max(value, 0.0);
    }
}

