/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.apotheosis.adventure.boss.ApothBoss;
import dev.shadowsoffire.apotheosis.adventure.boss.BossRegistry;
import dev.shadowsoffire.apotheosis.adventure.commands.LootifyCommand;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class BossCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_BOSS = (ctx, builder) -> SharedSuggestionProvider.m_82981_(BossRegistry.INSTANCE.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"spawn_boss").requires(c -> c.m_6761_(2));
        builder.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"boss", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_BOSS).then(Commands.m_82129_((String)"rarity", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(LootifyCommand.SUGGEST_RARITY).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, Vec3Argument.m_120844_((CommandContext)c, (String)"pos"), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"boss"), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"rarity"))))).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, Vec3Argument.m_120844_((CommandContext)c, (String)"pos"), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"boss"), null)))).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, Vec3Argument.m_120844_((CommandContext)c, (String)"pos"), null, null)));
        builder.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"boss", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_BOSS).then(Commands.m_82129_((String)"rarity", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(LootifyCommand.SUGGEST_RARITY).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, EntityArgument.m_91452_((CommandContext)c, (String)"entity").m_20182_(), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"boss"), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"rarity"))))).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, EntityArgument.m_91452_((CommandContext)c, (String)"entity").m_20182_(), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"boss"), null)))).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, EntityArgument.m_91452_((CommandContext)c, (String)"entity").m_20182_(), null, null)));
        root.then((ArgumentBuilder)builder);
    }

    public static int spawnBoss(CommandContext<CommandSourceStack> c, Vec3 pos, @Nullable ResourceLocation bossId, @Nullable ResourceLocation rarityId) {
        Mob bossEntity;
        ApothBoss boss;
        Player summoner;
        Entity nullableSummoner = ((CommandSourceStack)c.getSource()).m_81373_();
        Player player = summoner = nullableSummoner instanceof Player ? (Player)nullableSummoner : ((CommandSourceStack)c.getSource()).m_81372_().m_45924_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 64.0, false);
        if (summoner == null) {
            ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)"No available player context!"));
            return -1;
        }
        ApothBoss apothBoss = boss = bossId == null ? (ApothBoss)BossRegistry.INSTANCE.getRandomItem(summoner.f_19796_, summoner.m_36336_(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((Level)summoner.m_9236_()), GameStagesCompat.IStaged.matches(summoner)}) : (ApothBoss)BossRegistry.INSTANCE.getValue(bossId);
        if (boss == null) {
            if (bossId == null) {
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown boss: " + bossId)));
            } else {
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)"No bosses available for the current context!"));
            }
            return -2;
        }
        if (rarityId != null) {
            DynamicHolder rarity = RarityRegistry.INSTANCE.holder(rarityId);
            if (!rarity.isBound()) {
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown rarity: " + rarityId)));
                return -3;
            }
            bossEntity = boss.createBoss((ServerLevelAccessor)summoner.m_9236_(), BlockPos.m_274446_((Position)pos), summoner.f_19796_, summoner.m_36336_(), (LootRarity)rarity.get());
        } else {
            bossEntity = boss.createBoss((ServerLevelAccessor)summoner.m_9236_(), BlockPos.m_274446_((Position)pos), summoner.f_19796_, summoner.m_36336_());
        }
        ((CommandSourceStack)c.getSource()).m_81372_().m_47205_((Entity)bossEntity);
        return 0;
    }
}

