/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.salvaging;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingMenu;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.adventure.client.GrayBufferSource;
import dev.shadowsoffire.apotheosis.adventure.client.SimpleTexButton;
import dev.shadowsoffire.apotheosis.util.DrawsOnLeft;
import dev.shadowsoffire.placebo.screen.PlaceboContainerScreen;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SalvagingScreen
extends PlaceboContainerScreen<SalvagingMenu>
implements DrawsOnLeft {
    public static final Component TITLE = Component.m_237115_((String)"container.apotheosis.salvage");
    public static final ResourceLocation TEXTURE = new ResourceLocation("apotheosis", "textures/gui/salvage.png");
    protected List<SalvagingRecipe.OutputData> results = new ArrayList<SalvagingRecipe.OutputData>();
    protected SimpleTexButton salvageBtn;

    public SalvagingScreen(SalvagingMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, TITLE);
        ((SalvagingMenu)this.f_97732_).addSlotListener((id, stack) -> this.computeResults());
        --this.f_97728_;
        --this.f_97730_;
        ++this.f_97731_;
    }

    protected void m_7856_() {
        super.m_7856_();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.salvageBtn = (SimpleTexButton)this.m_142416_((GuiEventListener)new SimpleTexButton(left + 105, top + 33, 20, 20, 196, 0, TEXTURE, 256, 256, btn -> this.f_96541_.f_91072_.m_105208_(((SalvagingMenu)this.f_97732_).f_38840_, 0), (Component)Component.m_237115_((String)"button.apotheosis.salvage")).setInactiveMessage((Component)Component.m_237115_((String)"button.apotheosis.no_salvage").m_130940_(ChatFormatting.RED)));
        this.computeResults();
    }

    public void computeResults() {
        if (this.salvageBtn == null) {
            return;
        }
        ArrayList<SalvagingRecipe.OutputData> matches = new ArrayList<SalvagingRecipe.OutputData>();
        for (int i = 0; i < 15; ++i) {
            Slot s = ((SalvagingMenu)this.f_97732_).m_38853_(i);
            ItemStack stack = s.m_7993_();
            SalvagingRecipe recipe = SalvagingMenu.findMatch((Level)Minecraft.m_91087_().f_91073_, stack);
            if (recipe == null) continue;
            for (SalvagingRecipe.OutputData d : recipe.getOutputs()) {
                int[] counts = SalvagingMenu.getSalvageCounts(d, stack);
                matches.add(new SalvagingRecipe.OutputData(d.stack, counts[0], counts[1]));
            }
        }
        ArrayList<SalvagingRecipe.OutputData> compressed = new ArrayList<SalvagingRecipe.OutputData>();
        for (SalvagingRecipe.OutputData data : matches) {
            if (data == null) continue;
            boolean success = false;
            for (SalvagingRecipe.OutputData existing : compressed) {
                if (!ItemStack.m_150942_((ItemStack)data.stack, (ItemStack)existing.stack)) continue;
                existing.min += data.min;
                existing.max += data.max;
                success = true;
                break;
            }
            if (success) continue;
            compressed.add(data);
        }
        this.results = compressed;
        this.salvageBtn.f_93623_ = !this.results.isEmpty();
    }

    public void m_88315_(GuiGraphics gfx, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(gfx);
        super.m_88315_(gfx, pMouseX, pMouseY, pPartialTick);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        int maxDisplay = Math.min(6, this.results.size());
        IntOpenHashSet skipSlots = new IntOpenHashSet();
        for (int i = 0; i < maxDisplay; ++i) {
            ItemStack display = this.results.get((int)i).stack;
            int displaySlot = -1;
            for (int slot = 0; slot < 6; ++slot) {
                if (skipSlots.contains(slot)) continue;
                ItemStack outStack = ((Slot)((SalvagingMenu)this.f_97732_).f_38839_.get(15 + slot)).m_7993_();
                if (outStack.m_41619_()) {
                    displaySlot = slot;
                    skipSlots.add(slot);
                    break;
                }
                if (outStack.m_150930_(display.m_41720_())) break;
            }
            if (displaySlot == -1) continue;
            SalvagingScreen.renderGuiItem(gfx, display, left + 134 + displaySlot % 2 * 18, top + 17 + displaySlot / 2 * 18, GrayBufferSource::new);
        }
        this.m_280072_(gfx, pMouseX, pMouseY);
    }

    public static void renderGuiItem(GuiGraphics gfx, ItemStack pStack, int pX, int pY, Function<MultiBufferSource, MultiBufferSource> wrapper) {
        boolean flag;
        Minecraft.m_91087_().f_90987_.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = gfx.m_280168_();
        posestack.m_85836_();
        posestack.m_252880_((float)pX, (float)pY, 100.0f);
        posestack.m_85837_(8.0, 8.0, 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        Minecraft mc = Minecraft.m_91087_();
        BakedModel model = mc.m_91291_().m_174264_(pStack, (Level)mc.f_91073_, (LivingEntity)mc.f_91074_, pX ^ pY);
        boolean bl = flag = !model.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Minecraft.m_91087_().m_91291_().m_115143_(pStack, ItemDisplayContext.GUI, false, posestack, wrapper.apply((MultiBufferSource)buffer), 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
    }

    protected void m_7286_(GuiGraphics gfx, float pPartialTick, int pX, int pY) {
        gfx.m_280218_(TEXTURE, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280072_(GuiGraphics gfx, int x, int y) {
        PoseStack stack = gfx.m_280168_();
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.0f, -100.0f);
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        tooltip.add(Component.m_237115_((String)"text.apotheosis.salvage_results").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        for (SalvagingRecipe.OutputData data : this.results) {
            tooltip.add(Component.m_237110_((String)"%s-%s %s", (Object[])new Object[]{data.min, data.max, data.stack.m_41786_()}));
        }
        if (tooltip.size() > 1) {
            this.drawOnLeft(gfx, tooltip, this.getGuiTop() + 29);
        }
        stack.m_85849_();
        super.m_280072_(gfx, x, y);
    }

    protected void m_280003_(GuiGraphics gfx, int mouseX, int mouseY) {
        gfx.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"text.apotheosis.results"), 133, this.f_97729_, 0x404040, false);
        super.m_280003_(gfx, mouseX, mouseY);
    }
}

