/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.google.common.base.Predicate;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.PlaceboUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.level.BlockEvent;

public class RadialAffix
extends Affix {
    public static final Codec<RadialAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(Codec.list(RadialData.CODEC)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, RadialAffix::new));
    private static Set<UUID> breakers = new HashSet<UUID>();
    protected final Map<LootRarity, List<RadialData>> values;

    public RadialAffix(Map<LootRarity, List<RadialData>> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isBreaker() && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        RadialData data = this.getTrueLevel(rarity, level);
        list.accept((Component)Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{data.x, data.y}));
    }

    public void onBreak(BlockEvent.BreakEvent e) {
        AffixInstance inst;
        Player player = e.getPlayer();
        ItemStack tool = player.m_21205_();
        Level world = player.m_9236_();
        if (!world.f_46443_ && tool.m_41782_() && (inst = AffixHelper.getAffixes(tool).get(Apoth.Affixes.RADIAL)) != null && inst.isValid() && RadialState.getState(player).isRadialMiningEnabled(player)) {
            float hardness = e.getState().m_60800_((BlockGetter)e.getLevel(), e.getPos());
            RadialAffix.breakExtraBlocks((ServerPlayer)player, e.getPos(), tool, this.getTrueLevel((LootRarity)inst.rarity().get(), inst.level()), hardness);
        }
    }

    private RadialData getTrueLevel(LootRarity rarity, float level) {
        List<RadialData> list = this.values.get(rarity);
        return list.get(Math.min(list.size() - 1, (int)Mth.m_14179_((float)level, (float)0.0f, (float)list.size())));
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static void toggleRadialState(Player player) {
        RadialState state = RadialState.getState(player);
        RadialState next = state.next();
        RadialState.setState(player, next);
        player.m_213846_((Component)Apotheosis.sysMessageHeader().m_7220_((Component)Component.m_237110_((String)"misc.apotheosis.radial_state_updated", (Object[])new Object[]{next.toComponent(), state.toComponent()}).m_130940_(ChatFormatting.YELLOW)));
    }

    public static void breakExtraBlocks(ServerPlayer player, BlockPos pos, ItemStack tool, RadialData level, float hardness) {
        if (!breakers.add(player.m_20148_())) {
            return;
        }
        try {
            RadialAffix.breakBlockRadius(player, pos, level.x, level.y, level.xOff, level.yOff, hardness);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        breakers.remove(player.m_20148_());
    }

    public static void breakBlockRadius(ServerPlayer player, BlockPos pos, int x, int y, int xOff, int yOff, float hardness) {
        Level world = player.m_9236_();
        if (x < 2 && y < 2) {
            return;
        }
        int lowerY = (int)Math.ceil((double)(-y) / 2.0);
        int upperY = (int)Math.round((double)y / 2.0);
        int lowerX = (int)Math.ceil((double)(-x) / 2.0);
        int upperX = (int)Math.round((double)x / 2.0);
        Vec3 base = player.m_20299_(0.0f);
        Vec3 look = player.m_20154_();
        double reach = player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
        Vec3 target = base.m_82520_(look.f_82479_ * reach, look.f_82480_ * reach, look.f_82481_ * reach);
        BlockHitResult trace = world.m_45547_(new ClipContext(base, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (trace == null || trace.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult res = trace;
        Direction face = res.m_82434_();
        for (int iy = lowerY; iy < upperY; ++iy) {
            for (int ix = lowerX; ix < upperX; ++ix) {
                BlockPos genPos = new BlockPos(pos.m_123341_() + ix + xOff, pos.m_123342_() + iy + yOff, pos.m_123343_());
                if (player.m_6350_().m_122434_() == Direction.Axis.X) {
                    genPos = new BlockPos(genPos.m_123341_() - (ix + xOff), genPos.m_123342_(), genPos.m_123343_() + ix + xOff);
                }
                if (face.m_122434_().m_122478_()) {
                    genPos = RadialAffix.rotateDown(genPos, iy + yOff, player.m_6350_());
                }
                if (genPos.equals((Object)pos)) continue;
                BlockState state = world.m_8055_(genPos);
                float stateHardness = state.m_60800_((BlockGetter)world, genPos);
                if (state.m_60795_() || stateHardness == -1.0f || !(stateHardness <= hardness * 3.0f) || !RadialAffix.isEffective(state, (Player)player)) continue;
                PlaceboUtil.tryHarvestBlock((ServerPlayer)player, (BlockPos)genPos);
            }
        }
    }

    static BlockPos rotateDown(BlockPos pos, int y, Direction horizontal) {
        Vec3i vec = horizontal.m_122436_();
        return new BlockPos(pos.m_123341_() + vec.m_123341_() * y, pos.m_123342_() - y, pos.m_123343_() + vec.m_123343_() * y);
    }

    static boolean isEffective(BlockState state, Player player) {
        return player.m_36298_(state);
    }

    record RadialData(int x, int y, int xOff, int yOff) {
        public static Codec<RadialData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("x").forGetter(RadialData::x), (App)Codec.INT.fieldOf("y").forGetter(RadialData::y), (App)Codec.INT.fieldOf("xOff").forGetter(RadialData::xOff), (App)Codec.INT.fieldOf("yOff").forGetter(RadialData::yOff)).apply((Applicative)inst, RadialData::new));
    }

    static enum RadialState {
        REQUIRE_NOT_SNEAKING((Predicate<Player>)((Predicate)p -> !p.m_6144_())),
        REQUIRE_SNEAKING((Predicate<Player>)((Predicate)Entity::m_6144_)),
        ENABLED((Predicate<Player>)((Predicate)p -> true)),
        DISABLED((Predicate<Player>)((Predicate)p -> false));

        private Predicate<Player> condition;

        private RadialState(Predicate<Player> condition) {
            this.condition = condition;
        }

        public boolean isRadialMiningEnabled(Player input) {
            return this.condition.apply((Object)input);
        }

        public RadialState next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case REQUIRE_NOT_SNEAKING -> REQUIRE_SNEAKING;
                case REQUIRE_SNEAKING -> ENABLED;
                case ENABLED -> DISABLED;
                case DISABLED -> REQUIRE_NOT_SNEAKING;
            };
        }

        public Component toComponent() {
            return Component.m_237115_((String)("misc.apotheosis.radial_state." + this.name().toLowerCase(Locale.ROOT)));
        }

        public static RadialState getState(Player player) {
            String str = player.getPersistentData().m_128461_("apoth.radial_state");
            try {
                return RadialState.valueOf(str);
            }
            catch (Exception ex) {
                return REQUIRE_SNEAKING;
            }
        }

        public static void setState(Player player, RadialState state) {
            player.getPersistentData().m_128359_("apoth.radial_state", state.name());
        }
    }
}

