/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class EnchantingRecipe
implements Recipe<Container> {
    public static final Serializer SERIALIZER = new Serializer();
    public static final EnchantingStatRegistry.Stats NO_MAX = new EnchantingStatRegistry.Stats(-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1);
    protected final ResourceLocation id;
    protected final ItemStack output;
    protected final Ingredient input;
    protected final EnchantingStatRegistry.Stats requirements;
    protected final EnchantingStatRegistry.Stats maxRequirements;

    public EnchantingRecipe(ResourceLocation id, ItemStack output, Ingredient input, EnchantingStatRegistry.Stats requirements, EnchantingStatRegistry.Stats maxRequirements) {
        this.id = id;
        this.output = output;
        this.input = input;
        this.requirements = requirements;
        this.maxRequirements = maxRequirements;
    }

    public boolean matches(ItemStack input, float eterna, float quanta, float arcana) {
        if (this.maxRequirements.eterna() > -1.0f && eterna > this.maxRequirements.eterna() || this.maxRequirements.quanta() > -1.0f && quanta > this.maxRequirements.quanta() || this.maxRequirements.arcana() > -1.0f && arcana > this.maxRequirements.arcana()) {
            return false;
        }
        return this.input.test(input) && eterna >= this.requirements.eterna() && quanta >= this.requirements.quanta() && arcana >= this.requirements.arcana();
    }

    public EnchantingStatRegistry.Stats getRequirements() {
        return this.requirements;
    }

    public EnchantingStatRegistry.Stats getMaxRequirements() {
        return this.maxRequirements;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    @Deprecated
    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    @Deprecated
    public ItemStack m_5874_(Container pContainer, RegistryAccess regs) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    @Deprecated
    public ItemStack m_8043_(RegistryAccess regs) {
        return this.output;
    }

    public ItemStack assemble(ItemStack input, float eterna, float quanta, float arcana) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return Apoth.RecipeTypes.INFUSION;
    }

    protected static org.apache.commons.lang3.tuple.Pair<EnchantingStatRegistry.Stats, EnchantingStatRegistry.Stats> readStats(ResourceLocation id, JsonObject obj) {
        EnchantingStatRegistry.Stats maxStats;
        EnchantingStatRegistry.Stats stats = (EnchantingStatRegistry.Stats)((Pair)EnchantingStatRegistry.Stats.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("requirements")).get().left().get()).getFirst();
        EnchantingStatRegistry.Stats stats2 = maxStats = obj.has("max_requirements") ? (EnchantingStatRegistry.Stats)((Pair)EnchantingStatRegistry.Stats.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("max_requirements")).get().left().get()).getFirst() : NO_MAX;
        if (maxStats.eterna() != -1.0f && stats.eterna() > maxStats.eterna()) {
            throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max eterna bounds (min > max).");
        }
        if (maxStats.quanta() != -1.0f && stats.quanta() > maxStats.quanta()) {
            throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max quanta bounds (min > max).");
        }
        if (maxStats.arcana() != -1.0f && stats.arcana() > maxStats.arcana()) {
            throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max arcana bounds (min > max).");
        }
        return org.apache.commons.lang3.tuple.Pair.of((Object)stats, (Object)maxStats);
    }

    @Nullable
    public static EnchantingRecipe findMatch(Level level, ItemStack input, float eterna, float quanta, float arcana) {
        ArrayList recipes = new ArrayList(level.m_7465_().m_44013_(Apoth.RecipeTypes.INFUSION));
        recipes.sort((r1, r2) -> -Float.compare(r1.requirements.eterna(), r2.requirements.eterna()));
        for (EnchantingRecipe r : recipes) {
            if (!r.matches(input, eterna, quanta, arcana)) continue;
            return r;
        }
        return null;
    }

    public static EnchantingRecipe findItemMatch(Level level, ItemStack toEnchant) {
        return level.m_7465_().m_44013_(Apoth.RecipeTypes.INFUSION).stream().filter(r -> r.getInput().test(toEnchant)).findFirst().orElse(null);
    }

    public static class Serializer
    implements RecipeSerializer<EnchantingRecipe> {
        protected static final Gson GSON = new GsonBuilder().create();

        public EnchantingRecipe fromJson(ResourceLocation id, JsonObject obj) {
            ItemStack output = CraftingHelper.getItemStack((JsonObject)obj.get("result").getAsJsonObject(), (boolean)true, (boolean)true);
            Ingredient input = Ingredient.m_43917_((JsonElement)obj.get("input"));
            org.apache.commons.lang3.tuple.Pair<EnchantingStatRegistry.Stats, EnchantingStatRegistry.Stats> requirements = EnchantingRecipe.readStats(id, obj);
            return new EnchantingRecipe(id, output, input, (EnchantingStatRegistry.Stats)requirements.getLeft(), (EnchantingStatRegistry.Stats)requirements.getRight());
        }

        public EnchantingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ItemStack output = buf.m_130267_();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            EnchantingStatRegistry.Stats stats = EnchantingStatRegistry.Stats.read(buf);
            EnchantingStatRegistry.Stats maxStats = buf.readBoolean() ? EnchantingStatRegistry.Stats.read(buf) : NO_MAX;
            return new EnchantingRecipe(id, output, input, stats, maxStats);
        }

        public void toNetwork(FriendlyByteBuf buf, EnchantingRecipe recipe) {
            buf.m_130055_(recipe.output);
            recipe.input.m_43923_(buf);
            recipe.requirements.write(buf);
            buf.writeBoolean(recipe.maxRequirements != NO_MAX);
            if (recipe.maxRequirements != NO_MAX) {
                recipe.maxRequirements.write(buf);
            }
        }
    }
}

