/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.objects;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.api.IEnchantingBlock;
import dev.shadowsoffire.placebo.recipe.VanillaPacketDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;

public class FilteringShelfBlock
extends ChiseledBookShelfBlock
implements IEnchantingBlock {
    public FilteringShelfBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public Set<Enchantment> getBlacklistedEnchantments(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof FilteringShelfTile) {
            FilteringShelfTile shelf = (FilteringShelfTile)be;
            HashSet<Enchantment> blacklist = new HashSet<Enchantment>();
            for (ItemStack s : shelf.getBooks()) {
                Enchantment ench;
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)s);
                if (enchants.size() != 1 || (ench = (Enchantment)enchants.keySet().stream().findFirst().orElse(null)) == null) continue;
                blacklist.add(ench);
            }
            return blacklist;
        }
        return Collections.emptySet();
    }

    @Override
    public float getMaxEnchantingPower(BlockState state, LevelReader world, BlockPos pos) {
        return 30.0f;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof FilteringShelfTile) {
            FilteringShelfTile shelf = (FilteringShelfTile)be;
            return (float)shelf.getBooks().size() * 0.5f;
        }
        return 0.0f;
    }

    @Override
    public float getArcanaBonus(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof FilteringShelfTile) {
            FilteringShelfTile shelf = (FilteringShelfTile)be;
            return shelf.getBooks().size();
        }
        return 0.0f;
    }

    @Override
    public ParticleOptions getTableParticle(BlockState state) {
        return (ParticleOptions)Apoth.Particles.ENCHANT_WATER.get();
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity be = pLevel.m_7702_(pPos);
        if (be instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity shelf = (ChiseledBookShelfBlockEntity)be;
            Optional hitResult = FilteringShelfBlock.m_260871_((BlockHitResult)pHit, (Direction)((Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
            if (hitResult.isEmpty()) {
                return InteractionResult.PASS;
            }
            int slot = FilteringShelfBlock.m_261279_((Vec2)((Vec2)hitResult.get()));
            if (((Boolean)pState.m_61143_((Property)f_260698_.get(slot))).booleanValue()) {
                FilteringShelfBlock.m_262380_((Level)pLevel, (BlockPos)pPos, (Player)pPlayer, (ChiseledBookShelfBlockEntity)shelf, (int)slot);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            ItemStack stack = pPlayer.m_21120_(pHand);
            if (FilteringShelfBlock.canInsert(stack)) {
                FilteringShelfBlock.m_262410_((Level)pLevel, (BlockPos)pPos, (Player)pPlayer, (ChiseledBookShelfBlockEntity)shelf, (ItemStack)stack, (int)slot);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new FilteringShelfTile(pPos, pState);
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"info.apotheosis.filtering_shelf").m_130940_(ChatFormatting.DARK_GRAY));
    }

    public static boolean canInsert(ItemStack stack) {
        return stack.m_150930_(Items.f_42690_) && EnchantedBookItem.m_41163_((ItemStack)stack).size() == 1;
    }

    public static class FilteringShelfTile
    extends ChiseledBookShelfBlockEntity {
        public FilteringShelfTile(BlockPos pPos, BlockState pState) {
            super(pPos, pState);
        }

        public boolean m_7013_(int pIndex, ItemStack pStack) {
            return FilteringShelfBlock.canInsert(pStack);
        }

        public BlockEntityType<?> m_58903_() {
            return (BlockEntityType)Ench.Tiles.FILTERING_SHELF.get();
        }

        public List<ItemStack> getBooks() {
            ArrayList<ItemStack> books = new ArrayList<ItemStack>();
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.m_8020_(i);
                if (stack.m_41619_()) continue;
                books.add(stack);
            }
            return books;
        }

        public CompoundTag m_5995_() {
            CompoundTag tag = new CompoundTag();
            this.m_183515_(tag);
            return tag;
        }

        public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
            this.m_142466_(pkt.m_131708_());
        }

        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        }

        public void m_6836_(int pSlot, ItemStack pStack) {
            super.m_6836_(pSlot, pStack);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
    }
}

