/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.compat;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.anvil.AnvilTile;
import dev.shadowsoffire.apotheosis.ench.anvil.ApothAnvilBlock;
import dev.shadowsoffire.apotheosis.ench.objects.FilteringShelfBlock;
import dev.shadowsoffire.apotheosis.util.CommonTooltipUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.Identifiers;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public class EnchHwylaPlugin
implements IWailaPlugin,
IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void register(IWailaCommonRegistration reg) {
        reg.registerBlockDataProvider((IServerDataProvider)this, AnvilTile.class);
    }

    public void registerClient(IWailaClientRegistration reg) {
        reg.registerBlockComponent((IBlockComponentProvider)this, Block.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() instanceof ApothAnvilBlock) {
            CompoundTag tag = accessor.getServerData();
            Map enchants = EnchantmentHelper.m_44882_((ListTag)tag.m_128437_("enchantments", 10));
            for (Map.Entry e : enchants.entrySet()) {
                tooltip.add(((Enchantment)e.getKey()).m_44700_(((Integer)e.getValue()).intValue()));
            }
        }
        CommonTooltipUtil.appendBlockStats(accessor.getLevel(), accessor.getBlockState(), accessor.getPosition(), arg_0 -> ((ITooltip)tooltip).add(arg_0));
        if (accessor.getBlock() == Blocks.f_50201_) {
            CommonTooltipUtil.appendTableStats(accessor.getLevel(), accessor.getPosition(), arg_0 -> ((ITooltip)tooltip).add(arg_0));
            tooltip.remove(Identifiers.MC_TOTAL_ENCHANTMENT_POWER);
        }
        if (accessor.getBlock() == Ench.Blocks.FILTERING_SHELF.get()) {
            this.handleFilteringShelf(tooltip, accessor);
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor access) {
        BlockEntity blockEntity = access.getBlockEntity();
        if (blockEntity instanceof AnvilTile) {
            AnvilTile te = (AnvilTile)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42146_);
            EnchantmentHelper.m_44865_(te.getEnchantments(), (ItemStack)stack);
            tag.m_128365_("enchantments", (Tag)stack.m_41785_());
        }
    }

    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (accessor.getBlock() == Ench.Blocks.FILTERING_SHELF.get()) {
            return IElementHelper.get().item(accessor.getPickedResult());
        }
        return currentIcon;
    }

    public ResourceLocation getUid() {
        return Apotheosis.loc("ench");
    }

    public int getDefaultPriority() {
        return 1150;
    }

    public void handleFilteringShelf(ITooltip tooltip, BlockAccessor accessor) {
        tooltip.remove(Identifiers.MC_ENCHANTMENT_POWER);
        tooltip.remove(Identifiers.MC_CHISELED_BOOKSHELF);
        tooltip.remove(Identifiers.UNIVERSAL_ITEM_STORAGE);
        if (accessor.showDetails()) {
            return;
        }
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof FilteringShelfBlock.FilteringShelfTile) {
            FilteringShelfBlock.FilteringShelfTile tile = (FilteringShelfBlock.FilteringShelfTile)blockEntity;
            Optional optional = ChiseledBookShelfBlock.m_260871_((BlockHitResult)((BlockHitResult)accessor.getHitResult()), (Direction)((Direction)accessor.getBlockState().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
            if (optional.isEmpty()) {
                return;
            }
            int slot = ChiseledBookShelfBlock.m_261279_((Vec2)((Vec2)optional.get()));
            ItemStack stack = tile.m_8020_(slot);
            if (stack.m_41619_()) {
                return;
            }
            tooltip.add(CommonComponents.f_237098_);
            IElementHelper helper = tooltip.getElementHelper();
            ArrayList<IElement> elements = new ArrayList<IElement>();
            elements.add(helper.smallItem(stack).clearCachedMessage());
            elements.add(helper.text((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)IDisplayHelper.get().humanReadableNumber((double)stack.m_41613_(), "", false)).m_130946_("\u00d7 ").m_7220_(stack.m_41786_()))).message(null));
            tooltip.add(elements);
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("StoredEnchantments")) {
                ArrayList list = new ArrayList();
                ItemStack.m_41709_(list, (ListTag)EnchantedBookItem.m_41163_((ItemStack)stack));
                for (Component c : list) {
                    tooltip.add((Component)Component.m_237113_((String)" - ").m_7220_(c));
                }
            }
        }
    }
}

