/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.cutting;

import dev.shadowsoffire.apotheosis.advancements.AdvancementTriggers;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class GemCuttingMenu
extends PlaceboContainerMenu {
    public static final int NEXT_MAT_COST = 1;
    public static final int STD_MAT_COST = 3;
    public static final int PREV_MAT_COST = 9;
    public static final List<GemCuttingRecipe> RECIPES = new ArrayList<GemCuttingRecipe>();
    protected final Player player;
    protected final ContainerLevelAccess access;
    protected final InternalItemHandler inv = new InternalItemHandler(4){

        public int getSlotLimit(int slot) {
            return slot == 0 ? 1 : super.getSlotLimit(slot);
        }
    };

    public GemCuttingMenu(int id, Inventory playerInv) {
        this(id, playerInv, ContainerLevelAccess.f_39287_);
    }

    public GemCuttingMenu(int id, Inventory playerInv, ContainerLevelAccess access) {
        super((MenuType)Adventure.Menus.GEM_CUTTING.get(), id, playerInv);
        this.player = playerInv.f_35978_;
        this.access = access;
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, this.inv, 0, 53, 25, stack -> GemItem.getGem(stack).isBound()));
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, this.inv, 1, 12, 25, stack -> stack.m_41720_() == Adventure.Items.GEM_DUST.get()));
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, this.inv, 2, 53, 68, this::matchesMainGem));
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, this.inv, 3, 94, 25, this::isValidMaterial));
        this.addPlayerSlots(playerInv, 8, 98);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.inv.getStackInSlot(0).m_41619_() && this.isValidMainGem((ItemStack)stack), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.m_41720_() == Adventure.Items.GEM_DUST.get(), 1, 2);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.matchesMainGem((ItemStack)stack), 2, 3);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.isValidMaterial((ItemStack)stack), 3, 4);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            ItemStack gem = this.inv.getStackInSlot(0);
            ItemStack left = this.inv.getStackInSlot(1);
            ItemStack bot = this.inv.getStackInSlot(2);
            ItemStack right = this.inv.getStackInSlot(3);
            for (GemCuttingRecipe r : RECIPES) {
                if (!r.matches(gem, left, bot, right)) continue;
                ItemStack out = r.getResult(gem, left, bot, right);
                r.decrementInputs(gem, left, bot, right);
                this.inv.setStackInSlot(0, out);
                this.level.m_5594_(player, player.m_20183_(), SoundEvents.f_144242_, SoundSource.BLOCKS, 1.0f, 1.5f + 0.35f * (1.0f - 2.0f * this.level.f_46441_.m_188501_()));
                AdvancementTriggers.GEM_CUT.trigger((ServerPlayer)player, out, AffixHelper.getRarity(out).getId());
                return true;
            }
        }
        return false;
    }

    protected boolean isValidMainGem(ItemStack stack) {
        DynamicHolder<Gem> gem = GemItem.getGem(stack);
        return gem.isBound() && AffixHelper.getRarity(stack) != RarityRegistry.getMaxRarity();
    }

    protected boolean isValidMaterial(ItemStack stack) {
        GemInstance mainGem = GemInstance.unsocketed(this.inv.getStackInSlot(0));
        if (!mainGem.isValidUnsocketed()) {
            return false;
        }
        DynamicHolder<LootRarity> rarity = RarityRegistry.getMaterialRarity(stack.m_41720_());
        return rarity.isBound() && Math.abs(((LootRarity)rarity.get()).ordinal() - ((LootRarity)mainGem.rarity().get()).ordinal()) <= 1;
    }

    protected boolean matchesMainGem(ItemStack stack) {
        GemInstance gem = GemInstance.unsocketed(stack);
        GemInstance mainGem = GemInstance.unsocketed(this.inv.getStackInSlot(0));
        return gem.isValidUnsocketed() && mainGem.isValidUnsocketed() && gem.gem() == mainGem.gem() && gem.rarity() == mainGem.rarity();
    }

    public boolean m_6875_(Player pPlayer) {
        return (Boolean)this.access.m_39299_((level, pos) -> level.m_8055_(pos).m_60734_() == Adventure.Blocks.GEM_CUTTING_TABLE.get(), (Object)true);
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, pos) -> this.m_150411_(pPlayer, (Container)new RecipeWrapper((IItemHandlerModifiable)this.inv)));
    }

    public static int getDustCost(LootRarity gemRarity) {
        return 1 + gemRarity.ordinal() * 2;
    }

    static {
        RECIPES.add(new RarityUpgrade());
    }

    public static interface GemCuttingRecipe {
        public boolean matches(ItemStack var1, ItemStack var2, ItemStack var3, ItemStack var4);

        public ItemStack getResult(ItemStack var1, ItemStack var2, ItemStack var3, ItemStack var4);

        public void decrementInputs(ItemStack var1, ItemStack var2, ItemStack var3, ItemStack var4);
    }

    public static class RarityUpgrade
    implements GemCuttingRecipe {
        @Override
        public boolean matches(ItemStack gem, ItemStack left, ItemStack bot, ItemStack right) {
            DynamicHolder<LootRarity> gemRarity;
            GemInstance g = GemInstance.unsocketed(gem);
            GemInstance g2 = GemInstance.unsocketed(bot);
            if (!g.isValidUnsocketed() || !g2.isValidUnsocketed() || g.gem() != g2.gem() || g.rarity() != g2.rarity()) {
                return false;
            }
            if (g.rarity() == RarityRegistry.getMaxRarity()) {
                return false;
            }
            if (left.m_41720_() != Adventure.Items.GEM_DUST.get() || left.m_41613_() < GemCuttingMenu.getDustCost((LootRarity)g.rarity().get())) {
                return false;
            }
            if (!RarityRegistry.isMaterial(right.m_41720_())) {
                return false;
            }
            DynamicHolder<LootRarity> matRarity = RarityRegistry.getMaterialRarity(right.m_41720_());
            if (matRarity == (gemRarity = g.rarity())) {
                return right.m_41613_() >= 3;
            }
            if (matRarity == RarityRegistry.next(gemRarity)) {
                return right.m_41613_() >= 1;
            }
            return matRarity == RarityRegistry.prev(gemRarity) && right.m_41613_() >= 9;
        }

        @Override
        public ItemStack getResult(ItemStack gem, ItemStack left, ItemStack bot, ItemStack right) {
            ItemStack out = gem.m_41777_();
            AffixHelper.setRarity(out, (LootRarity)RarityRegistry.next(AffixHelper.getRarity(out)).get());
            return out;
        }

        @Override
        public void decrementInputs(ItemStack gem, ItemStack left, ItemStack bot, ItemStack right) {
            DynamicHolder<LootRarity> matRarity = RarityRegistry.getMaterialRarity(right.m_41720_());
            DynamicHolder<LootRarity> gemRarity = GemInstance.unsocketed(gem).rarity();
            gem.m_41774_(1);
            left.m_41774_(GemCuttingMenu.getDustCost((LootRarity)gemRarity.get()));
            bot.m_41774_(1);
            right.m_41774_(matRarity == gemRarity ? 3 : (matRarity == RarityRegistry.next(gemRarity) ? 1 : 9));
        }
    }
}

