/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.advancements.AdvancementTriggers;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.client.BossSpawnMessage;
import dev.shadowsoffire.apotheosis.compat.PatchouliCompat;
import dev.shadowsoffire.apotheosis.ench.EnchModule;
import dev.shadowsoffire.apotheosis.ench.table.ClueMessage;
import dev.shadowsoffire.apotheosis.ench.table.StatsMessage;
import dev.shadowsoffire.apotheosis.garden.GardenModule;
import dev.shadowsoffire.apotheosis.potion.PotionModule;
import dev.shadowsoffire.apotheosis.spawn.SpawnerModule;
import dev.shadowsoffire.apotheosis.util.ModuleCondition;
import dev.shadowsoffire.apotheosis.util.ParticleMessage;
import dev.shadowsoffire.apotheosis.village.VillageModule;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.network.MessageHelper;
import dev.shadowsoffire.placebo.network.MessageProvider;
import dev.shadowsoffire.placebo.recipe.NBTIngredient;
import dev.shadowsoffire.placebo.recipe.RecipeHelper;
import dev.shadowsoffire.placebo.registry.DeferredHelper;
import dev.shadowsoffire.placebo.util.RunnableReloader;
import java.io.File;
import java.util.function.BooleanSupplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="apotheosis")
public class Apotheosis {
    public static final String MODID = "apotheosis";
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("apotheosis", "apotheosis")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final RecipeHelper HELPER = new RecipeHelper("apotheosis");
    public static File configDir;
    public static Configuration config;
    public static boolean enableEnch;
    public static boolean enableAdventure;
    public static boolean enableSpawner;
    public static boolean enablePotion;
    public static boolean enableVillage;
    public static boolean enableGarden;
    public static boolean giveBook;
    public static float localAtkStrength;

    public Apotheosis() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (enableEnch) {
            bus.register((Object)new EnchModule());
        }
        if (enableSpawner) {
            bus.register((Object)new SpawnerModule());
        }
        if (enableGarden) {
            bus.register((Object)new GardenModule());
        }
        if (enableAdventure) {
            bus.register((Object)new AdventureModule());
        }
        if (enablePotion) {
            bus.register((Object)new PotionModule());
        }
        if (enableVillage) {
            bus.register((Object)new VillageModule());
        }
        if (config.hasChanged()) {
            config.save();
        }
        bus.post((Event)new ApotheosisConstruction());
        bus.addListener(this::init);
        MinecraftForge.EVENT_BUS.addListener(this::reloads);
        MinecraftForge.EVENT_BUS.addListener(this::trackCooldown);
        MinecraftForge.EVENT_BUS.addListener(this::cmds);
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.register();
        }
        Apoth.RecipeTypes.FLETCHING.getClass();
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        MessageHelper.registerMessage((SimpleChannel)CHANNEL, (int)0, (MessageProvider)new ParticleMessage.Provider());
        MessageHelper.registerMessage((SimpleChannel)CHANNEL, (int)1, (MessageProvider)new BossSpawnMessage.Provider());
        MessageHelper.registerMessage((SimpleChannel)CHANNEL, (int)2, (MessageProvider)new ClueMessage.Provider());
        MessageHelper.registerMessage((SimpleChannel)CHANNEL, (int)3, (MessageProvider)new StatsMessage.Provider());
        e.enqueueWork(() -> {
            AdvancementTriggers.init();
            CraftingHelper.register((IConditionSerializer)new ModuleCondition.Serializer());
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void reloads(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)RunnableReloader.of(() -> MinecraftForge.EVENT_BUS.post((Event)new ApotheosisReloadEvent())));
    }

    @SubscribeEvent
    public void trackCooldown(AttackEntityEvent e) {
        Player p = e.getEntity();
        localAtkStrength = p.m_36403_(0.5f);
    }

    @SubscribeEvent
    public void cmds(RegisterCommandsEvent e) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"apoth");
        MinecraftForge.EVENT_BUS.post((Event)new ApotheosisCommandEvent((LiteralArgumentBuilder<CommandSourceStack>)builder));
        e.getDispatcher().register(builder);
    }

    public static Ingredient potionIngredient(Potion type) {
        return new NBTIngredient(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)type));
    }

    public static ResourceLocation loc(String s) {
        return new ResourceLocation(MODID, s);
    }

    static {
        enableEnch = true;
        enableAdventure = true;
        enableSpawner = true;
        enablePotion = true;
        enableVillage = true;
        enableGarden = true;
        giveBook = true;
        localAtkStrength = 1.0f;
        configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), MODID);
        config = new Configuration(new File(configDir, "apotheosis.cfg"));
        enableEnch = config.getBoolean("Enable Enchantment Module", "general", true, "If the enchantment module is enabled.");
        enableAdventure = config.getBoolean("Enable Adventure Module", "general", true, "If the adventure module is loaded.");
        enableSpawner = config.getBoolean("Enable Spawner Module", "general", true, "If the spawner module is enabled.");
        enablePotion = config.getBoolean("Enable Potion Module", "general", true, "If the potion module is loaded.");
        enableVillage = config.getBoolean("Enable Village Module", "general", true, "If the village module is loaded.");
        enableGarden = config.getBoolean("Enable Garden Module", "general", true, "If the garden module is loaded.");
        giveBook = config.getBoolean("Give Book on First Join", "general", true, "If the Chronicle of Shadows is given to new players.");
        config.setTitle("Apotheosis Module Control");
        config.setComment("This file allows individual modules of Apotheosis to be enabled or disabled.\nChanges will have no effect until the next game restart.\nThis file must match on client and server.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static class ApotheosisConstruction
    extends Event
    implements IModBusEvent {
    }

    public static class ApotheosisCommandEvent
    extends Event {
        private final LiteralArgumentBuilder<CommandSourceStack> root;

        public ApotheosisCommandEvent(LiteralArgumentBuilder<CommandSourceStack> root) {
            this.root = root;
        }

        public LiteralArgumentBuilder<CommandSourceStack> getRoot() {
            return this.root;
        }
    }

    public static class ApotheosisReloadEvent
    extends Event {
    }

    public static class ModularDeferredHelper
    extends DeferredHelper {
        protected final BooleanSupplier flag;

        public static ModularDeferredHelper create(BooleanSupplier flag) {
            ModularDeferredHelper helper = new ModularDeferredHelper(flag);
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)helper);
            return helper;
        }

        protected ModularDeferredHelper(BooleanSupplier flag) {
            super(Apotheosis.MODID);
            this.flag = flag;
        }

        @SubscribeEvent
        public void register(RegisterEvent e) {
            if (this.flag.getAsBoolean()) {
                super.register(e);
            }
        }
    }
}

