/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.village;

import com.mojang.datafixers.util.Pair;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VillageStructures {
    private static void addPieceToPool(Registry<StructureTemplatePool> templatePoolRegistry, Holder<StructureProcessorList> emptyProcessor, ResourceLocation poolRL, String nbtPieceRL, StructureTemplatePool.Projection projection, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = poolRL.m_135815_().endsWith("streets") ? (SinglePoolElement)SinglePoolElement.m_210512_((String)nbtPieceRL, emptyProcessor).apply(projection) : (SinglePoolElement)SinglePoolElement.m_210531_((String)nbtPieceRL, emptyProcessor).apply(projection);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }

    @SubscribeEvent
    public static void addStructures(ServerAboutToStartEvent event) {
        if (!((Boolean)APConfig.WORLD_CONFIG.enableVillagerStructures.get()).booleanValue()) {
            return;
        }
        Holder.Reference emptyProcessor = event.getServer().m_206579_().m_175515_(Registries.f_257011_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft:empty")));
        Registry templatePoolRegistry = event.getServer().m_206579_().m_175515_(Registries.f_256948_);
        for (String biome : new String[]{"desert", "snowy", "plains", "savanna", "taiga"}) {
            AdvancedPeripherals.debug("Register generating scientist_" + biome + " village house");
            VillageStructures.addPieceToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Holder<StructureProcessorList>)emptyProcessor, new ResourceLocation("village/" + biome + "/houses"), "advancedperipherals:villages/scientist_" + biome, StructureTemplatePool.Projection.RIGID, (Integer)APConfig.WORLD_CONFIG.villagerStructureWeight.get());
        }
    }
}

