/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.configuration;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import de.srendi.advancedperipherals.common.configuration.GeneralConfig;
import de.srendi.advancedperipherals.common.configuration.IAPConfig;
import de.srendi.advancedperipherals.common.configuration.MetaphysicsConfig;
import de.srendi.advancedperipherals.common.configuration.PeripheralsConfig;
import de.srendi.advancedperipherals.common.configuration.WorldConfig;
import java.nio.file.Path;
import java.util.function.Function;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class APConfig
extends ModConfig {
    public static final ConfigFileHandler CONFIG_FILE_HANDLER = new ConfigFileHandler();
    public static final GeneralConfig GENERAL_CONFIG = new GeneralConfig();
    public static final PeripheralsConfig PERIPHERALS_CONFIG = new PeripheralsConfig();
    public static final MetaphysicsConfig METAPHYSICS_CONFIG = new MetaphysicsConfig();
    public static final WorldConfig WORLD_CONFIG = new WorldConfig();

    public APConfig(IAPConfig config, ModContainer container) {
        super(config.getType(), (IConfigSpec)config.getConfigSpec(), container, "Advancedperipherals/" + config.getFileName() + ".toml");
    }

    public static void register(ModLoadingContext context) {
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve("Advancedperipherals"));
        ModContainer modContainer = context.getActiveContainer();
        modContainer.addConfig((ModConfig)new APConfig(GENERAL_CONFIG, modContainer));
        modContainer.addConfig((ModConfig)new APConfig(PERIPHERALS_CONFIG, modContainer));
        modContainer.addConfig((ModConfig)new APConfig(METAPHYSICS_CONFIG, modContainer));
        modContainer.addConfig((ModConfig)new APConfig(WORLD_CONFIG, modContainer));
    }

    public ConfigFileTypeHandler getHandler() {
        return CONFIG_FILE_HANDLER;
    }

    public static class ConfigFileHandler
    extends ConfigFileTypeHandler {
        public static Path getPath(Path path) {
            if (path.endsWith("serverconfig")) {
                return FMLPaths.CONFIGDIR.get();
            }
            return path;
        }

        public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
            return super.reader(ConfigFileHandler.getPath(configBasePath));
        }

        public void unload(Path configBasePath, ModConfig config) {
            super.unload(ConfigFileHandler.getPath(configBasePath), config);
        }
    }
}

