/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.machines.marker.TileFlexMarker;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.MapMulti;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public final class FlexMarkerMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final TileFlexMarker.Movable movable;
    private final int amount;

    public FlexMarkerMessage(Level world, BlockPos pos, TileFlexMarker.Movable movable, int amount) {
        this.pos = pos;
        this.dim = world != null ? world.m_46472_() : Level.f_46428_;
        this.movable = movable;
        this.amount = amount;
    }

    public FlexMarkerMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_());
        this.movable = (TileFlexMarker.Movable)buffer.m_130066_(TileFlexMarker.Movable.class);
        this.amount = buffer.m_130242_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos).m_130085_(this.dim.m_135782_());
        buffer.m_130068_((Enum)this.movable);
        buffer.m_130130_(this.amount);
    }

    public static void onReceive(FlexMarkerMessage message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> world = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> world.map(w -> w.m_7702_(message.pos)).flatMap(MapMulti.optCast(TileFlexMarker.class)).ifPresent(m -> {
            m.move(message.movable, message.amount);
            PacketHandler.sendToClient(new ClientSyncMessage(m), Objects.requireNonNull(m.m_58904_()));
        }));
    }
}

